/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.ref.Ref;
import com.powsybl.iidm.network.AcDcConverter;
import com.powsybl.iidm.network.Component;
import com.powsybl.iidm.network.DcBus;
import com.powsybl.iidm.network.DcConnectable;
import com.powsybl.iidm.network.DcGround;
import com.powsybl.iidm.network.DcLine;
import com.powsybl.iidm.network.DcNode;
import com.powsybl.iidm.network.DcSwitch;
import com.powsybl.iidm.network.DcTerminal;
import com.powsybl.iidm.network.DcTopologyVisitor;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractDcTopologyVisitable;
import com.powsybl.iidm.network.impl.AbstractNetwork;
import com.powsybl.iidm.network.impl.DcGroundImpl;
import com.powsybl.iidm.network.impl.DcLineImpl;
import com.powsybl.iidm.network.impl.DcTerminalImpl;
import com.powsybl.iidm.network.impl.MultiVariantObject;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.SubnetworkImpl;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class DcNodeImpl
extends AbstractDcTopologyVisitable<DcNode>
implements DcNode,
MultiVariantObject {
    public static final String NOMINAL_V_ATTRIBUTE = "nominalV";
    private final Ref<NetworkImpl> networkRef;
    private final Ref<SubnetworkImpl> subnetworkRef;
    protected boolean removed = false;
    private double nominalV;
    private final List<DcTerminal> dcTerminals;
    private final TDoubleArrayList v;
    private final TIntArrayList connectedComponentNumber;
    private final TIntArrayList dcComponentNumber;

    DcNodeImpl(Ref<NetworkImpl> ref, Ref<SubnetworkImpl> subnetworkRef, String id, String name, boolean fictitious, double nominalV) {
        super(id, name, fictitious);
        this.networkRef = Objects.requireNonNull(ref);
        this.subnetworkRef = subnetworkRef;
        this.nominalV = nominalV;
        int variantArraySize = ((NetworkImpl)ref.get()).getVariantManager().getVariantArraySize();
        this.dcTerminals = new ArrayList<DcTerminal>();
        this.v = new TDoubleArrayList(variantArraySize);
        this.connectedComponentNumber = new TIntArrayList(variantArraySize);
        this.dcComponentNumber = new TIntArrayList(variantArraySize);
        for (int i = 0; i < variantArraySize; ++i) {
            this.v.add(Double.NaN);
            this.connectedComponentNumber.add(-1);
            this.dcComponentNumber.add(-1);
        }
    }

    @Override
    protected String getTypeDescription() {
        return "DC Node";
    }

    public Network getParentNetwork() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)"network");
        return Optional.ofNullable((Network)this.subnetworkRef.get()).orElse(this.getNetwork());
    }

    @Override
    public NetworkImpl getNetwork() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)"network");
        return (NetworkImpl)this.networkRef.get();
    }

    public double getNominalV() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)NOMINAL_V_ATTRIBUTE);
        return this.nominalV;
    }

    public DcNode setNominalV(double nominalV) {
        ValidationUtil.checkModifyOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)NOMINAL_V_ATTRIBUTE);
        ValidationUtil.checkNominalV((Validable)this, (double)nominalV);
        double oldValue = this.nominalV;
        this.nominalV = nominalV;
        this.getNetwork().getListeners().notifyUpdate(this, NOMINAL_V_ATTRIBUTE, (Object)oldValue, (Object)nominalV);
        return this;
    }

    public DcBus getDcBus() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)"dcBus");
        return ((AbstractNetwork)this.getParentNetwork()).getDcTopologyModel().getDcBusOfDcNode(this.getId());
    }

    public double getV() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)"v");
        return this.v.get(this.getNetwork().getVariantIndex());
    }

    public DcNode setV(double v) {
        ValidationUtil.checkModifyOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)"v");
        int variantIndex = this.getNetwork().getVariantIndex();
        double oldValue = this.v.set(variantIndex, v);
        String variantId = this.getNetwork().getVariantManager().getVariantId(variantIndex);
        this.getNetwork().getListeners().notifyUpdate(this, "v", variantId, (Object)oldValue, (Object)v);
        return this;
    }

    public void addDcTerminal(DcTerminalImpl dcTerminal) {
        this.dcTerminals.add(dcTerminal);
    }

    public void removeDcTerminal(DcTerminalImpl dcTerminal) {
        if (!this.dcTerminals.remove(dcTerminal)) {
            throw new IllegalStateException("DcTerminal " + String.valueOf(dcTerminal) + " not found");
        }
    }

    public void setConnectedComponentNumber(int connectedComponentNumber) {
        int variantIndex = ((NetworkImpl)this.networkRef.get()).getVariantIndex();
        int oldValue = this.connectedComponentNumber.set(variantIndex, connectedComponentNumber);
        String variantId = ((NetworkImpl)this.networkRef.get()).getVariantManager().getVariantId(variantIndex);
        ((NetworkImpl)this.networkRef.get()).getListeners().notifyUpdate(this, "connectedComponentNumber", variantId, (Object)oldValue, (Object)connectedComponentNumber);
    }

    public Component getConnectedComponent() {
        NetworkImpl.ConnectedComponentsManager ccm = ((NetworkImpl)this.networkRef.get()).getConnectedComponentsManager();
        ccm.update();
        return ccm.getComponent(this.connectedComponentNumber.get(((NetworkImpl)this.networkRef.get()).getVariantIndex()));
    }

    public void setDcComponentNumber(int componentNumber) {
        int variantIndex = ((NetworkImpl)this.networkRef.get()).getVariantIndex();
        int oldValue = this.dcComponentNumber.set(variantIndex, componentNumber);
        String variantId = ((NetworkImpl)this.networkRef.get()).getVariantManager().getVariantId(variantIndex);
        ((NetworkImpl)this.networkRef.get()).getListeners().notifyUpdate(this, "dcComponentNumber", variantId, (Object)oldValue, (Object)this.dcComponentNumber);
    }

    public Component getDcComponent() {
        NetworkImpl.DcComponentsManager dcm = ((NetworkImpl)this.networkRef.get()).getDcComponentsManager();
        dcm.update();
        return dcm.getComponent(this.dcComponentNumber.get(((NetworkImpl)this.networkRef.get()).getVariantIndex()));
    }

    public int getDcTerminalCount() {
        return this.getDcTerminals().size();
    }

    public List<DcTerminal> getDcTerminals() {
        return this.dcTerminals;
    }

    public Stream<DcTerminal> getDcTerminalStream() {
        return this.getDcTerminals().stream();
    }

    public int getConnectedDcTerminalCount() {
        return (int)this.getConnectedDcTerminalStream().count();
    }

    @Override
    public List<DcTerminal> getConnectedDcTerminals() {
        return this.getConnectedDcTerminalStream().toList();
    }

    @Override
    public Stream<DcTerminal> getConnectedDcTerminalStream() {
        return this.getDcTerminalStream().filter(DcTerminal::isConnected);
    }

    public void visitConnectedEquipments(DcTopologyVisitor visitor) {
        DcNodeImpl.visitEquipments(this.getConnectedDcTerminals(), visitor);
    }

    public void visitConnectedOrConnectableEquipments(DcTopologyVisitor visitor) {
        DcNodeImpl.visitEquipments(this.getDcTerminals(), visitor);
    }

    static void visitEquipments(Iterable<DcTerminal> dcTerminals, DcTopologyVisitor visitor) {
        Objects.requireNonNull(visitor);
        block5: for (DcTerminal dcTerminal : dcTerminals) {
            DcConnectable dcConnectable = dcTerminal.getDcConnectable();
            switch (dcConnectable.getType()) {
                case DC_GROUND: {
                    visitor.visitDcGround((DcGround)((DcGroundImpl)dcConnectable));
                    continue block5;
                }
                case DC_LINE: {
                    visitor.visitDcLine((DcLine)((DcLineImpl)dcConnectable), dcTerminal.getSide());
                    continue block5;
                }
                case LINE_COMMUTATED_CONVERTER: 
                case VOLTAGE_SOURCE_CONVERTER: {
                    AcDcConverter converter = (AcDcConverter)dcConnectable;
                    visitor.visitAcDcConverter(converter, dcTerminal.getTerminalNumber());
                    continue block5;
                }
            }
            throw new IllegalStateException();
        }
    }

    public void remove() {
        NetworkImpl network = this.getNetwork();
        List<DcTerminal> dcTerminalList = this.getDcTerminals();
        if (!dcTerminalList.isEmpty()) {
            throw new PowsyblException("Cannot remove DC node '" + this.getId() + "' because DC connectable '" + dcTerminalList.get(0).getDcConnectable().getId() + "' is connected to it");
        }
        for (DcSwitch dcSwitch : network.getDcSwitches()) {
            if (dcSwitch.getDcNode1() != this && dcSwitch.getDcNode2() != this) continue;
            throw new PowsyblException("Cannot remove DC node '" + this.getId() + "' because DC switch '" + dcSwitch.getId() + "' is connected to it");
        }
        network.getListeners().notifyBeforeRemoval(this);
        network.getIndex().remove(this);
        ((AbstractNetwork)this.getParentNetwork()).getDcTopologyModel().removeDcNode(this.getId());
        network.getListeners().notifyAfterRemoval(this.id);
        this.removed = true;
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        this.v.ensureCapacity(this.v.size() + number);
        this.connectedComponentNumber.ensureCapacity(this.connectedComponentNumber.size() + number);
        this.dcComponentNumber.ensureCapacity(this.dcComponentNumber.size() + number);
        for (int i = 0; i < number; ++i) {
            this.v.add(this.v.get(sourceIndex));
            this.connectedComponentNumber.add(this.connectedComponentNumber.get(sourceIndex));
            this.dcComponentNumber.add(this.dcComponentNumber.get(sourceIndex));
        }
    }

    @Override
    public void reduceVariantArraySize(int number) {
        for (int i = 0; i < number; ++i) {
            this.v.removeAt(this.v.size() - 1);
            this.connectedComponentNumber.removeAt(this.connectedComponentNumber.size() - 1);
            this.dcComponentNumber.removeAt(this.dcComponentNumber.size() - 1);
        }
    }

    @Override
    public void deleteVariantArrayElement(int index) {
        super.deleteVariantArrayElement(index);
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        for (int index : indexes) {
            this.v.set(index, this.v.get(sourceIndex));
            this.connectedComponentNumber.set(index, this.connectedComponentNumber.get(sourceIndex));
            this.dcComponentNumber.set(index, this.dcComponentNumber.get(sourceIndex));
        }
    }
}

