/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.ref.Ref;
import com.powsybl.iidm.network.DcNode;
import com.powsybl.iidm.network.DcSwitch;
import com.powsybl.iidm.network.DcSwitchAdder;
import com.powsybl.iidm.network.DcSwitchKind;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractIdentifiableAdder;
import com.powsybl.iidm.network.impl.AbstractNetwork;
import com.powsybl.iidm.network.impl.DcSwitchImpl;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.SubnetworkImpl;
import java.util.Objects;
import java.util.Optional;

public class DcSwitchAdderImpl
extends AbstractIdentifiableAdder<DcSwitchAdderImpl>
implements DcSwitchAdder {
    private final Ref<NetworkImpl> networkRef;
    private final Ref<SubnetworkImpl> subnetworkRef;
    private DcSwitchKind kind;
    private String dcNode1Id;
    private String dcNode2Id;
    private Boolean open;

    DcSwitchAdderImpl(Ref<NetworkImpl> ref, Ref<SubnetworkImpl> subnetworkRef) {
        this.networkRef = ref;
        this.subnetworkRef = subnetworkRef;
    }

    public DcSwitchAdder setKind(DcSwitchKind kind) {
        this.kind = Objects.requireNonNull(kind);
        return this;
    }

    public DcSwitchAdder setDcNode1(String dcNode1) {
        this.dcNode1Id = dcNode1;
        return this;
    }

    public DcSwitchAdder setDcNode2(String dcNode2) {
        this.dcNode2Id = dcNode2;
        return this;
    }

    public DcSwitchAdder setOpen(boolean open) {
        this.open = open;
        return this;
    }

    public DcSwitch add() {
        String id = this.checkAndGetUniqueId();
        DcNode dcNode1 = ValidationUtil.checkAndGetDcNode((Network)this.getNetwork().getParentNetwork(), (Validable)this, (String)this.dcNode1Id, (String)"dcNode1");
        DcNode dcNode2 = ValidationUtil.checkAndGetDcNode((Network)this.getNetwork().getParentNetwork(), (Validable)this, (String)this.dcNode2Id, (String)"dcNode2");
        ValidationUtil.checkSameParentNetwork((Network)this.getParentNetwork(), (Validable)this, (DcNode)dcNode1, (DcNode)dcNode2);
        if (this.kind == null) {
            throw new ValidationException((Validable)this, "kind is not set");
        }
        if (this.open == null) {
            throw new ValidationException((Validable)this, "open is not set");
        }
        DcSwitchImpl dcSwitch = new DcSwitchImpl(this.networkRef, this.subnetworkRef, id, this.getName(), this.isFictitious(), this.kind, dcNode1, dcNode2, this.open);
        this.getNetwork().getIndex().checkAndAdd(dcSwitch);
        this.getNetwork().getListeners().notifyCreation(dcSwitch);
        this.getParentNetwork().getDcTopologyModel().addDcSwitchToTopology(dcSwitch, this.dcNode1Id, this.dcNode2Id);
        return dcSwitch;
    }

    @Override
    protected NetworkImpl getNetwork() {
        return (NetworkImpl)this.networkRef.get();
    }

    private AbstractNetwork getParentNetwork() {
        return Optional.ofNullable((AbstractNetwork)this.subnetworkRef.get()).orElse(this.getNetwork());
    }

    @Override
    protected String getTypeDescription() {
        return "DC Switch";
    }
}

