/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.ref.Ref;
import com.powsybl.commons.util.trove.TBooleanArrayList;
import com.powsybl.iidm.network.DcNode;
import com.powsybl.iidm.network.DcSwitch;
import com.powsybl.iidm.network.DcSwitchKind;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractIdentifiable;
import com.powsybl.iidm.network.impl.AbstractNetwork;
import com.powsybl.iidm.network.impl.MultiVariantObject;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.SubnetworkImpl;
import com.powsybl.iidm.network.impl.VariantManagerHolder;
import java.util.Objects;
import java.util.Optional;

public class DcSwitchImpl
extends AbstractIdentifiable<DcSwitch>
implements DcSwitch,
MultiVariantObject {
    public static final String OPEN_ATTRIBUTE = "open";
    private final Ref<NetworkImpl> networkRef;
    private final Ref<SubnetworkImpl> subnetworkRef;
    private final DcSwitchKind kind;
    private final DcNode dcNode1;
    private final DcNode dcNode2;
    private final TBooleanArrayList open;
    private boolean removed = false;

    DcSwitchImpl(Ref<NetworkImpl> ref, Ref<SubnetworkImpl> subnetworkRef, String id, String name, boolean fictitious, DcSwitchKind kind, DcNode dcNode1, DcNode dcNode2, boolean open) {
        super(id, name, fictitious);
        this.networkRef = Objects.requireNonNull(ref);
        this.subnetworkRef = subnetworkRef;
        this.kind = kind;
        this.dcNode1 = dcNode1;
        this.dcNode2 = dcNode2;
        int variantArraySize = this.getVariantManagerHolder().getVariantManager().getVariantArraySize();
        this.open = new TBooleanArrayList(variantArraySize);
        for (int i = 0; i < variantArraySize; ++i) {
            this.open.add(open);
        }
    }

    @Override
    public NetworkImpl getNetwork() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)"network");
        return (NetworkImpl)this.networkRef.get();
    }

    public Network getParentNetwork() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)"network");
        return Optional.ofNullable((Network)this.subnetworkRef.get()).orElse(this.getNetwork());
    }

    protected VariantManagerHolder getVariantManagerHolder() {
        return this.getNetwork();
    }

    @Override
    protected String getTypeDescription() {
        return "DC Switch";
    }

    public DcSwitchKind getKind() {
        return this.kind;
    }

    public DcNode getDcNode1() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)"dcNode1");
        return this.dcNode1;
    }

    public DcNode getDcNode2() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)"dcNode2");
        return this.dcNode2;
    }

    public boolean isOpen() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)OPEN_ATTRIBUTE);
        return this.open.get(this.getVariantManagerHolder().getVariantIndex());
    }

    public DcSwitch setOpen(boolean open) {
        ValidationUtil.checkModifyOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)OPEN_ATTRIBUTE);
        int variantIndex = this.getVariantManagerHolder().getVariantIndex();
        boolean oldValue = this.open.get(variantIndex);
        if (oldValue != open) {
            this.open.set(variantIndex, open);
            ((AbstractNetwork)this.getParentNetwork()).getDcTopologyModel().invalidateCache();
            String variantId = this.getVariantManagerHolder().getVariantManager().getVariantId(variantIndex);
            this.getNetwork().getListeners().notifyUpdate(this, OPEN_ATTRIBUTE, variantId, (Object)oldValue, (Object)open);
        }
        return this;
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        this.open.ensureCapacity(this.open.size() + number);
        for (int i = 0; i < number; ++i) {
            this.open.add(this.open.get(sourceIndex));
        }
    }

    @Override
    public void reduceVariantArraySize(int number) {
        for (int i = 0; i < number; ++i) {
            this.open.removeAt(this.open.size() - 1);
        }
    }

    @Override
    public void deleteVariantArrayElement(int index) {
        super.deleteVariantArrayElement(index);
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        for (int index : indexes) {
            this.open.set(index, this.open.get(sourceIndex));
        }
    }

    public void remove() {
        NetworkImpl network = this.getNetwork();
        network.getListeners().notifyBeforeRemoval(this);
        network.getIndex().remove(this);
        ((AbstractNetwork)this.getParentNetwork()).getDcTopologyModel().removeDcSwitch(this.getId());
        network.getListeners().notifyAfterRemoval(this.id);
        this.removed = true;
    }
}

