/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.ref.Ref;
import com.powsybl.commons.util.trove.TBooleanArrayList;
import com.powsybl.iidm.network.DcBus;
import com.powsybl.iidm.network.DcConnectable;
import com.powsybl.iidm.network.DcNode;
import com.powsybl.iidm.network.DcTerminal;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.TerminalNumber;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractAcDcConverter;
import com.powsybl.iidm.network.impl.AbstractDcConnectable;
import com.powsybl.iidm.network.impl.AbstractNetwork;
import com.powsybl.iidm.network.impl.MultiVariantObject;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.VariantManagerHolder;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.Objects;

public class DcTerminalImpl
implements DcTerminal,
MultiVariantObject {
    private final Ref<? extends VariantManagerHolder> network;
    private DcConnectable<?> dcConnectable;
    private final TwoSides side;
    private final TerminalNumber terminalNumber;
    private final DcNode dcNode;
    protected final TDoubleArrayList p;
    protected final TDoubleArrayList i;
    private final TBooleanArrayList connected;
    private boolean removed = false;

    DcTerminalImpl(Ref<? extends VariantManagerHolder> network, TwoSides side, TerminalNumber terminalNumber, DcNode dcNode, boolean connected) {
        if (side != null && terminalNumber != null) {
            throw new IllegalStateException("cannot have both side and number");
        }
        this.network = Objects.requireNonNull(network);
        this.side = side;
        this.terminalNumber = terminalNumber;
        this.dcNode = Objects.requireNonNull(dcNode);
        int variantArraySize = this.getVariantManagerHolder().getVariantManager().getVariantArraySize();
        this.connected = new TBooleanArrayList(variantArraySize);
        this.p = new TDoubleArrayList(variantArraySize);
        this.i = new TDoubleArrayList(variantArraySize);
        for (int iVar = 0; iVar < variantArraySize; ++iVar) {
            this.connected.add(connected);
            this.p.add(Double.NaN);
            this.i.add(Double.NaN);
        }
    }

    protected VariantManagerHolder getVariantManagerHolder() {
        return (VariantManagerHolder)this.network.get();
    }

    public DcConnectable getDcConnectable() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.dcConnectable.getId(), (boolean)this.removed);
        return this.dcConnectable;
    }

    public TwoSides getSide() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.dcConnectable.getId(), (boolean)this.removed);
        return this.side;
    }

    public TerminalNumber getTerminalNumber() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.dcConnectable.getId(), (boolean)this.removed);
        return this.terminalNumber;
    }

    public DcNode getDcNode() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.dcConnectable.getId(), (boolean)this.removed);
        return this.dcNode;
    }

    public double getP() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.dcConnectable.getId(), (boolean)this.removed);
        return this.p.get(this.getVariantManagerHolder().getVariantIndex());
    }

    public DcTerminal setP(double p) {
        ValidationUtil.checkModifyOfRemovedEquipment((String)this.dcConnectable.getId(), (boolean)this.removed);
        int variantIndex = this.getVariantManagerHolder().getVariantIndex();
        double oldValue = this.p.set(variantIndex, p);
        String variantId = ((VariantManagerHolder)this.network.get()).getVariantManager().getVariantId(variantIndex);
        this.getNetwork().getListeners().notifyUpdate((Identifiable<?>)this.dcConnectable, () -> "p_dc" + this.getAttributeSideOrNumberSuffix(), variantId, (Object)oldValue, (Object)p);
        return this;
    }

    public double getI() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.dcConnectable.getId(), (boolean)this.removed);
        return this.i.get(this.getVariantManagerHolder().getVariantIndex());
    }

    public DcTerminal setI(double i) {
        ValidationUtil.checkModifyOfRemovedEquipment((String)this.dcConnectable.getId(), (boolean)this.removed);
        int variantIndex = this.getVariantManagerHolder().getVariantIndex();
        double oldValue = this.i.set(variantIndex, i);
        String variantId = ((VariantManagerHolder)this.network.get()).getVariantManager().getVariantId(variantIndex);
        this.getNetwork().getListeners().notifyUpdate((Identifiable<?>)this.dcConnectable, () -> "i_dc" + this.getAttributeSideOrNumberSuffix(), variantId, (Object)oldValue, (Object)i);
        return this;
    }

    public boolean isConnected() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.dcConnectable.getId(), (boolean)this.removed);
        return this.connected.get(this.getVariantManagerHolder().getVariantIndex());
    }

    public DcTerminal setConnected(boolean connected) {
        ValidationUtil.checkModifyOfRemovedEquipment((String)this.dcConnectable.getId(), (boolean)this.removed);
        int variantIndex = this.getVariantManagerHolder().getVariantIndex();
        boolean oldValue = this.connected.set(variantIndex, connected);
        if (oldValue != connected) {
            ((AbstractNetwork)this.dcConnectable.getParentNetwork()).getDcTopologyModel().invalidateCache();
            String variantId = ((VariantManagerHolder)this.network.get()).getVariantManager().getVariantId(variantIndex);
            this.getNetwork().getListeners().notifyUpdate((Identifiable<?>)this.dcConnectable, () -> "connected_dc" + this.getAttributeSideOrNumberSuffix(), variantId, (Object)oldValue, (Object)connected);
        }
        return this;
    }

    public DcBus getDcBus() {
        return this.isConnected() ? this.dcNode.getDcBus() : null;
    }

    public void remove() {
        this.removed = true;
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        this.connected.ensureCapacity(this.connected.size() + number);
        this.p.ensureCapacity(this.p.size() + number);
        this.i.ensureCapacity(this.i.size() + number);
        for (int iVar = 0; iVar < number; ++iVar) {
            this.connected.add(this.connected.get(sourceIndex));
            this.p.add(this.p.get(sourceIndex));
            this.i.add(this.i.get(sourceIndex));
        }
    }

    @Override
    public void reduceVariantArraySize(int number) {
        for (int iVar = 0; iVar < number; ++iVar) {
            this.connected.removeAt(this.connected.size() - 1);
            this.p.removeAt(this.i.size() - 1);
            this.i.removeAt(this.i.size() - 1);
        }
    }

    @Override
    public void deleteVariantArrayElement(int index) {
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        for (int index : indexes) {
            this.connected.set(index, this.connected.get(sourceIndex));
            this.p.set(index, this.p.get(sourceIndex));
            this.i.set(index, this.i.get(sourceIndex));
        }
    }

    <I extends DcConnectable<I>> void setDcConnectable(DcConnectable<I> dcConnectable) {
        this.dcConnectable = dcConnectable;
    }

    NetworkImpl getNetwork() {
        DcConnectable<?> dcConnectable = this.dcConnectable;
        if (dcConnectable instanceof AbstractDcConnectable) {
            AbstractDcConnectable abstractDcConnectable = (AbstractDcConnectable)dcConnectable;
            return abstractDcConnectable.getNetwork();
        }
        dcConnectable = this.dcConnectable;
        if (dcConnectable instanceof AbstractAcDcConverter) {
            AbstractAcDcConverter abstractDcConverter = (AbstractAcDcConverter)dcConnectable;
            return abstractDcConverter.getNetwork();
        }
        throw new IllegalStateException("Unexpected dcConnectable type: " + this.dcConnectable.getClass().getName());
    }

    String getAttributeSideOrNumberSuffix() {
        return String.valueOf(this.side != null ? Integer.valueOf(this.side.getNum()) : "") + String.valueOf(this.terminalNumber != null ? Integer.valueOf(this.terminalNumber.getNum()) : "");
    }
}

