/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.ref.Ref;
import com.powsybl.commons.ref.RefChain;
import com.powsybl.iidm.network.DcBus;
import com.powsybl.iidm.network.DcTopologyVisitable;
import com.powsybl.iidm.network.impl.AbstractIdentifiable;
import com.powsybl.iidm.network.impl.DcBusImpl;
import com.powsybl.iidm.network.impl.DcNodeImpl;
import com.powsybl.iidm.network.impl.DcSwitchImpl;
import com.powsybl.iidm.network.impl.DcTerminalImpl;
import com.powsybl.iidm.network.impl.MultiVariantObject;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.SubnetworkImpl;
import com.powsybl.iidm.network.impl.Variant;
import com.powsybl.iidm.network.impl.VariantArray;
import com.powsybl.iidm.network.impl.VariantManagerHolder;
import com.powsybl.iidm.network.util.Identifiables;
import com.powsybl.math.graph.TraversalType;
import com.powsybl.math.graph.TraverseResult;
import com.powsybl.math.graph.UndirectedGraphImpl;
import com.powsybl.math.graph.UndirectedGraphListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public class DcTopologyModel
implements MultiVariantObject {
    public static final int DEFAULT_DC_NODE_INDEX_LIMIT = 1000;
    private static final String NOT_FOUND_IN_THE_NETWORK = "' not found in the network";
    public static final int DC_NODE_INDEX_LIMIT = DcTopologyModel.loadDcNodeIndexLimit(PlatformConfig.defaultConfig());
    private Ref<NetworkImpl> networkRef;
    private Ref<SubnetworkImpl> subnetworkRef;
    private final UndirectedGraphImpl<DcNodeImpl, DcSwitchImpl> graph = new UndirectedGraphImpl(DC_NODE_INDEX_LIMIT);
    private final Map<String, Integer> dcNodes = new HashMap<String, Integer>();
    private final Map<String, Integer> dcSwitches = new HashMap<String, Integer>();
    private final VariantArray<VariantImpl> variants;
    final CalculatedDcBusTopology calculatedDcBusTopology = new CalculatedDcBusTopology();

    public DcTopologyModel(RefChain<NetworkImpl> networkRef, RefChain<SubnetworkImpl> subnetworkRef) {
        this.networkRef = (Ref)Objects.requireNonNull(networkRef);
        this.subnetworkRef = (Ref)Objects.requireNonNull(subnetworkRef);
        this.variants = new VariantArray<VariantImpl>((Ref<VariantManagerHolder>)networkRef, VariantImpl::new);
        this.graph.addListener((UndirectedGraphListener)new UndirectedGraphListener<DcNodeImpl, DcSwitchImpl>(){

            public void vertexAdded(int v) {
                DcTopologyModel.this.invalidateCache();
            }

            public void vertexObjectSet(int v, DcNodeImpl obj) {
                DcTopologyModel.this.invalidateCache();
            }

            public void vertexRemoved(int v, DcNodeImpl obj) {
                DcTopologyModel.this.invalidateCache();
            }

            public void allVerticesRemoved() {
                DcTopologyModel.this.invalidateCache();
            }

            public void edgeAdded(int e, DcSwitchImpl obj) {
                DcTopologyModel.this.invalidateCache();
            }

            public void edgeBeforeRemoval(int e, DcSwitchImpl obj) {
            }

            public void edgeRemoved(int e, DcSwitchImpl obj) {
                DcTopologyModel.this.invalidateCache();
            }

            public void allEdgesBeforeRemoval(Collection<DcSwitchImpl> obj) {
            }

            public void allEdgesRemoved(Collection<DcSwitchImpl> obj) {
                DcTopologyModel.this.invalidateCache();
            }
        });
    }

    void updateRef(Ref<NetworkImpl> networkRef, Ref<SubnetworkImpl> subnetworkRef) {
        this.networkRef = networkRef;
        this.subnetworkRef = subnetworkRef;
    }

    protected NetworkImpl getNetwork() {
        return (NetworkImpl)this.networkRef.get();
    }

    protected static int loadDcNodeIndexLimit(PlatformConfig platformConfig) {
        return platformConfig.getOptionalModuleConfig("iidm").map(moduleConfig -> moduleConfig.getIntProperty("dc-node-index-limit", 1000)).orElse(1000);
    }

    private Integer getVertex(String dcNodeId) {
        Objects.requireNonNull(dcNodeId, "DC Node id is null");
        Integer v = this.dcNodes.get(dcNodeId);
        if (v == null) {
            throw new PowsyblException("DC Node '" + dcNodeId + NOT_FOUND_IN_THE_NETWORK);
        }
        return v;
    }

    void addDcNodeToTopology(DcNodeImpl dcNode) {
        int v = this.graph.addVertex();
        this.graph.setVertexObject(v, (Object)dcNode);
        this.dcNodes.put(dcNode.getId(), v);
    }

    void removeDcNode(String dcNodeId) {
        Integer v = this.dcNodes.get(dcNodeId);
        if (v == null) {
            throw new PowsyblException("DC Node '" + dcNodeId + NOT_FOUND_IN_THE_NETWORK);
        }
        this.dcNodes.remove(dcNodeId);
        this.graph.removeVertex(v.intValue());
    }

    void addDcSwitchToTopology(DcSwitchImpl dcSwitch, String dcNode1, String dcNode2) {
        int v1 = this.getVertex(dcNode1);
        int v2 = this.getVertex(dcNode2);
        int e = this.graph.addEdge(v1, v2, (Object)dcSwitch);
        this.dcSwitches.put(dcSwitch.getId(), e);
    }

    void removeDcSwitch(String dcSwitchId) {
        Integer e = this.dcSwitches.get(dcSwitchId);
        if (e == null) {
            throw new PowsyblException("DC Switch '" + dcSwitchId + NOT_FOUND_IN_THE_NETWORK);
        }
        this.dcSwitches.remove(dcSwitchId);
        this.graph.removeEdge(e.intValue());
    }

    void addAndDetachSubnetworkDcTopologyModel(SubnetworkImpl subnetwork) {
        subnetwork.getDcNodeStream().forEach(dcNode -> this.addDcNodeToTopology((DcNodeImpl)dcNode));
        subnetwork.getDcSwitchStream().forEach(dcSwitch -> this.addDcSwitchToTopology((DcSwitchImpl)dcSwitch, dcSwitch.getDcNode1().getId(), dcSwitch.getDcNode2().getId()));
        subnetwork.detachDcTopologyModel();
    }

    public Iterable<DcBus> getDcBuses() {
        return Collections.unmodifiableCollection(this.calculatedDcBusTopology.getDcBuses());
    }

    public int getDcBusCount() {
        return this.calculatedDcBusTopology.getDcBusCount();
    }

    public Stream<DcBus> getDcBusStream() {
        return this.calculatedDcBusTopology.getDcBuses().stream().map(Function.identity());
    }

    public DcBusImpl getDcBus(String id) {
        return this.calculatedDcBusTopology.getDcBus(id);
    }

    public DcBusImpl getDcBusOfDcNode(String dcNodeId) {
        return this.calculatedDcBusTopology.getDcBusOfDcNode(dcNodeId);
    }

    public void invalidateCache() {
        this.calculatedDcBusTopology.invalidateCache();
        this.getNetwork().getConnectedComponentsManager().invalidate();
        this.getNetwork().getDcComponentsManager().invalidate();
    }

    public void attach(DcTerminalImpl dcTerminal) {
        DcNodeImpl dcNode = (DcNodeImpl)dcTerminal.getDcNode();
        dcNode.addDcTerminal(dcTerminal);
        this.invalidateAllVariantsCache();
    }

    public void detach(DcTerminalImpl dcTerminal) {
        DcNodeImpl dcNode = (DcNodeImpl)dcTerminal.getDcNode();
        dcNode.removeDcTerminal(dcTerminal);
        this.invalidateAllVariantsCache();
    }

    public void invalidateAllVariantsCache() {
        ((NetworkImpl)this.networkRef.get()).getVariantManager().forEachVariant(this::invalidateCache);
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        this.variants.push(number, () -> this.variants.copy(sourceIndex));
    }

    @Override
    public void reduceVariantArraySize(int number) {
        this.variants.pop(number);
    }

    @Override
    public void deleteVariantArrayElement(int index) {
        this.variants.delete(index);
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        this.variants.allocate(indexes, () -> this.variants.copy(sourceIndex));
    }

    class CalculatedDcBusTopology {
        CalculatedDcBusTopology() {
        }

        private static boolean isDcBusValid(Set<DcNodeImpl> dcNodeSet) {
            return dcNodeSet.stream().flatMap(DcTopologyVisitable::getConnectedDcTerminalStream).findAny().isPresent();
        }

        private DcBusImpl createDcBus(Set<DcNodeImpl> dcNodeSet) {
            if (dcNodeSet == null || dcNodeSet.isEmpty()) {
                throw new PowsyblException("DC Node set is null or empty");
            }
            DcNodeImpl node = dcNodeSet.stream().min(Comparator.comparing(AbstractIdentifiable::getId)).orElseThrow();
            String dcBusId = Identifiables.getUniqueId((String)(node.getId() + "_dcBus"), DcTopologyModel.this.getNetwork().getIndex()::contains);
            String dcBusName = node.getOptionalName().orElse(null);
            return new DcBusImpl(DcTopologyModel.this.networkRef, DcTopologyModel.this.subnetworkRef, dcBusId, dcBusName, dcNodeSet);
        }

        private DcBusCache getCache() {
            if (DcTopologyModel.this.variants.get().cache != null) {
                return DcTopologyModel.this.variants.get().cache;
            }
            LinkedHashMap<String, DcBusImpl> dcBuses = new LinkedHashMap<String, DcBusImpl>();
            HashMap<String, DcBusImpl> dcNodeIdToDcBus = new HashMap<String, DcBusImpl>();
            boolean[] encountered = new boolean[DcTopologyModel.this.graph.getVertexCapacity()];
            Arrays.fill(encountered, false);
            for (int v : DcTopologyModel.this.graph.getVertices()) {
                if (encountered[v]) continue;
                LinkedHashSet<DcNodeImpl> dcNodeSet = new LinkedHashSet<DcNodeImpl>(1);
                dcNodeSet.add((DcNodeImpl)DcTopologyModel.this.graph.getVertexObject(v));
                DcTopologyModel.this.graph.traverse(v, TraversalType.DEPTH_FIRST, (v1, e, v2) -> {
                    DcSwitchImpl dcSwitch = (DcSwitchImpl)DcTopologyModel.this.graph.getEdgeObject(e);
                    if (dcSwitch.isOpen()) {
                        return TraverseResult.TERMINATE_PATH;
                    }
                    dcNodeSet.add((DcNodeImpl)DcTopologyModel.this.graph.getVertexObject(v2));
                    return TraverseResult.CONTINUE;
                }, encountered);
                if (!CalculatedDcBusTopology.isDcBusValid(dcNodeSet)) continue;
                DcBusImpl dcBus = this.createDcBus(dcNodeSet);
                dcBuses.put(dcBus.getId(), dcBus);
                dcNodeSet.forEach(dcNode -> dcNodeIdToDcBus.put(dcNode.getId(), dcBus));
            }
            DcTopologyModel.this.variants.get().cache = new DcBusCache(dcBuses, dcNodeIdToDcBus);
            return DcTopologyModel.this.variants.get().cache;
        }

        private void invalidateCache() {
            if (DcTopologyModel.this.variants.get().cache != null) {
                for (DcBusImpl bus : DcTopologyModel.this.variants.get().cache.getDcBuses()) {
                    bus.invalidate();
                }
                DcTopologyModel.this.variants.get().cache = null;
            }
        }

        private Collection<DcBusImpl> getDcBuses() {
            return this.getCache().getDcBuses();
        }

        private int getDcBusCount() {
            return this.getCache().getDcBusCount();
        }

        private DcBusImpl getDcBus(String dcBusId) {
            return this.getCache().getDcBus(dcBusId);
        }

        private DcBusImpl getDcBusOfDcNode(String dcNodeId) {
            return this.getCache().getDcBusOfDcNode(dcNodeId);
        }
    }

    private static final class VariantImpl
    implements Variant {
        private DcBusCache cache;

        private VariantImpl() {
        }

        public VariantImpl copy() {
            return new VariantImpl();
        }
    }

    private record DcBusCache(Map<String, DcBusImpl> dcBuses, Map<String, DcBusImpl> dcNodeIdToDcBus) {
        private Collection<DcBusImpl> getDcBuses() {
            return this.dcBuses.values();
        }

        private int getDcBusCount() {
            return this.dcBuses.size();
        }

        private DcBusImpl getDcBus(String id) {
            return this.dcBuses.get(id);
        }

        private DcBusImpl getDcBusOfDcNode(String dcNodeId) {
            return this.dcNodeIdToDcBus.get(dcNodeId);
        }
    }
}

