/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.LineCommutatedConverter;
import com.powsybl.iidm.network.LineCommutatedConverterAdder;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractAcDcConverterAdder;
import com.powsybl.iidm.network.impl.LineCommutatedConverterImpl;
import com.powsybl.iidm.network.impl.VoltageLevelExt;

public class LineCommutatedConverterAdderImpl
extends AbstractAcDcConverterAdder<LineCommutatedConverterAdderImpl>
implements LineCommutatedConverterAdder {
    private LineCommutatedConverter.ReactiveModel reactiveModel = LineCommutatedConverter.ReactiveModel.FIXED_POWER_FACTOR;
    private double powerFactor = Math.cos(Math.atan(0.5));

    LineCommutatedConverterAdderImpl(VoltageLevelExt voltageLevel) {
        super(voltageLevel);
    }

    @Override
    protected String getTypeDescription() {
        return "AC/DC Line Commutated Converter";
    }

    public LineCommutatedConverterAdder setReactiveModel(LineCommutatedConverter.ReactiveModel reactiveModel) {
        this.reactiveModel = reactiveModel;
        return this;
    }

    public LineCommutatedConverterAdder setPowerFactor(double powerFactor) {
        this.powerFactor = powerFactor;
        return this;
    }

    public LineCommutatedConverter add() {
        String id = this.checkAndGetUniqueId();
        super.preCheck();
        ValidationUtil.checkPositivePowerFactor((Validable)this, (double)this.powerFactor);
        ValidationUtil.checkLccReactiveModel((Validable)this, (LineCommutatedConverter.ReactiveModel)this.reactiveModel);
        LineCommutatedConverterImpl dcCsConverter = new LineCommutatedConverterImpl(this.voltageLevel.getNetworkRef(), id, this.getName(), this.isFictitious(), this.idleLoss, this.switchingLoss, this.resistiveLoss, this.pccTerminal, this.controlMode, this.targetP, this.targetVdc, this.reactiveModel, this.powerFactor);
        super.checkAndAdd(dcCsConverter);
        return dcCsConverter;
    }

    @Override
    protected LineCommutatedConverterAdderImpl self() {
        return this;
    }
}

