/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.ref.Ref;
import com.powsybl.iidm.network.AcDcConverter;
import com.powsybl.iidm.network.LineCommutatedConverter;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractAcDcConverter;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.TerminalExt;

public class LineCommutatedConverterImpl
extends AbstractAcDcConverter<LineCommutatedConverter>
implements LineCommutatedConverter {
    public static final String REACTIVE_MODEL_ATTRIBUTE = "reactiveModel";
    public static final String POWER_FACTOR_ATTRIBUTE = "powerFactor";
    private LineCommutatedConverter.ReactiveModel reactiveModel;
    private double powerFactor;

    LineCommutatedConverterImpl(Ref<NetworkImpl> ref, String id, String name, boolean fictitious, double idleLoss, double switchingLoss, double resistiveLoss, TerminalExt pccTerminal, AcDcConverter.ControlMode controlMode, double targetP, double targetVdc, LineCommutatedConverter.ReactiveModel reactiveModel, double powerFactor) {
        super(ref, id, name, fictitious, idleLoss, switchingLoss, resistiveLoss, pccTerminal, controlMode, targetP, targetVdc);
        this.reactiveModel = reactiveModel;
        this.powerFactor = powerFactor;
    }

    @Override
    protected String getTypeDescription() {
        return "AC/DC Line Commutated Converter";
    }

    public LineCommutatedConverter.ReactiveModel getReactiveModel() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)REACTIVE_MODEL_ATTRIBUTE);
        return this.reactiveModel;
    }

    public LineCommutatedConverter setReactiveModel(LineCommutatedConverter.ReactiveModel reactiveModel) {
        ValidationUtil.checkModifyOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)REACTIVE_MODEL_ATTRIBUTE);
        ValidationUtil.checkLccReactiveModel((Validable)this, (LineCommutatedConverter.ReactiveModel)reactiveModel);
        LineCommutatedConverter.ReactiveModel oldValue = this.reactiveModel;
        this.reactiveModel = reactiveModel;
        this.getNetwork().getListeners().notifyUpdate(this, REACTIVE_MODEL_ATTRIBUTE, (Object)oldValue, (Object)reactiveModel);
        return this;
    }

    public double getPowerFactor() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)POWER_FACTOR_ATTRIBUTE);
        return this.powerFactor;
    }

    public LineCommutatedConverter setPowerFactor(double powerFactor) {
        ValidationUtil.checkModifyOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)POWER_FACTOR_ATTRIBUTE);
        ValidationUtil.checkPositivePowerFactor((Validable)this, (double)powerFactor);
        double oldValue = this.powerFactor;
        this.powerFactor = powerFactor;
        this.getNetwork().getListeners().notifyUpdate(this, POWER_FACTOR_ATTRIBUTE, (Object)oldValue, (Object)powerFactor);
        return this;
    }

    @Override
    protected LineCommutatedConverter self() {
        return this;
    }
}

