/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.google.common.base.Functions;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.util.Colors;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.BusbarSectionAdder;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.SwitchKind;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.impl.AbstractConnectable;
import com.powsybl.iidm.network.impl.AbstractIdentifiableAdder;
import com.powsybl.iidm.network.impl.AbstractTopologyModel;
import com.powsybl.iidm.network.impl.BusExt;
import com.powsybl.iidm.network.impl.BusbarSectionAdderImpl;
import com.powsybl.iidm.network.impl.CalculatedBus;
import com.powsybl.iidm.network.impl.CalculatedBusImpl;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.NodeTerminal;
import com.powsybl.iidm.network.impl.SwitchImpl;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.Variant;
import com.powsybl.iidm.network.impl.VariantArray;
import com.powsybl.iidm.network.impl.VoltageLevelExt;
import com.powsybl.iidm.network.util.Identifiables;
import com.powsybl.iidm.network.util.ShortIdDictionary;
import com.powsybl.iidm.network.util.SwitchPredicates;
import com.powsybl.math.graph.DefaultUndirectedGraphListener;
import com.powsybl.math.graph.TraversalType;
import com.powsybl.math.graph.TraverseResult;
import com.powsybl.math.graph.Traverser;
import com.powsybl.math.graph.UndirectedGraph;
import com.powsybl.math.graph.UndirectedGraphImpl;
import com.powsybl.math.graph.UndirectedGraphListener;
import gnu.trove.TCollections;
import gnu.trove.TIntCollection;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.anarres.graphviz.builder.GraphVizAttribute;
import org.anarres.graphviz.builder.GraphVizEdge;
import org.anarres.graphviz.builder.GraphVizGraph;
import org.anarres.graphviz.builder.GraphVizNode;
import org.anarres.graphviz.builder.GraphVizScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeBreakerTopologyModel
extends AbstractTopologyModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeBreakerTopologyModel.class);
    private static final String WRONG_TERMINAL_TYPE_EXCEPTION_MESSAGE = "Given TerminalExt not supported: ";
    private static final boolean DRAW_SWITCH_ID = true;
    private static final BusChecker CALCULATED_BUS_CHECKER = new CalculatedBusChecker();
    private static final BusChecker CALCULATED_BUS_BREAKER_CHECKER = new CalculatedBusBreakerChecker();
    private static final BusNamingStrategy NAMING_STRATEGY = new LowestNodeNumberBusNamingStrategy();
    private final UndirectedGraphImpl<NodeTerminal, SwitchImpl> graph = new UndirectedGraphImpl(NODE_INDEX_LIMIT);
    private final Map<String, Integer> switches = new HashMap<String, Integer>();
    private final VariantArray<VariantImpl> variants;
    private final VoltageLevelExt.NodeBreakerViewExt nodeBreakerView = new VoltageLevelExt.NodeBreakerViewExt(){
        private final TIntObjectMap<TDoubleArrayList> fictitiousP0ByNode = TCollections.synchronizedMap((TIntObjectMap)new TIntObjectHashMap());
        private final TIntObjectMap<TDoubleArrayList> fictitiousQ0ByNode = TCollections.synchronizedMap((TIntObjectMap)new TIntObjectHashMap());

        public double getFictitiousP0(int node) {
            TDoubleArrayList fictP0 = (TDoubleArrayList)this.fictitiousP0ByNode.get(node);
            if (fictP0 != null) {
                return fictP0.get(NodeBreakerTopologyModel.this.getNetwork().getVariantIndex());
            }
            return 0.0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public VoltageLevel.NodeBreakerView setFictitiousP0(int node, double p0) {
            if (Double.isNaN(p0)) {
                throw new ValidationException((Validable)NodeBreakerTopologyModel.this.voltageLevel, "undefined value cannot be set as fictitious p0");
            }
            TDoubleArrayList p0ByVariant = (TDoubleArrayList)this.fictitiousP0ByNode.get(node);
            if (p0ByVariant == null) {
                int variantArraySize = NodeBreakerTopologyModel.this.getNetwork().getVariantManager().getVariantArraySize();
                p0ByVariant = new TDoubleArrayList(variantArraySize);
                for (int i = 0; i < variantArraySize; ++i) {
                    p0ByVariant.add(0.0);
                }
                TIntObjectMap<TDoubleArrayList> i = this.fictitiousP0ByNode;
                synchronized (i) {
                    this.fictitiousP0ByNode.put(node, (Object)p0ByVariant);
                }
            }
            int variantIndex = NodeBreakerTopologyModel.this.getNetwork().getVariantIndex();
            double oldValue = p0ByVariant.set(NodeBreakerTopologyModel.this.getNetwork().getVariantIndex(), p0);
            String variantId = NodeBreakerTopologyModel.this.getNetwork().getVariantManager().getVariantId(variantIndex);
            NodeBreakerTopologyModel.this.getNetwork().getListeners().notifyUpdate((Identifiable<?>)NodeBreakerTopologyModel.this.voltageLevel, "fictitiousP0", variantId, (Object)oldValue, (Object)p0);
            TIntSet toRemove = NodeBreakerTopologyModel.clearFictitiousInjections(this.fictitiousP0ByNode);
            TIntObjectMap<TDoubleArrayList> tIntObjectMap = this.fictitiousP0ByNode;
            synchronized (tIntObjectMap) {
                toRemove.forEach(n -> {
                    this.fictitiousP0ByNode.remove(n);
                    return true;
                });
            }
            return this;
        }

        public double getFictitiousQ0(int node) {
            TDoubleArrayList fictQ0 = (TDoubleArrayList)this.fictitiousQ0ByNode.get(node);
            if (fictQ0 != null) {
                return fictQ0.get(NodeBreakerTopologyModel.this.getNetwork().getVariantIndex());
            }
            return 0.0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public VoltageLevel.NodeBreakerView setFictitiousQ0(int node, double q0) {
            if (Double.isNaN(q0)) {
                throw new ValidationException((Validable)NodeBreakerTopologyModel.this.voltageLevel, "undefined value cannot be set as fictitious q0");
            }
            TDoubleArrayList q0ByVariant = (TDoubleArrayList)this.fictitiousQ0ByNode.get(node);
            if (q0ByVariant == null) {
                int variantArraySize = NodeBreakerTopologyModel.this.getNetwork().getVariantManager().getVariantArraySize();
                q0ByVariant = new TDoubleArrayList(variantArraySize);
                for (int i = 0; i < variantArraySize; ++i) {
                    q0ByVariant.add(0.0);
                }
                TIntObjectMap<TDoubleArrayList> i = this.fictitiousQ0ByNode;
                synchronized (i) {
                    this.fictitiousQ0ByNode.put(node, (Object)q0ByVariant);
                }
            }
            int variantIndex = NodeBreakerTopologyModel.this.getNetwork().getVariantIndex();
            double oldValue = q0ByVariant.set(NodeBreakerTopologyModel.this.getNetwork().getVariantIndex(), q0);
            String variantId = NodeBreakerTopologyModel.this.getNetwork().getVariantManager().getVariantId(variantIndex);
            NodeBreakerTopologyModel.this.getNetwork().getListeners().notifyUpdate((Identifiable<?>)NodeBreakerTopologyModel.this.voltageLevel, "fictitiousQ0", variantId, (Object)oldValue, (Object)q0);
            TIntSet toRemove = NodeBreakerTopologyModel.clearFictitiousInjections(this.fictitiousQ0ByNode);
            TIntObjectMap<TDoubleArrayList> tIntObjectMap = this.fictitiousQ0ByNode;
            synchronized (tIntObjectMap) {
                toRemove.forEach(n -> {
                    this.fictitiousQ0ByNode.remove(n);
                    return true;
                });
            }
            return this;
        }

        public int getMaximumNodeIndex() {
            return NodeBreakerTopologyModel.this.graph.getVertexCapacity() - 1;
        }

        public int[] getNodes() {
            return NodeBreakerTopologyModel.this.graph.getVertices();
        }

        public int getNode1(String switchId) {
            int edge = NodeBreakerTopologyModel.this.getEdge(switchId, true);
            return NodeBreakerTopologyModel.this.graph.getEdgeVertex1(edge);
        }

        public int getNode2(String switchId) {
            int edge = NodeBreakerTopologyModel.this.getEdge(switchId, true);
            return NodeBreakerTopologyModel.this.graph.getEdgeVertex2(edge);
        }

        public Terminal getTerminal(int node) {
            return (Terminal)NodeBreakerTopologyModel.this.graph.getVertexObject(node);
        }

        public Stream<Switch> getSwitchStream(int node) {
            return NodeBreakerTopologyModel.this.graph.getEdgeObjectConnectedToVertexStream(node).filter(Objects::nonNull).map(Switch.class::cast);
        }

        public List<Switch> getSwitches(int node) {
            return this.getSwitchStream(node).collect(Collectors.toList());
        }

        public IntStream getNodeInternalConnectedToStream(int node) {
            return NodeBreakerTopologyModel.this.graph.getEdgeConnectedToVertexStream(node).filter(e -> NodeBreakerTopologyModel.this.graph.getEdgeObject(e) == null).map(e -> {
                int vertex1 = NodeBreakerTopologyModel.this.graph.getEdgeVertex1(e);
                return vertex1 != node ? vertex1 : NodeBreakerTopologyModel.this.graph.getEdgeVertex2(e);
            });
        }

        public List<Integer> getNodesInternalConnectedTo(int node) {
            return this.getNodeInternalConnectedToStream(node).boxed().collect(Collectors.toList());
        }

        public Optional<Terminal> getOptionalTerminal(int node) {
            if (NodeBreakerTopologyModel.this.graph.vertexExists(node)) {
                return Optional.ofNullable((Terminal)NodeBreakerTopologyModel.this.graph.getVertexObject(node));
            }
            return Optional.empty();
        }

        public boolean hasAttachedEquipment(int node) {
            return NodeBreakerTopologyModel.this.graph.vertexExists(node);
        }

        public Terminal getTerminal1(String switchId) {
            return this.getTerminal(this.getNode1(switchId));
        }

        public Terminal getTerminal2(String switchId) {
            return this.getTerminal(this.getNode2(switchId));
        }

        public VoltageLevel.NodeBreakerView.SwitchAdder newSwitch() {
            return new SwitchAdderImpl();
        }

        public VoltageLevel.NodeBreakerView.InternalConnectionAdder newInternalConnection() {
            return new InternalConnectionAdderImpl();
        }

        public int getInternalConnectionCount() {
            return (int)this.getInternalConnectionStream().count();
        }

        public Iterable<VoltageLevel.NodeBreakerView.InternalConnection> getInternalConnections() {
            return this.getInternalConnectionStream().collect(Collectors.toList());
        }

        public Stream<VoltageLevel.NodeBreakerView.InternalConnection> getInternalConnectionStream() {
            return Arrays.stream(NodeBreakerTopologyModel.this.graph.getEdges()).filter(e -> NodeBreakerTopologyModel.this.graph.getEdgeObject(e) == null).mapToObj(e -> new VoltageLevel.NodeBreakerView.InternalConnection(){

                public int getNode1() {
                    return NodeBreakerTopologyModel.this.graph.getEdgeVertex1(e);
                }

                public int getNode2() {
                    return NodeBreakerTopologyModel.this.graph.getEdgeVertex2(e);
                }
            });
        }

        public void removeInternalConnections(int node1, int node2) {
            int[] internalConnectionsToBeRemoved = Arrays.stream(NodeBreakerTopologyModel.this.graph.getEdges()).filter(e -> NodeBreakerTopologyModel.this.graph.getEdgeObject(e) == null).filter(e -> NodeBreakerTopologyModel.this.graph.getEdgeVertex1(e) == node1 && NodeBreakerTopologyModel.this.graph.getEdgeVertex2(e) == node2 || NodeBreakerTopologyModel.this.graph.getEdgeVertex1(e) == node2 && NodeBreakerTopologyModel.this.graph.getEdgeVertex2(e) == node1).toArray();
            if (internalConnectionsToBeRemoved.length == 0) {
                throw new PowsyblException("Internal connection not found between " + node1 + " and " + node2);
            }
            for (int ic : internalConnectionsToBeRemoved) {
                NodeBreakerTopologyModel.this.graph.removeEdge(ic);
            }
            NodeBreakerTopologyModel.this.graph.removeIsolatedVertices();
            NodeBreakerTopologyModel.this.invalidateCache();
        }

        public VoltageLevel.NodeBreakerView.SwitchAdder newBreaker() {
            return new SwitchAdderImpl(SwitchKind.BREAKER);
        }

        public VoltageLevel.NodeBreakerView.SwitchAdder newDisconnector() {
            return new SwitchAdderImpl(SwitchKind.DISCONNECTOR);
        }

        public SwitchImpl getSwitch(String switchId) {
            Integer edge = NodeBreakerTopologyModel.this.getEdge(switchId, false);
            if (edge != null) {
                return (SwitchImpl)NodeBreakerTopologyModel.this.graph.getEdgeObject(edge.intValue());
            }
            return null;
        }

        public Iterable<Switch> getSwitches() {
            return Iterables.filter((Iterable)NodeBreakerTopologyModel.this.graph.getEdgesObject(), Switch.class);
        }

        public Stream<Switch> getSwitchStream() {
            return NodeBreakerTopologyModel.this.graph.getEdgeObjectStream().map(Function.identity());
        }

        public int getSwitchCount() {
            return NodeBreakerTopologyModel.this.graph.getEdgeCount();
        }

        public void removeSwitch(String switchId) {
            NodeBreakerTopologyModel.this.removeSwitchFromTopology(switchId, true);
        }

        public BusbarSectionAdder newBusbarSection() {
            return new BusbarSectionAdderImpl(NodeBreakerTopologyModel.this.voltageLevel);
        }

        public Iterable<BusbarSection> getBusbarSections() {
            return NodeBreakerTopologyModel.this.getConnectables(BusbarSection.class);
        }

        public Stream<BusbarSection> getBusbarSectionStream() {
            return NodeBreakerTopologyModel.this.getConnectableStream(BusbarSection.class);
        }

        public int getBusbarSectionCount() {
            return NodeBreakerTopologyModel.this.getConnectableCount(BusbarSection.class);
        }

        public BusbarSection getBusbarSection(String id) {
            BusbarSection bbs = NodeBreakerTopologyModel.this.getNetwork().getIndex().get(id, BusbarSection.class);
            if (bbs != null && bbs.getTerminal().getVoltageLevel() != NodeBreakerTopologyModel.this.voltageLevel) {
                return null;
            }
            return bbs;
        }

        private Traverser adapt(VoltageLevel.NodeBreakerView.TopologyTraverser t) {
            return (v1, e, v2) -> t.traverse(v1, (Switch)NodeBreakerTopologyModel.this.graph.getEdgeObject(e), v2);
        }

        public void traverse(int node, VoltageLevel.NodeBreakerView.TopologyTraverser t) {
            NodeBreakerTopologyModel.this.graph.traverse(node, TraversalType.DEPTH_FIRST, this.adapt(t));
        }

        public void traverse(int[] nodes, VoltageLevel.NodeBreakerView.TopologyTraverser t) {
            NodeBreakerTopologyModel.this.graph.traverse(nodes, TraversalType.DEPTH_FIRST, this.adapt(t));
        }
    };
    private final VoltageLevelExt.BusViewExt busView = new VoltageLevelExt.BusViewExt(){

        public Iterable<Bus> getBuses() {
            return Collections.unmodifiableCollection(NodeBreakerTopologyModel.this.variants.get().calculatedBusTopology.getBuses());
        }

        public Stream<Bus> getBusStream() {
            return NodeBreakerTopologyModel.this.variants.get().calculatedBusTopology.getBuses().stream().map(Function.identity());
        }

        @Override
        public CalculatedBus getBus(String id) {
            return NodeBreakerTopologyModel.this.variants.get().calculatedBusTopology.getBus(id, false);
        }

        public Bus getMergedBus(String busBarId) {
            NodeTerminal nt = (NodeTerminal)Objects.requireNonNull(NodeBreakerTopologyModel.this.nodeBreakerView.getBusbarSection(busBarId)).getTerminal();
            int node = nt.getNode();
            return NodeBreakerTopologyModel.this.variants.get().calculatedBusTopology.getBus(node);
        }
    };
    private final VoltageLevelExt.BusBreakerViewExt busBreakerView = new VoltageLevelExt.BusBreakerViewExt(){

        public Iterable<Bus> getBuses() {
            return Collections.unmodifiableCollection(NodeBreakerTopologyModel.this.variants.get().calculatedBusBreakerTopology.getBuses());
        }

        public Stream<Bus> getBusStream() {
            return NodeBreakerTopologyModel.this.variants.get().calculatedBusBreakerTopology.getBuses().stream().map(Function.identity());
        }

        public int getBusCount() {
            return NodeBreakerTopologyModel.this.variants.get().calculatedBusBreakerTopology.getBusCount();
        }

        @Override
        public CalculatedBus getBus(String id) {
            return NodeBreakerTopologyModel.this.variants.get().calculatedBusBreakerTopology.getBus(id, false);
        }

        public BusAdder newBus() {
            throw NodeBreakerTopologyModel.createNotSupportedNodeBreakerTopologyException();
        }

        public void removeBus(String busId) {
            throw NodeBreakerTopologyModel.createNotSupportedNodeBreakerTopologyException();
        }

        public void removeAllBuses() {
            throw NodeBreakerTopologyModel.createNotSupportedNodeBreakerTopologyException();
        }

        public Iterable<Switch> getSwitches() {
            return Iterables.filter(NodeBreakerTopologyModel.this.variants.get().calculatedBusBreakerTopology.getSwitches(), Switch.class);
        }

        public Stream<Switch> getSwitchStream() {
            return NodeBreakerTopologyModel.this.variants.get().calculatedBusBreakerTopology.getSwitchStream();
        }

        public int getSwitchCount() {
            return NodeBreakerTopologyModel.this.variants.get().calculatedBusBreakerTopology.getSwitchCount();
        }

        public void removeSwitch(String switchId) {
            throw NodeBreakerTopologyModel.createNotSupportedNodeBreakerTopologyException();
        }

        public void removeAllSwitches() {
            throw NodeBreakerTopologyModel.createNotSupportedNodeBreakerTopologyException();
        }

        public Bus getBus1(String switchId) {
            return NodeBreakerTopologyModel.this.variants.get().calculatedBusBreakerTopology.getBus1(switchId, true);
        }

        public Bus getBus2(String switchId) {
            return NodeBreakerTopologyModel.this.variants.get().calculatedBusBreakerTopology.getBus2(switchId, true);
        }

        public Collection<Bus> getBusesFromBusViewBusId(String mergedBusId) {
            HashSet<Bus> buses = new HashSet<Bus>();
            for (int i = 0; i < NodeBreakerTopologyModel.this.graph.getVertexCapacity(); ++i) {
                CalculatedBus b = NodeBreakerTopologyModel.this.variants.get().calculatedBusTopology.getBus(i);
                if (b == null || !b.getId().equals(mergedBusId)) continue;
                buses.add(NodeBreakerTopologyModel.this.variants.get().calculatedBusBreakerTopology.getBus(i));
            }
            if (buses.isEmpty()) {
                throw new PowsyblException(NodeBreakerTopologyModel.getExceptionMessageElementNotFound("Bus", mergedBusId));
            }
            return buses;
        }

        public Stream<Bus> getBusStreamFromBusViewBusId(String mergedBusId) {
            return this.getBusesFromBusViewBusId(mergedBusId).stream();
        }

        public Switch getSwitch(String switchId) {
            return NodeBreakerTopologyModel.this.variants.get().calculatedBusBreakerTopology.getSwitch(switchId, true);
        }

        public VoltageLevel.BusBreakerView.SwitchAdder newSwitch() {
            throw NodeBreakerTopologyModel.createNotSupportedNodeBreakerTopologyException();
        }

        public void traverse(Bus bus, VoltageLevel.BusBreakerView.TopologyTraverser traverser) {
            throw NodeBreakerTopologyModel.createNotSupportedNodeBreakerTopologyException();
        }
    };

    NodeBreakerTopologyModel(final VoltageLevelExt voltageLevel) {
        super(voltageLevel);
        this.variants = new VariantArray<VariantImpl>(voltageLevel.getNetworkRef(), () -> new VariantImpl());
        this.graph.addListener((UndirectedGraphListener)new DefaultUndirectedGraphListener<NodeTerminal, SwitchImpl>(){
            private static final String INTERNAL_CONNECTION = "internalConnection";

            public void edgeAdded(int e, SwitchImpl aSwitch) {
                NetworkImpl network = NodeBreakerTopologyModel.this.getNetwork();
                if (aSwitch != null) {
                    network.getIndex().checkAndAdd(aSwitch);
                    NodeBreakerTopologyModel.this.switches.put(aSwitch.getId(), e);
                    network.getListeners().notifyCreation(aSwitch);
                } else {
                    network.getListeners().notifyPropertyAdded((Identifiable<?>)voltageLevel, INTERNAL_CONNECTION, (Object)null);
                }
                NodeBreakerTopologyModel.this.invalidateCache();
            }

            public void edgeBeforeRemoval(int e, SwitchImpl aSwitch) {
                NetworkImpl network = NodeBreakerTopologyModel.this.getNetwork();
                if (aSwitch != null) {
                    network.getListeners().notifyBeforeRemoval(aSwitch);
                }
            }

            public void edgeRemoved(int e, SwitchImpl aSwitch) {
                NetworkImpl network = NodeBreakerTopologyModel.this.getNetwork();
                if (aSwitch != null) {
                    String switchId = aSwitch.getId();
                    network.getIndex().remove(aSwitch);
                    NodeBreakerTopologyModel.this.switches.remove(switchId);
                    network.getListeners().notifyAfterRemoval(switchId);
                } else {
                    network.getListeners().notifyPropertyRemoved((Identifiable<?>)voltageLevel, INTERNAL_CONNECTION, (Object)null);
                }
            }

            public void allEdgesBeforeRemoval(Collection<SwitchImpl> aSwitches) {
                NetworkImpl network = NodeBreakerTopologyModel.this.getNetwork();
                aSwitches.stream().filter(Objects::nonNull).forEach(ss -> network.getListeners().notifyBeforeRemoval((Identifiable<?>)ss));
            }

            public void allEdgesRemoved(Collection<SwitchImpl> aSwitches) {
                NetworkImpl network = NodeBreakerTopologyModel.this.getNetwork();
                aSwitches.forEach(ss -> {
                    if (ss != null) {
                        network.getIndex().remove((Identifiable)ss);
                    } else {
                        network.getListeners().notifyPropertyRemoved((Identifiable<?>)voltageLevel, INTERNAL_CONNECTION, (Object)null);
                    }
                });
                NodeBreakerTopologyModel.this.switches.clear();
                aSwitches.stream().filter(Objects::nonNull).forEach(ss -> network.getListeners().notifyAfterRemoval(ss.getId()));
            }
        });
    }

    @Override
    public void invalidateCache(boolean exceptBusBreakerView) {
        if (!exceptBusBreakerView) {
            this.variants.get().calculatedBusBreakerTopology.invalidateCache();
            this.getNetwork().getBusBreakerView().invalidateCache();
        }
        this.variants.get().calculatedBusTopology.invalidateCache();
        this.getNetwork().getBusView().invalidateCache();
        this.getNetwork().getConnectedComponentsManager().invalidate();
        this.getNetwork().getSynchronousComponentsManager().invalidate();
    }

    private Integer getEdge(String switchId, boolean throwException) {
        Integer edge = this.switches.get(switchId);
        if (throwException && edge == null) {
            throw NodeBreakerTopologyModel.createSwitchNotFoundException(switchId);
        }
        return edge;
    }

    @Override
    public Iterable<Terminal> getTerminals() {
        return FluentIterable.from((Iterable)this.graph.getVerticesObj()).filter(Predicates.notNull()).transform(Functions.identity());
    }

    @Override
    public Stream<Terminal> getTerminalStream() {
        return this.graph.getVertexObjectStream().filter(Objects::nonNull).map(Function.identity());
    }

    static PowsyblException createNotSupportedNodeBreakerTopologyException() {
        return new PowsyblException("Not supported in a node/breaker topology");
    }

    private static PowsyblException createSwitchNotFoundException(String switchId) {
        return new PowsyblException(NodeBreakerTopologyModel.getExceptionMessageElementNotFound("Switch", switchId));
    }

    CalculatedBusBreakerTopology getCalculatedBusBreakerTopology() {
        return this.variants.get().calculatedBusBreakerTopology;
    }

    CalculatedBusTopology getCalculatedBusTopology() {
        return this.variants.get().calculatedBusTopology;
    }

    void removeSwitchFromTopology(String switchId, boolean notify) {
        Integer e = this.switches.get(switchId);
        if (e == null) {
            throw new PowsyblException("Switch '" + switchId + "' not found in voltage level '" + this.voltageLevel.getId() + "'");
        }
        this.graph.removeEdge(e.intValue(), notify);
        this.graph.removeIsolatedVertices(notify);
    }

    private static TIntSet clearFictitiousInjections(TIntObjectMap<TDoubleArrayList> fictitiousInjectionsByNode) {
        TIntHashSet toRemove = new TIntHashSet((TIntCollection)fictitiousInjectionsByNode.keySet());
        fictitiousInjectionsByNode.forEachEntry((arg_0, arg_1) -> NodeBreakerTopologyModel.lambda$clearFictitiousInjections$2((TIntSet)toRemove, arg_0, arg_1));
        return toRemove;
    }

    @Override
    public VoltageLevelExt.NodeBreakerViewExt getNodeBreakerView() {
        return this.nodeBreakerView;
    }

    @Override
    public VoltageLevelExt.BusViewExt getBusView() {
        return this.busView;
    }

    @Override
    public VoltageLevelExt.BusBreakerViewExt getBusBreakerView() {
        return this.busBreakerView;
    }

    @Override
    public Iterable<Switch> getSwitches() {
        return this.getNodeBreakerView().getSwitches();
    }

    @Override
    public int getSwitchCount() {
        return this.getNodeBreakerView().getSwitchCount();
    }

    @Override
    public TopologyKind getTopologyKind() {
        return TopologyKind.NODE_BREAKER;
    }

    private void checkTerminal(TerminalExt terminal) {
        if (!(terminal instanceof NodeTerminal)) {
            throw new ValidationException((Validable)terminal.getConnectable(), "voltage level " + this.voltageLevel.getId() + " has a node/breaker topology, a node connection should be specified instead of a bus connection");
        }
        int node = ((NodeTerminal)terminal).getNode();
        this.graph.addVertexIfNotPresent(node);
        if (this.graph.getVertexObject(node) != null) {
            throw new ValidationException((Validable)terminal.getConnectable(), "an equipment (" + ((NodeTerminal)this.graph.getVertexObject(node)).getConnectable().getId() + ") is already connected to node " + node + " of voltage level " + this.voltageLevel.getId());
        }
    }

    @Override
    public void attach(TerminalExt terminal, boolean test) {
        this.checkTerminal(terminal);
        if (test) {
            return;
        }
        int node = ((NodeTerminal)terminal).getNode();
        terminal.setVoltageLevel(this.voltageLevel);
        this.graph.setVertexObject(node, (Object)((NodeTerminal)terminal));
        this.getNetwork().getVariantManager().forEachVariant(this::invalidateCache);
    }

    @Override
    public void detach(TerminalExt terminal) {
        if (!(terminal instanceof NodeTerminal)) {
            throw new IllegalArgumentException("Incorrect terminal type");
        }
        int node = ((NodeTerminal)terminal).getNode();
        this.graph.setVertexObject(node, null);
        this.getNetwork().getVariantManager().forEachVariant(this::invalidateCache);
        terminal.setVoltageLevel(null);
        this.graph.removeIsolatedVertices();
    }

    private static boolean isBusbarSection(Terminal t) {
        return t != null && t.getConnectable().getType() == IdentifiableType.BUSBAR_SECTION;
    }

    private boolean checkNonClosableSwitch(SwitchImpl sw, Predicate<? super SwitchImpl> isSwitchOperable) {
        return SwitchPredicates.IS_OPEN.test(sw) && isSwitchOperable.negate().test(sw);
    }

    private void checkTopologyKind(Terminal terminal) {
        if (!(terminal instanceof NodeTerminal)) {
            throw new IllegalStateException(WRONG_TERMINAL_TYPE_EXCEPTION_MESSAGE + terminal.getClass().getName());
        }
    }

    boolean connect(TerminalExt terminal) {
        return this.connect(terminal, SwitchPredicates.IS_NONFICTIONAL_BREAKER);
    }

    @Override
    public boolean connect(TerminalExt terminal, Predicate<? super SwitchImpl> isSwitchOperable) {
        this.checkTopologyKind(terminal);
        if (terminal.isConnected()) {
            return false;
        }
        HashSet<SwitchImpl> switchForConnection = new HashSet<SwitchImpl>();
        if (this.getConnectingSwitches(terminal, isSwitchOperable, switchForConnection)) {
            switchForConnection.forEach(sw -> sw.setOpen(false));
            return true;
        }
        return false;
    }

    boolean getConnectingSwitches(Terminal terminal, Predicate<? super SwitchImpl> isSwitchOperable, Set<SwitchImpl> switchForConnection) {
        this.checkTopologyKind(terminal);
        int node = ((NodeTerminal)terminal).getNode();
        List paths = this.graph.findAllPaths(node, NodeBreakerTopologyModel::isBusbarSection, sw -> this.checkNonClosableSwitch((SwitchImpl)sw, isSwitchOperable), Comparator.comparing(o -> o.grep(idx -> SwitchPredicates.IS_OPEN.test((Switch)this.graph.getEdgeObject(idx))).size()).thenComparing(TIntArrayList::size));
        if (!paths.isEmpty()) {
            TIntArrayList shortestPath = (TIntArrayList)paths.get(0);
            for (int i = 0; i < shortestPath.size(); ++i) {
                int e = shortestPath.get(i);
                SwitchImpl sw2 = (SwitchImpl)this.graph.getEdgeObject(e);
                if (!SwitchPredicates.IS_OPEN.test(sw2)) continue;
                switchForConnection.add(sw2);
            }
            return true;
        }
        return false;
    }

    boolean disconnect(TerminalExt terminal) {
        return this.disconnect(terminal, SwitchPredicates.IS_CLOSED_BREAKER);
    }

    @Override
    public boolean disconnect(TerminalExt terminal, Predicate<? super SwitchImpl> isSwitchOpenable) {
        this.checkTopologyKind(terminal);
        if (!terminal.isConnected()) {
            return false;
        }
        HashSet<SwitchImpl> switchesToOpen = new HashSet<SwitchImpl>();
        if (this.getDisconnectingSwitches(terminal, isSwitchOpenable, switchesToOpen)) {
            switchesToOpen.forEach(sw -> sw.setOpen(true));
            return true;
        }
        return false;
    }

    boolean getDisconnectingSwitches(Terminal terminal, Predicate<? super SwitchImpl> isSwitchOpenable, Set<SwitchImpl> switchForDisconnection) {
        this.checkTopologyKind(terminal);
        int node = ((NodeTerminal)terminal).getNode();
        List paths = this.graph.findAllPaths(node, Objects::nonNull, SwitchPredicates.IS_OPEN);
        if (paths.isEmpty()) {
            return false;
        }
        for (TIntArrayList path : paths) {
            if (this.identifySwitchToOpenPath(path, isSwitchOpenable, switchForDisconnection)) continue;
            return false;
        }
        return true;
    }

    boolean identifySwitchToOpenPath(TIntArrayList path, Predicate<? super SwitchImpl> isSwitchOpenable, Set<SwitchImpl> switchesToOpen) {
        for (int i = 0; i < path.size(); ++i) {
            int e = path.get(i);
            SwitchImpl sw = (SwitchImpl)this.graph.getEdgeObject(e);
            if (!isSwitchOpenable.test(sw)) continue;
            switchesToOpen.add(sw);
            return true;
        }
        return false;
    }

    boolean isConnected(TerminalExt terminal) {
        this.checkTopologyKind(terminal);
        return terminal.getBusView().getBus() != null;
    }

    void traverse(NodeTerminal terminal, Terminal.TopologyTraverser traverser, TraversalType traversalType) {
        this.traverse(terminal, traverser, new HashSet<Terminal>(), traversalType);
    }

    boolean traverse(NodeTerminal terminal, Terminal.TopologyTraverser traverser, Set<Terminal> visitedTerminals, TraversalType traversalType) {
        Objects.requireNonNull(terminal);
        Objects.requireNonNull(traverser);
        Objects.requireNonNull(visitedTerminals);
        TraverseResult termTraverseResult = NodeBreakerTopologyModel.getTraverseResult(visitedTerminals, terminal, traverser);
        if (termTraverseResult == TraverseResult.TERMINATE_TRAVERSER) {
            return false;
        }
        if (termTraverseResult == TraverseResult.CONTINUE) {
            ArrayList<TerminalExt> nextTerminals = new ArrayList<TerminalExt>();
            NodeBreakerTopologyModel.addNextTerminals(terminal, nextTerminals);
            int node = terminal.getNode();
            boolean traverseTerminated = this.traverseOtherNodes(node, nextTerminals, traverser, visitedTerminals, traversalType);
            if (traverseTerminated) {
                return false;
            }
            for (TerminalExt nextTerminal : nextTerminals) {
                if (nextTerminal.traverse(traverser, visitedTerminals, traversalType)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean traverseOtherNodes(int node, List<TerminalExt> nextTerminals, Terminal.TopologyTraverser traverser, Set<Terminal> visitedTerminals, TraversalType traversalType) {
        return !this.graph.traverse(node, traversalType, (v1, e, v2) -> {
            TraverseResult edgeTraverseResult;
            SwitchImpl aSwitch = (SwitchImpl)this.graph.getEdgeObject(e);
            NodeTerminal otherTerminal = (NodeTerminal)this.graph.getVertexObject(v2);
            TraverseResult traverseResult = edgeTraverseResult = aSwitch != null ? traverser.traverse((Switch)aSwitch) : TraverseResult.CONTINUE;
            if (edgeTraverseResult == TraverseResult.CONTINUE && otherTerminal != null) {
                TraverseResult otherTermTraverseResult = NodeBreakerTopologyModel.getTraverseResult(visitedTerminals, otherTerminal, traverser);
                if (otherTermTraverseResult == TraverseResult.CONTINUE) {
                    NodeBreakerTopologyModel.addNextTerminals(otherTerminal, nextTerminals);
                }
                return otherTermTraverseResult;
            }
            return edgeTraverseResult;
        });
    }

    private static TraverseResult getTraverseResult(Set<Terminal> visitedTerminals, NodeTerminal terminal, Terminal.TopologyTraverser traverser) {
        return visitedTerminals.add(terminal) ? traverser.traverse((Terminal)terminal, true) : TraverseResult.TERMINATE_PATH;
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        this.variants.push(number, () -> new VariantImpl());
    }

    @Override
    public void reduceVariantArraySize(int number) {
        this.variants.pop(number);
    }

    @Override
    public void deleteVariantArrayElement(int index) {
        this.variants.delete(index);
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        this.variants.allocate(indexes, () -> new VariantImpl());
    }

    @Override
    protected void removeTopology() {
        this.removeAllEdges();
    }

    private void removeAllEdges() {
        this.graph.removeAllEdges();
    }

    @Override
    public void printTopology() {
        this.printTopology(System.out, null);
    }

    @Override
    public void printTopology(PrintStream out, ShortIdDictionary dict) {
        out.println("-------------------------------------------------------------");
        out.println("Topology of " + this.voltageLevel.getId());
        this.graph.print(out, terminal -> terminal != null ? terminal.getConnectable().toString() : null, null);
    }

    @Override
    public void exportTopology(Path file) {
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            this.exportTopology(writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void exportTopology(Writer writer) {
        this.exportTopology(writer, new SecureRandom());
    }

    @Override
    public void exportTopology(Writer writer, Random random) {
        Objects.requireNonNull(writer);
        Objects.requireNonNull(random);
        GraphVizScope.Impl scope = new GraphVizScope.Impl();
        GraphVizGraph gvGraph = new GraphVizGraph();
        this.exportNodes(random, gvGraph, (GraphVizScope)scope);
        this.exportEdges(gvGraph, (GraphVizScope)scope);
        try {
            gvGraph.writeTo(writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void exportNodes(Random random, GraphVizGraph gvGraph, GraphVizScope scope) {
        CalculatedBus bus;
        HashMap<String, String> busColor = new HashMap<String, String>();
        ArrayList<CalculatedBus> buses = new ArrayList<CalculatedBus>(this.getCalculatedBusBreakerTopology().getBuses());
        String[] colors = Colors.generateColorScale((int)buses.size(), (Random)random);
        for (int i = 0; i < buses.size(); ++i) {
            bus = (CalculatedBus)buses.get(i);
            busColor.put(bus.getId(), colors[i]);
        }
        for (int n = 0; n < this.graph.getVertexCapacity(); ++n) {
            if (!this.graph.vertexExists(n)) continue;
            bus = this.getCalculatedBusBreakerTopology().getBus(n);
            String label = "" + n;
            TerminalExt terminal = (TerminalExt)this.graph.getVertexObject(n);
            if (terminal != null) {
                AbstractConnectable connectable = terminal.getConnectable();
                label = label + System.lineSeparator() + connectable.getType().toString() + System.lineSeparator() + connectable.getId() + String.valueOf(connectable.getOptionalName().map(name -> System.lineSeparator() + String.valueOf(name)).orElse(""));
            }
            GraphVizNode gvNode = ((GraphVizNode)gvGraph.node(scope, (Object)n).label((CharSequence)label)).shape("ellipse");
            if (bus == null) continue;
            ((GraphVizNode)gvNode.style("filled")).attr(GraphVizAttribute.fillcolor, (String)busColor.get(bus.getId()));
            gvGraph.cluster(scope, (Object)bus).add(new GraphVizNode[]{gvNode}).attr(GraphVizAttribute.pencolor, "transparent");
        }
    }

    private void exportEdges(GraphVizGraph gvGraph, GraphVizScope scope) {
        for (int e : this.graph.getEdges()) {
            GraphVizEdge edge = gvGraph.edge(scope, (Object)this.graph.getEdgeVertex1(e), (Object)this.graph.getEdgeVertex2(e));
            SwitchImpl aSwitch = (SwitchImpl)this.graph.getEdgeObject(e);
            if (aSwitch == null) continue;
            ((GraphVizEdge)edge.label((CharSequence)(aSwitch.getKind().toString() + System.lineSeparator() + aSwitch.getId() + aSwitch.getOptionalName().map(n -> System.lineSeparator() + n).orElse("")))).attr(GraphVizAttribute.fontsize, "10");
            edge.style(aSwitch.isOpen() ? "dotted" : "solid");
        }
    }

    private static String getExceptionMessageElementNotFound(String element, String id) {
        return element + " " + id + " not found";
    }

    private static /* synthetic */ boolean lambda$clearFictitiousInjections$2(TIntSet toRemove, int node, TDoubleArrayList value) {
        value.forEach(inj -> {
            if (inj != 0.0) {
                toRemove.remove(node);
            }
            return true;
        });
        return true;
    }

    private final class VariantImpl
    implements Variant {
        final CalculatedBusTopology calculatedBusTopology;
        final CalculatedBusBreakerTopology calculatedBusBreakerTopology;

        private VariantImpl() {
            this.calculatedBusTopology = new CalculatedBusTopology();
            this.calculatedBusBreakerTopology = new CalculatedBusBreakerTopology();
        }

        public VariantImpl copy() {
            return new VariantImpl();
        }
    }

    class CalculatedBusBreakerTopology
    extends CalculatedBusTopology {
        CalculatedBusBreakerTopology() {
        }

        @Override
        protected void updateCache() {
            this.updateCache(sw -> sw.isOpen() || sw.isRetained());
        }

        @Override
        protected BusChecker getBusChecker() {
            return CALCULATED_BUS_BREAKER_CHECKER;
        }

        Bus getBus1(String switchId, boolean throwException) {
            int edge = NodeBreakerTopologyModel.this.getEdge(switchId, throwException);
            SwitchImpl aSwitch = (SwitchImpl)NodeBreakerTopologyModel.this.graph.getEdgeObject(edge);
            if (!aSwitch.isRetained()) {
                if (throwException) {
                    throw NodeBreakerTopologyModel.createSwitchNotFoundException(switchId);
                }
                return null;
            }
            int node1 = NodeBreakerTopologyModel.this.graph.getEdgeVertex1(edge);
            return this.getBus(node1);
        }

        Bus getBus2(String switchId, boolean throwException) {
            int edge = NodeBreakerTopologyModel.this.getEdge(switchId, throwException);
            SwitchImpl aSwitch = (SwitchImpl)NodeBreakerTopologyModel.this.graph.getEdgeObject(edge);
            if (!aSwitch.isRetained()) {
                if (throwException) {
                    throw NodeBreakerTopologyModel.createSwitchNotFoundException(switchId);
                }
                return null;
            }
            int node2 = NodeBreakerTopologyModel.this.graph.getEdgeVertex2(edge);
            return this.getBus(node2);
        }

        Iterable<SwitchImpl> getSwitches() {
            return Iterables.filter((Iterable)NodeBreakerTopologyModel.this.graph.getEdgesObject(), sw -> sw != null && sw.isRetained());
        }

        Stream<Switch> getSwitchStream() {
            return NodeBreakerTopologyModel.this.graph.getEdgeObjectStream().filter(Objects::nonNull).filter(Switch::isRetained).map(Function.identity());
        }

        int getSwitchCount() {
            return (int)NodeBreakerTopologyModel.this.graph.getEdgeObjectStream().filter(Objects::nonNull).filter(SwitchImpl::isRetained).count();
        }

        SwitchImpl getSwitch(String switchId, boolean throwException) {
            SwitchImpl aSwitch;
            Integer edge = NodeBreakerTopologyModel.this.getEdge(switchId, false);
            if (edge != null && (aSwitch = (SwitchImpl)NodeBreakerTopologyModel.this.graph.getEdgeObject(edge.intValue())).isRetained()) {
                return aSwitch;
            }
            if (throwException) {
                throw NodeBreakerTopologyModel.createSwitchNotFoundException(switchId);
            }
            return null;
        }
    }

    class CalculatedBusTopology {
        protected BusCache busCache;

        CalculatedBusTopology() {
        }

        protected void updateCache() {
            this.updateCache(Switch::isOpen);
        }

        protected BusChecker getBusChecker() {
            return CALCULATED_BUS_CHECKER;
        }

        private void traverse(int n, boolean[] encountered, Predicate<SwitchImpl> terminate, Map<String, CalculatedBus> id2bus, CalculatedBus[] node2bus) {
            if (!encountered[n]) {
                TIntArrayList nodes = new TIntArrayList(1);
                nodes.add(n);
                Traverser traverser = (n1, e, n2) -> {
                    SwitchImpl aSwitch = (SwitchImpl)NodeBreakerTopologyModel.this.graph.getEdgeObject(e);
                    if (aSwitch != null && terminate.test(aSwitch)) {
                        return TraverseResult.TERMINATE_PATH;
                    }
                    if (!encountered[n2]) {
                        nodes.add(n2);
                    }
                    return TraverseResult.CONTINUE;
                };
                NodeBreakerTopologyModel.this.graph.traverse(n, TraversalType.DEPTH_FIRST, traverser, encountered);
                String busId = Identifiables.getUniqueId((String)NAMING_STRATEGY.getId(NodeBreakerTopologyModel.this.voltageLevel, nodes), NodeBreakerTopologyModel.this.getNetwork().getIndex()::contains);
                CopyOnWriteArrayList<NodeTerminal> terminals = new CopyOnWriteArrayList<NodeTerminal>();
                for (int i = 0; i < nodes.size(); ++i) {
                    int n22 = nodes.getQuick(i);
                    NodeTerminal terminal2 = (NodeTerminal)NodeBreakerTopologyModel.this.graph.getVertexObject(n22);
                    if (terminal2 == null) continue;
                    terminals.add(terminal2);
                }
                if (this.getBusChecker().isValid((UndirectedGraph<? extends TerminalExt, SwitchImpl>)NodeBreakerTopologyModel.this.graph, nodes, (List<NodeTerminal>)terminals)) {
                    this.addBus(nodes, id2bus, node2bus, busId, terminals);
                }
            }
        }

        private void addBus(TIntArrayList nodes, Map<String, CalculatedBus> id2bus, CalculatedBus[] node2bus, String busId, CopyOnWriteArrayList<NodeTerminal> terminals) {
            String busName = NAMING_STRATEGY.getName(NodeBreakerTopologyModel.this.voltageLevel, nodes);
            Function<Terminal, Bus> getBusFromTerminal = this.getBusChecker() == CALCULATED_BUS_CHECKER ? t -> t.getBusView().getBus() : t -> t.getBusBreakerView().getBus();
            CalculatedBusImpl bus = new CalculatedBusImpl(busId, busName, NodeBreakerTopologyModel.this.voltageLevel.isFictitious(), NodeBreakerTopologyModel.this.voltageLevel, nodes, terminals, getBusFromTerminal);
            id2bus.put(busId, bus);
            for (int i = 0; i < nodes.size(); ++i) {
                node2bus[nodes.getQuick((int)i)] = bus;
            }
        }

        protected void updateCache(Predicate<SwitchImpl> terminate) {
            if (this.busCache != null) {
                return;
            }
            LOGGER.trace("Update bus topology of voltage level {}", (Object)NodeBreakerTopologyModel.this.voltageLevel.getId());
            LinkedHashMap<String, CalculatedBus> id2bus = new LinkedHashMap<String, CalculatedBus>();
            CalculatedBus[] node2bus = new CalculatedBus[NodeBreakerTopologyModel.this.graph.getVertexCapacity()];
            boolean[] encountered = new boolean[NodeBreakerTopologyModel.this.graph.getVertexCapacity()];
            for (int v : NodeBreakerTopologyModel.this.graph.getVertices()) {
                this.traverse(v, encountered, terminate, id2bus, node2bus);
            }
            this.busCache = new BusCache(node2bus, id2bus);
            LOGGER.trace("Found buses {}", id2bus.values());
        }

        protected void invalidateCache() {
            if (this.busCache != null) {
                for (CalculatedBus bus : this.busCache.id2bus.values()) {
                    bus.invalidate();
                }
                this.busCache = null;
            }
        }

        Collection<CalculatedBus> getBuses() {
            this.updateCache();
            return this.busCache.getBuses();
        }

        int getBusCount() {
            this.updateCache();
            return this.busCache.getBusCount();
        }

        CalculatedBus getBus(int node) {
            this.updateCache();
            return this.busCache.getBus(node);
        }

        CalculatedBus getBus(String id, boolean throwException) {
            this.updateCache();
            CalculatedBus bus = this.busCache.getBus(id);
            if (throwException && bus == null) {
                throw new PowsyblException(NodeBreakerTopologyModel.getExceptionMessageElementNotFound("Bus", id));
            }
            return bus;
        }

        BusExt getConnectableBus(int node) {
            CalculatedBus connectableBus = this.getBus(node);
            if (connectableBus != null) {
                return connectableBus;
            }
            BusExt[] connectableBus2 = new BusExt[1];
            NodeBreakerTopologyModel.this.graph.traverse(node, TraversalType.DEPTH_FIRST, (v1, e, v2) -> {
                if (connectableBus2[0] != null) {
                    return TraverseResult.TERMINATE_PATH;
                }
                connectableBus2[0] = this.getBus(v2);
                if (connectableBus2[0] != null) {
                    return TraverseResult.TERMINATE_PATH;
                }
                return TraverseResult.CONTINUE;
            });
            if (connectableBus2[0] == null) {
                Collection<CalculatedBus> buses = this.getBuses();
                if (buses.isEmpty()) {
                    return null;
                }
                return buses.iterator().next();
            }
            return connectableBus2[0];
        }
    }

    private static final class CalculatedBusChecker
    implements BusChecker {
        private CalculatedBusChecker() {
        }

        @Override
        public boolean isValid(UndirectedGraph<? extends TerminalExt, SwitchImpl> graph, TIntArrayList nodes, List<NodeTerminal> terminals) {
            int feederCount = 0;
            int branchCount = 0;
            int busbarSectionCount = 0;
            block6: for (int i = 0; i < nodes.size(); ++i) {
                int node = nodes.get(i);
                TerminalExt terminal = (TerminalExt)graph.getVertexObject(node);
                if (terminal == null) continue;
                AbstractConnectable connectable = terminal.getConnectable();
                switch (connectable.getType()) {
                    case LINE: 
                    case TWO_WINDINGS_TRANSFORMER: 
                    case THREE_WINDINGS_TRANSFORMER: 
                    case HVDC_CONVERTER_STATION: 
                    case DANGLING_LINE: {
                        ++branchCount;
                        ++feederCount;
                        continue block6;
                    }
                    case LOAD: 
                    case GENERATOR: 
                    case BATTERY: 
                    case SHUNT_COMPENSATOR: 
                    case STATIC_VAR_COMPENSATOR: 
                    case LINE_COMMUTATED_CONVERTER: 
                    case VOLTAGE_SOURCE_CONVERTER: {
                        ++feederCount;
                        continue block6;
                    }
                    case BUSBAR_SECTION: {
                        ++busbarSectionCount;
                        continue block6;
                    }
                    case GROUND: {
                        continue block6;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            return busbarSectionCount >= 1 && feederCount >= 1 || branchCount >= 1 && feederCount >= 2;
        }
    }

    private static interface BusChecker {
        public boolean isValid(UndirectedGraph<? extends TerminalExt, SwitchImpl> var1, TIntArrayList var2, List<NodeTerminal> var3);
    }

    private static final class CalculatedBusBreakerChecker
    implements BusChecker {
        private CalculatedBusBreakerChecker() {
        }

        @Override
        public boolean isValid(UndirectedGraph<? extends TerminalExt, SwitchImpl> graph, TIntArrayList nodes, List<NodeTerminal> terminals) {
            return !nodes.isEmpty();
        }
    }

    private static final class LowestNodeNumberBusNamingStrategy
    implements BusNamingStrategy {
        private LowestNodeNumberBusNamingStrategy() {
        }

        @Override
        public String getId(VoltageLevel voltageLevel, TIntArrayList nodes) {
            return voltageLevel.getId() + "_" + nodes.min();
        }

        @Override
        public String getName(VoltageLevel voltageLevel, TIntArrayList nodes) {
            return voltageLevel.getOptionalName().map(name -> name + "_" + nodes.min()).orElse(null);
        }
    }

    private static interface BusNamingStrategy {
        public String getId(VoltageLevel var1, TIntArrayList var2);

        public String getName(VoltageLevel var1, TIntArrayList var2);
    }

    private static final class BusCache {
        private final CalculatedBus[] node2bus;
        private final Map<String, CalculatedBus> id2bus;

        private BusCache(CalculatedBus[] node2bus, Map<String, CalculatedBus> id2bus) {
            this.node2bus = node2bus;
            this.id2bus = id2bus;
        }

        private Collection<CalculatedBus> getBuses() {
            return this.id2bus.values();
        }

        private int getBusCount() {
            return this.id2bus.size();
        }

        private CalculatedBus getBus(int node) {
            return this.node2bus[node];
        }

        private CalculatedBus getBus(String id) {
            return this.id2bus.get(id);
        }
    }

    private final class InternalConnectionAdderImpl
    implements VoltageLevel.NodeBreakerView.InternalConnectionAdder {
        private Integer node1;
        private Integer node2;

        private InternalConnectionAdderImpl() {
        }

        public VoltageLevel.NodeBreakerView.InternalConnectionAdder setNode1(int node1) {
            this.node1 = node1;
            return this;
        }

        public VoltageLevel.NodeBreakerView.InternalConnectionAdder setNode2(int node2) {
            this.node2 = node2;
            return this;
        }

        public void add() {
            if (this.node1 == null) {
                throw new ValidationException((Validable)NodeBreakerTopologyModel.this.voltageLevel, "first connection node is not set");
            }
            if (this.node2 == null) {
                throw new ValidationException((Validable)NodeBreakerTopologyModel.this.voltageLevel, "second connection node is not set");
            }
            NodeBreakerTopologyModel.this.graph.addVertexIfNotPresent(this.node1.intValue());
            NodeBreakerTopologyModel.this.graph.addVertexIfNotPresent(this.node2.intValue());
            NodeBreakerTopologyModel.this.graph.addEdge(this.node1.intValue(), this.node2.intValue(), null);
        }
    }

    private final class SwitchAdderImpl
    extends AbstractIdentifiableAdder<SwitchAdderImpl>
    implements VoltageLevel.NodeBreakerView.SwitchAdder {
        private Integer node1;
        private Integer node2;
        private SwitchKind kind;
        private boolean open = false;
        private boolean retained = false;

        private SwitchAdderImpl() {
            this(null);
        }

        private SwitchAdderImpl(SwitchKind kind) {
            this.kind = kind;
        }

        @Override
        protected NetworkImpl getNetwork() {
            return NodeBreakerTopologyModel.this.getNetwork();
        }

        @Override
        protected String getTypeDescription() {
            return "Switch";
        }

        public VoltageLevel.NodeBreakerView.SwitchAdder setNode1(int node1) {
            this.node1 = node1;
            return this;
        }

        public VoltageLevel.NodeBreakerView.SwitchAdder setNode2(int node2) {
            this.node2 = node2;
            return this;
        }

        public VoltageLevel.NodeBreakerView.SwitchAdder setKind(SwitchKind kind) {
            if (kind == null) {
                throw new NullPointerException("kind is null");
            }
            this.kind = kind;
            return this;
        }

        public VoltageLevel.NodeBreakerView.SwitchAdder setKind(String kind) {
            return this.setKind(SwitchKind.valueOf((String)kind));
        }

        public VoltageLevel.NodeBreakerView.SwitchAdder setOpen(boolean open) {
            this.open = open;
            return this;
        }

        public VoltageLevel.NodeBreakerView.SwitchAdder setRetained(boolean retained) {
            this.retained = retained;
            return this;
        }

        public Switch add() {
            String id = this.checkAndGetUniqueId();
            if (this.node1 == null) {
                throw new ValidationException((Validable)this, "first connection node is not set");
            }
            if (this.node2 == null) {
                throw new ValidationException((Validable)this, "second connection node is not set");
            }
            if (this.node1.equals(this.node2)) {
                throw new ValidationException((Validable)this, "same node at both ends");
            }
            if (this.kind == null) {
                throw new ValidationException((Validable)this, "kind is not set");
            }
            SwitchImpl aSwitch = new SwitchImpl(NodeBreakerTopologyModel.this.voltageLevel, id, this.getName(), this.isFictitious(), this.kind, this.open, this.retained);
            NodeBreakerTopologyModel.this.graph.addVertexIfNotPresent(this.node1.intValue());
            NodeBreakerTopologyModel.this.graph.addVertexIfNotPresent(this.node2.intValue());
            NodeBreakerTopologyModel.this.graph.addEdge(this.node1.intValue(), this.node2.intValue(), (Object)aSwitch);
            return aSwitch;
        }
    }
}

