/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.ref.Ref;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TerminalNumber;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.TopologyPoint;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.impl.AbstractTerminal;
import com.powsybl.iidm.network.impl.BusExt;
import com.powsybl.iidm.network.impl.NodeBreakerTopologyModel;
import com.powsybl.iidm.network.impl.NodeTopologyPointImpl;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.VariantManagerHolder;
import com.powsybl.math.graph.TraversalType;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;
import java.util.Set;

class NodeTerminal
extends AbstractTerminal {
    private final int node;
    protected final TDoubleArrayList v;
    protected final TDoubleArrayList angle;
    protected final TIntArrayList connectedComponentNumber;
    protected final TIntArrayList synchronousComponentNumber;
    private final Terminal.NodeBreakerView nodeBreakerView = new Terminal.NodeBreakerView(){

        public int getNode() {
            if (NodeTerminal.this.removed) {
                throw new PowsyblException("Cannot access node of removed equipment " + NodeTerminal.this.connectable.id);
            }
            return NodeTerminal.this.node;
        }

        public void moveConnectable(int node, String voltageLevelId) {
            if (NodeTerminal.this.removed) {
                throw new PowsyblException("Cannot modify removed equipment " + NodeTerminal.this.connectable.id);
            }
            NodeTerminal.this.getConnectable().move((TerminalExt)NodeTerminal.this, node, voltageLevelId);
        }
    };
    private final TerminalExt.BusBreakerViewExt busBreakerView = new TerminalExt.BusBreakerViewExt(){

        @Override
        public BusExt getBus() {
            if (NodeTerminal.this.removed) {
                throw new PowsyblException("Cannot access bus of removed equipment " + NodeTerminal.this.connectable.id);
            }
            return NodeTerminal.this.getTopologyModel().getCalculatedBusBreakerTopology().getBus(NodeTerminal.this.node);
        }

        public BusExt getConnectableBus() {
            if (NodeTerminal.this.removed) {
                throw new PowsyblException("Cannot access bus of removed equipment " + NodeTerminal.this.connectable.id);
            }
            return NodeTerminal.this.getTopologyModel().getCalculatedBusBreakerTopology().getConnectableBus(NodeTerminal.this.node);
        }

        public void setConnectableBus(String busId) {
            throw NodeBreakerTopologyModel.createNotSupportedNodeBreakerTopologyException();
        }

        public void moveConnectable(String busId, boolean connected) {
            if (NodeTerminal.this.removed) {
                throw new PowsyblException("Cannot modify removed equipment " + NodeTerminal.this.connectable.id);
            }
            NodeTerminal.this.getConnectable().move((TerminalExt)NodeTerminal.this, busId, connected);
        }
    };
    private final TerminalExt.BusViewExt busView = new TerminalExt.BusViewExt(){

        @Override
        public BusExt getBus() {
            if (NodeTerminal.this.removed) {
                throw new PowsyblException("Cannot access bus of removed equipment " + NodeTerminal.this.connectable.id);
            }
            return NodeTerminal.this.getTopologyModel().getCalculatedBusTopology().getBus(NodeTerminal.this.node);
        }

        public BusExt getConnectableBus() {
            if (NodeTerminal.this.removed) {
                throw new PowsyblException("Cannot access bus of removed equipment " + NodeTerminal.this.connectable.id);
            }
            return NodeTerminal.this.getTopologyModel().getCalculatedBusTopology().getConnectableBus(NodeTerminal.this.node);
        }
    };

    private NodeBreakerTopologyModel getTopologyModel() {
        return (NodeBreakerTopologyModel)this.voltageLevel.getTopologyModel();
    }

    @Override
    public TopologyPoint getTopologyPoint() {
        return new NodeTopologyPointImpl(this.getVoltageLevel().getId(), this.getNode());
    }

    NodeTerminal(Ref<? extends VariantManagerHolder> network, ThreeSides side, TerminalNumber terminalNumber, int node) {
        super(network, side, terminalNumber);
        this.node = node;
        int variantArraySize = ((VariantManagerHolder)network.get()).getVariantManager().getVariantArraySize();
        this.v = new TDoubleArrayList(variantArraySize);
        this.angle = new TDoubleArrayList(variantArraySize);
        this.connectedComponentNumber = new TIntArrayList(variantArraySize);
        this.synchronousComponentNumber = new TIntArrayList(variantArraySize);
        for (int i = 0; i < variantArraySize; ++i) {
            this.v.add(Double.NaN);
            this.angle.add(Double.NaN);
            this.connectedComponentNumber.add(0);
            this.synchronousComponentNumber.add(0);
        }
    }

    protected void notifyUpdate(String attribute, String variantId, Object oldValue, Object newValue) {
        this.getConnectable().notifyUpdate(attribute, variantId, oldValue, newValue);
    }

    public int getNode() {
        return this.node;
    }

    @Override
    protected double getV() {
        if (this.removed) {
            throw new PowsyblException("Cannot access v of removed equipment " + this.connectable.id);
        }
        return this.v.get(this.getVariantManagerHolder().getVariantIndex());
    }

    void setV(double v) {
        if (this.removed) {
            throw new PowsyblException("Cannot modify removed equipment " + this.connectable.id);
        }
        if (v < 0.0) {
            throw new ValidationException((Validable)this.connectable, "voltage cannot be < 0");
        }
        int variantIndex = this.getVariantManagerHolder().getVariantIndex();
        double oldValue = this.v.set(variantIndex, v);
        String variantId = this.getVariantManagerHolder().getVariantManager().getVariantId(variantIndex);
        this.notifyUpdate("v", variantId, oldValue, v);
    }

    double getAngle() {
        if (this.removed) {
            throw new PowsyblException("Cannot access angle of removed equipment " + this.connectable.id);
        }
        return this.angle.get(this.getVariantManagerHolder().getVariantIndex());
    }

    void setAngle(double angle) {
        if (this.removed) {
            throw new PowsyblException("Cannot modify removed equipment " + this.connectable.id);
        }
        int variantIndex = this.getVariantManagerHolder().getVariantIndex();
        double oldValue = this.angle.set(variantIndex, angle);
        String variantId = this.getVariantManagerHolder().getVariantManager().getVariantId(variantIndex);
        this.notifyUpdate("angle", variantId, oldValue, angle);
    }

    int getConnectedComponentNumber() {
        if (this.removed) {
            throw new PowsyblException("Cannot access connected component of removed equipment " + this.connectable.id);
        }
        return this.connectedComponentNumber.get(this.getVariantManagerHolder().getVariantIndex());
    }

    void setConnectedComponentNumber(int connectedComponentNumber) {
        if (this.removed) {
            throw new PowsyblException("Cannot modify removed equipment " + this.connectable.id);
        }
        int variantIndex = this.getVariantManagerHolder().getVariantIndex();
        int oldValue = this.connectedComponentNumber.set(variantIndex, connectedComponentNumber);
        String variantId = this.getVariantManagerHolder().getVariantManager().getVariantId(variantIndex);
        this.notifyUpdate("connectedComponentNumber", variantId, oldValue, connectedComponentNumber);
    }

    int getSynchronousComponentNumber() {
        if (this.removed) {
            throw new PowsyblException("Cannot access synchronous component of removed equipment " + this.connectable.id);
        }
        return this.synchronousComponentNumber.get(this.getVariantManagerHolder().getVariantIndex());
    }

    void setSynchronousComponentNumber(int componentNumber) {
        if (this.removed) {
            throw new PowsyblException("Cannot modify removed equipment " + this.connectable.id);
        }
        int variantIndex = this.getVariantManagerHolder().getVariantIndex();
        int oldValue = this.synchronousComponentNumber.set(variantIndex, componentNumber);
        String variantId = this.getVariantManagerHolder().getVariantManager().getVariantId(variantIndex);
        this.notifyUpdate("synchronousComponentNumber", variantId, oldValue, componentNumber);
    }

    public Terminal.NodeBreakerView getNodeBreakerView() {
        return this.nodeBreakerView;
    }

    @Override
    public TerminalExt.BusBreakerViewExt getBusBreakerView() {
        return this.busBreakerView;
    }

    @Override
    public TerminalExt.BusViewExt getBusView() {
        return this.busView;
    }

    public boolean isConnected() {
        if (this.removed) {
            throw new PowsyblException("Cannot access connectivity status of removed equipment " + this.connectable.id);
        }
        return this.getTopologyModel().isConnected(this);
    }

    @Override
    public boolean traverse(Terminal.TopologyTraverser traverser, Set<Terminal> visitedTerminals, TraversalType traversalType) {
        if (this.removed) {
            throw new PowsyblException(String.format("Associated equipment %s is removed", this.connectable.id));
        }
        return this.getTopologyModel().traverse(this, traverser, visitedTerminals, traversalType);
    }

    public void traverse(Terminal.TopologyTraverser traverser) {
        this.traverse(traverser, TraversalType.DEPTH_FIRST);
    }

    public void traverse(Terminal.TopologyTraverser traverser, TraversalType traversalType) {
        if (this.removed) {
            throw new PowsyblException(String.format("Associated equipment %s is removed", this.connectable.id));
        }
        this.getTopologyModel().traverse(this, traverser, traversalType);
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        super.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
        this.v.ensureCapacity(this.v.size() + number);
        this.angle.ensureCapacity(this.angle.size() + number);
        this.connectedComponentNumber.ensureCapacity(this.connectedComponentNumber.size() + number);
        this.synchronousComponentNumber.ensureCapacity(this.synchronousComponentNumber.size() + number);
        for (int i = 0; i < number; ++i) {
            this.v.add(this.v.get(sourceIndex));
            this.angle.add(this.angle.get(sourceIndex));
            this.connectedComponentNumber.add(this.connectedComponentNumber.get(sourceIndex));
            this.synchronousComponentNumber.add(this.synchronousComponentNumber.get(sourceIndex));
        }
    }

    @Override
    public void reduceVariantArraySize(int number) {
        super.reduceVariantArraySize(number);
        this.v.remove(this.v.size() - number, number);
        this.angle.remove(this.angle.size() - number, number);
        this.connectedComponentNumber.remove(this.connectedComponentNumber.size() - number, number);
        this.synchronousComponentNumber.remove(this.synchronousComponentNumber.size() - number, number);
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        super.allocateVariantArrayElement(indexes, sourceIndex);
        for (int index : indexes) {
            this.v.set(index, this.v.get(sourceIndex));
            this.angle.set(index, this.angle.get(sourceIndex));
            this.connectedComponentNumber.set(index, this.connectedComponentNumber.get(sourceIndex));
            this.synchronousComponentNumber.set(index, this.synchronousComponentNumber.get(sourceIndex));
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.node + "]";
    }
}

