/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.DefaultMessageHeader;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.OverloadManagementSystem;
import com.powsybl.iidm.network.OverloadManagementSystemAdder;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.impl.AbstractIdentifiableAdder;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.OverloadManagementSystemImpl;
import com.powsybl.iidm.network.impl.SubstationImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;

class OverloadManagementSystemAdderImpl
extends AbstractIdentifiableAdder<OverloadManagementSystemAdderImpl>
implements OverloadManagementSystemAdder {
    private final SubstationImpl substation;
    private boolean enabled = true;
    private String monitoredElementId;
    private ThreeSides monitoredElementSide;
    private final List<AbstractTrippingAdderImpl<?>> trippingAdders = new ArrayList();

    OverloadManagementSystemAdderImpl(SubstationImpl substation) {
        this.substation = Objects.requireNonNull(substation);
    }

    @Override
    protected NetworkImpl getNetwork() {
        return this.substation.getNetwork();
    }

    @Override
    protected String getTypeDescription() {
        return "Overload management system";
    }

    public OverloadManagementSystemAdder setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public OverloadManagementSystemAdder setMonitoredElementId(String monitoredElementId) {
        this.monitoredElementId = monitoredElementId;
        return this;
    }

    public OverloadManagementSystemAdder setMonitoredElementSide(ThreeSides monitoredElementSide) {
        this.monitoredElementSide = monitoredElementSide;
        return this;
    }

    public OverloadManagementSystemAdder.SwitchTrippingAdder newSwitchTripping() {
        return new SwitchTrippingAdderImpl(this);
    }

    public OverloadManagementSystemAdder.BranchTrippingAdder newBranchTripping() {
        return new BranchTrippingAdderImpl(this);
    }

    public OverloadManagementSystemAdder.ThreeWindingsTransformerTrippingAdder newThreeWindingsTransformerTripping() {
        return new ThreeWindingsTransformerTrippingAdderImpl(this);
    }

    public OverloadManagementSystem add() {
        String id = this.checkAndGetUniqueId();
        OverloadManagementSystemImpl overloadManagementSystem = new OverloadManagementSystemImpl(id, this.getName(), this.substation, this.monitoredElementId, this.monitoredElementSide, this.enabled);
        HashSet<String> knownTrippingKeys = new HashSet<String>();
        for (AbstractTrippingAdderImpl<?> adder : this.trippingAdders) {
            overloadManagementSystem.addTripping(this.createTripping(adder, id, knownTrippingKeys));
        }
        this.getNetwork().getIndex().checkAndAdd(overloadManagementSystem);
        this.substation.addOverloadManagementSystem(overloadManagementSystem);
        this.getNetwork().getListeners().notifyCreation(overloadManagementSystem);
        return overloadManagementSystem;
    }

    private OverloadManagementSystem.Tripping createTripping(AbstractTrippingAdderImpl<?> adder, String overloadManagementSystemId, Set<String> knownTrippingKeys) {
        String key = adder.key;
        if (!knownTrippingKeys.add(key)) {
            throw new ValidationException(adder, "key \"" + key + "\" is already used for another tripping in the overload management system.");
        }
        return switch (adder.getType()) {
            default -> throw new MatchException(null, null);
            case OverloadManagementSystem.Tripping.Type.SWITCH_TRIPPING -> this.createTripping((SwitchTrippingAdderImpl)adder, overloadManagementSystemId);
            case OverloadManagementSystem.Tripping.Type.BRANCH_TRIPPING -> this.createTripping((BranchTrippingAdderImpl)adder, overloadManagementSystemId);
            case OverloadManagementSystem.Tripping.Type.THREE_WINDINGS_TRANSFORMER_TRIPPING -> this.createTripping((ThreeWindingsTransformerTrippingAdderImpl)adder, overloadManagementSystemId);
        };
    }

    private OverloadManagementSystem.Tripping createTripping(SwitchTrippingAdderImpl adder, String overloadManagementSystemId) {
        return new OverloadManagementSystemImpl.SwitchTrippingImpl(overloadManagementSystemId, adder.key, adder.name, adder.currentLimit, adder.openAction, adder.checkSwitchId());
    }

    private OverloadManagementSystem.Tripping createTripping(BranchTrippingAdderImpl adder, String overloadManagementSystemId) {
        return new OverloadManagementSystemImpl.BranchTrippingImpl(overloadManagementSystemId, adder.key, adder.name, adder.currentLimit, adder.openAction, adder.checkBranchId(), adder.side);
    }

    private OverloadManagementSystem.Tripping createTripping(ThreeWindingsTransformerTrippingAdderImpl adder, String overloadManagementSystemId) {
        return new OverloadManagementSystemImpl.ThreeWindingsTransformerTrippingImpl(overloadManagementSystemId, adder.key, adder.name, adder.currentLimit, adder.openAction, adder.checkThreeWindingsTransformerId(), adder.side);
    }

    class SwitchTrippingAdderImpl
    extends AbstractTrippingAdderImpl<OverloadManagementSystemAdder.SwitchTrippingAdder>
    implements OverloadManagementSystemAdder.SwitchTrippingAdder {
        private String switchId;

        SwitchTrippingAdderImpl(OverloadManagementSystemAdderImpl this$0) {
        }

        public OverloadManagementSystemAdder.SwitchTrippingAdder setSwitchToOperateId(String switchId) {
            this.switchId = switchId;
            return this;
        }

        protected String checkSwitchId() {
            return this.checkElementId(this.switchId, Network::getSwitch, "switchId", "switch");
        }
    }

    class BranchTrippingAdderImpl
    extends AbstractTrippingAdderImpl<OverloadManagementSystemAdder.BranchTrippingAdder>
    implements OverloadManagementSystemAdder.BranchTrippingAdder {
        private String branchId;
        private TwoSides side;

        BranchTrippingAdderImpl(OverloadManagementSystemAdderImpl this$0) {
        }

        public OverloadManagementSystemAdder.BranchTrippingAdder setBranchToOperateId(String branchId) {
            this.branchId = branchId;
            return this;
        }

        public OverloadManagementSystemAdder.BranchTrippingAdder setSideToOperate(TwoSides side) {
            this.side = side;
            return this;
        }

        protected String checkBranchId() {
            return this.checkElementId(this.branchId, Network::getBranch, "branchId", "branch");
        }
    }

    class ThreeWindingsTransformerTrippingAdderImpl
    extends AbstractTrippingAdderImpl<OverloadManagementSystemAdder.ThreeWindingsTransformerTrippingAdder>
    implements OverloadManagementSystemAdder.ThreeWindingsTransformerTrippingAdder {
        private String threeWindingsTransformerId;
        private ThreeSides side;

        ThreeWindingsTransformerTrippingAdderImpl(OverloadManagementSystemAdderImpl this$0) {
        }

        public OverloadManagementSystemAdder.ThreeWindingsTransformerTrippingAdder setThreeWindingsTransformerToOperateId(String threeWindingsTransformerId) {
            this.threeWindingsTransformerId = threeWindingsTransformerId;
            return this;
        }

        public OverloadManagementSystemAdder.ThreeWindingsTransformerTrippingAdder setSideToOperate(ThreeSides side) {
            this.side = side;
            return this;
        }

        protected String checkThreeWindingsTransformerId() {
            return this.checkElementId(this.threeWindingsTransformerId, Network::getThreeWindingsTransformer, "threeWindingsTransformerId", "three windings transformer");
        }
    }

    abstract class AbstractTrippingAdderImpl<I extends OverloadManagementSystemAdder.TrippingAdder<I>>
    implements Validable,
    OverloadManagementSystemAdder.TrippingAdder<I> {
        protected String key = null;
        protected String name = null;
        protected double currentLimit = Double.NaN;
        protected boolean openAction = true;

        AbstractTrippingAdderImpl() {
        }

        public I setKey(String key) {
            this.key = key;
            return (I)this;
        }

        public I setName(String name) {
            this.name = name;
            return (I)this;
        }

        public I setCurrentLimit(double currentLimit) {
            this.currentLimit = currentLimit;
            return (I)this;
        }

        public I setOpenAction(boolean open) {
            this.openAction = open;
            return (I)this;
        }

        public OverloadManagementSystemAdder add() {
            OverloadManagementSystemAdderImpl.this.trippingAdders.add(this);
            return OverloadManagementSystemAdderImpl.this;
        }

        protected String getTrippingAttribute() {
            return String.format("tripping '%s'", this.key);
        }

        public Validable.MessageHeader getMessageHeader() {
            String type = "Overload management system with " + this.getTrippingAttribute();
            return new DefaultMessageHeader(type, OverloadManagementSystemAdderImpl.this.substation.getId(), "substation");
        }

        protected static String getNotFoundMessage(String type, String id) {
            return type + " '" + id + "' not found";
        }

        protected <E> String checkElementId(String elementId, BiFunction<Network, String, E> getter, String attributeName, String type) {
            if (elementId == null) {
                throw new ValidationException((Validable)this, attributeName + " is not set");
            }
            E element = getter.apply(OverloadManagementSystemAdderImpl.this.getNetwork(), elementId);
            if (element == null) {
                throw new ValidationException((Validable)this, AbstractTrippingAdderImpl.getNotFoundMessage(type, elementId));
            }
            return elementId;
        }
    }
}

