/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.PhaseTapChangerAdder;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractTapChangerAdderImpl;
import com.powsybl.iidm.network.impl.PhaseTapChangerImpl;
import com.powsybl.iidm.network.impl.PhaseTapChangerParent;
import com.powsybl.iidm.network.impl.PhaseTapChangerStepImpl;
import com.powsybl.iidm.network.impl.TerminalExt;
import java.util.List;

class PhaseTapChangerAdderImpl
extends AbstractTapChangerAdderImpl<PhaseTapChangerAdderImpl, PhaseTapChangerParent, PhaseTapChanger, PhaseTapChangerStepImpl>
implements PhaseTapChangerAdder {
    private PhaseTapChanger.RegulationMode regulationMode = PhaseTapChanger.RegulationMode.CURRENT_LIMITER;

    PhaseTapChangerAdderImpl(PhaseTapChangerParent parent) {
        super(parent, true);
    }

    public PhaseTapChangerAdder setRegulationMode(PhaseTapChanger.RegulationMode regulationMode) {
        this.regulationMode = regulationMode;
        return this;
    }

    public PhaseTapChangerAdder.StepAdder beginStep() {
        return new StepAdderImpl();
    }

    @Override
    protected PhaseTapChanger createTapChanger(PhaseTapChangerParent parent, int lowTapPosition, List<PhaseTapChangerStepImpl> steps, TerminalExt regulationTerminal, Integer tapPosition, Integer solvedTapPosition, boolean regulating, boolean loadTapChangingCapabilities, double regulationValue, double targetDeadband) {
        PhaseTapChangerImpl tapChanger = new PhaseTapChangerImpl(parent, lowTapPosition, steps, regulationTerminal, loadTapChangingCapabilities, tapPosition, solvedTapPosition, regulating, this.regulationMode, regulationValue, targetDeadband);
        parent.setPhaseTapChanger(tapChanger);
        return tapChanger;
    }

    @Override
    protected PhaseTapChangerAdderImpl self() {
        return this;
    }

    @Override
    protected ValidationLevel checkTapChangerRegulation(PhaseTapChangerParent parent, double regulationValue, boolean regulating, boolean loadTapChangingCapabilities, TerminalExt regulationTerminal) {
        return ValidationUtil.checkPhaseTapChangerRegulation((Validable)parent, (PhaseTapChanger.RegulationMode)this.regulationMode, (double)regulationValue, (boolean)regulating, (boolean)loadTapChangingCapabilities, (Terminal)regulationTerminal, (Network)this.getNetwork(), (ValidationLevel)this.getNetwork().getMinValidationLevel(), (ReportNode)this.getNetwork().getReportNodeContext().getReportNode());
    }

    @Override
    protected String getValidableType() {
        return "phase tap changer";
    }

    class StepAdderImpl
    implements PhaseTapChangerAdder.StepAdder {
        private double alpha = Double.NaN;
        private double rho = 1.0;
        private double r = 0.0;
        private double x = 0.0;
        private double g = 0.0;
        private double b = 0.0;

        StepAdderImpl() {
        }

        public PhaseTapChangerAdder.StepAdder setAlpha(double alpha) {
            this.alpha = alpha;
            return this;
        }

        public PhaseTapChangerAdder.StepAdder setRho(double rho) {
            this.rho = rho;
            return this;
        }

        public PhaseTapChangerAdder.StepAdder setR(double r) {
            this.r = r;
            return this;
        }

        public PhaseTapChangerAdder.StepAdder setX(double x) {
            this.x = x;
            return this;
        }

        public PhaseTapChangerAdder.StepAdder setG(double g) {
            this.g = g;
            return this;
        }

        public PhaseTapChangerAdder.StepAdder setB(double b) {
            this.b = b;
            return this;
        }

        public PhaseTapChangerAdder endStep() {
            PhaseTapChangerStepImpl step = new PhaseTapChangerStepImpl(PhaseTapChangerAdderImpl.this.steps.size(), this.alpha, this.rho, this.r, this.x, this.g, this.b);
            step.validate(PhaseTapChangerAdderImpl.this.parent);
            PhaseTapChangerAdderImpl.this.steps.add(step);
            return PhaseTapChangerAdderImpl.this;
        }
    }
}

