/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.ReactiveCapabilityCurve;
import com.powsybl.iidm.network.ReactiveLimitsKind;
import com.powsybl.iidm.network.util.ReactiveCapabilityCurveUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeMap;
import java.util.function.ToDoubleFunction;

class ReactiveCapabilityCurveImpl
implements ReactiveCapabilityCurve {
    private static final Comparator<Double> COMPARATOR = (d1, d2) -> d1 - d2 == 0.0 ? 0 : Double.compare(d1, d2);
    private final String ownerDescription;
    private final TreeMap<Double, ReactiveCapabilityCurve.Point> points;

    private static void checkPointsSize(TreeMap<Double, ReactiveCapabilityCurve.Point> points) {
        if (points.size() < 2) {
            throw new IllegalStateException("points size should be >= 2");
        }
    }

    ReactiveCapabilityCurveImpl(TreeMap<Double, ReactiveCapabilityCurve.Point> points, String ownerDescription) {
        ReactiveCapabilityCurveImpl.checkPointsSize(points);
        this.points = new TreeMap(COMPARATOR);
        this.points.putAll(points);
        this.ownerDescription = ownerDescription;
    }

    public Collection<ReactiveCapabilityCurve.Point> getPoints() {
        return Collections.unmodifiableCollection(this.points.values());
    }

    public int getPointCount() {
        return this.points.size();
    }

    public double getMinP() {
        return this.points.firstKey();
    }

    public double getMaxP() {
        return this.points.lastKey();
    }

    public ReactiveLimitsKind getKind() {
        return ReactiveLimitsKind.CURVE;
    }

    public double getMinQ(double p) {
        return this.getMinQ(p, false);
    }

    public double getMaxQ(double p) {
        return this.getMaxQ(p, false);
    }

    public double getMinQ(double p, boolean extrapolateReactiveLimitSlope) {
        return this.getReactiveLimit(p, extrapolateReactiveLimitSlope, ReactiveCapabilityCurve.Point::getMinQ);
    }

    public double getMaxQ(double p, boolean extrapolateReactiveLimitSlope) {
        return this.getReactiveLimit(p, extrapolateReactiveLimitSlope, ReactiveCapabilityCurve.Point::getMaxQ);
    }

    private double getReactiveLimit(double p, boolean extrapolateReactiveLimitSlope, ToDoubleFunction<ReactiveCapabilityCurve.Point> getMinOrMaxQ) {
        ReactiveCapabilityCurveImpl.checkPointsSize(this.points);
        ReactiveCapabilityCurve.Point pt = this.points.get(p);
        if (pt != null) {
            return getMinOrMaxQ.applyAsDouble(pt);
        }
        if (p >= this.getMinP() && p <= this.getMaxP()) {
            ReactiveCapabilityCurve.Point p1 = this.points.floorEntry(p).getValue();
            ReactiveCapabilityCurve.Point p2 = this.points.ceilingEntry(p).getValue();
            return getMinOrMaxQ.applyAsDouble(p1) + (getMinOrMaxQ.applyAsDouble(p2) - getMinOrMaxQ.applyAsDouble(p1)) / (p2.getP() - p1.getP()) * (p - p1.getP());
        }
        if (extrapolateReactiveLimitSlope) {
            ReactiveCapabilityCurve.Point extrapolatedPoint = ReactiveCapabilityCurveUtil.extrapolateReactiveLimitsSlope((double)p, this.points, PointImpl::new, (String)this.ownerDescription);
            return getMinOrMaxQ.applyAsDouble(extrapolatedPoint);
        }
        if (p < this.getMinP()) {
            ReactiveCapabilityCurve.Point pMin = this.points.firstEntry().getValue();
            return getMinOrMaxQ.applyAsDouble(pMin);
        }
        ReactiveCapabilityCurve.Point pMax = this.points.lastEntry().getValue();
        return getMinOrMaxQ.applyAsDouble(pMax);
    }

    static class PointImpl
    implements ReactiveCapabilityCurve.Point {
        private double p;
        private double minQ;
        private double maxQ;

        PointImpl(double p, double minQ, double maxQ) {
            this.p = p;
            this.minQ = minQ;
            this.maxQ = maxQ;
        }

        public double getP() {
            return this.p;
        }

        public double getMinQ() {
            return this.minQ;
        }

        public double getMaxQ() {
            return this.maxQ;
        }
    }
}

