/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.ReactiveLimits;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.impl.AbstractConnectable;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.ReactiveLimitsOwner;
import java.util.Objects;

class ReactiveLimitsHolderImpl
implements ReactiveLimitsOwner {
    private final AbstractConnectable<?> connectable;
    private ReactiveLimits reactiveLimits;

    public ReactiveLimitsHolderImpl(AbstractConnectable<?> connectable, ReactiveLimits reactiveLimits) {
        this.connectable = Objects.requireNonNull(connectable);
        this.reactiveLimits = Objects.requireNonNull(reactiveLimits);
    }

    public ReactiveLimits getReactiveLimits() {
        return this.reactiveLimits;
    }

    public <L extends ReactiveLimits> L getReactiveLimits(Class<L> type) {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (type.isInstance(this.reactiveLimits)) {
            return (L)((ReactiveLimits)type.cast(this.reactiveLimits));
        }
        throw new ValidationException(this.connectable, "incorrect reactive limits type " + type.getName() + ", expected " + String.valueOf(this.reactiveLimits.getClass()));
    }

    @Override
    public NetworkImpl getNetwork() {
        return this.connectable.getNetwork();
    }

    @Override
    public void setReactiveLimits(ReactiveLimits reactiveLimits) {
        ReactiveLimits oldValue = this.reactiveLimits;
        this.reactiveLimits = Objects.requireNonNull(reactiveLimits);
        this.connectable.notifyUpdate("reactiveLimits", (Object)oldValue, (Object)reactiveLimits);
    }
}

