/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.ShuntCompensatorLinearModel;
import com.powsybl.iidm.network.ShuntCompensatorModelType;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.ShuntCompensatorImpl;
import com.powsybl.iidm.network.impl.ShuntCompensatorModelExt;
import java.util.Objects;

class ShuntCompensatorLinearModelImpl
implements ShuntCompensatorModelExt,
ShuntCompensatorLinearModel {
    private ShuntCompensatorImpl shuntCompensator;
    private double bPerSection;
    private double gPerSection;
    private int maximumSectionCount;

    ShuntCompensatorLinearModelImpl(double bPerSection, double gPerSection, int maximumSectionCount) {
        this.bPerSection = bPerSection;
        this.gPerSection = gPerSection;
        this.maximumSectionCount = maximumSectionCount;
    }

    @Override
    public ShuntCompensatorLinearModelImpl attach(ShuntCompensatorImpl shuntCompensator) {
        if (this.shuntCompensator != null) {
            throw new IllegalStateException("ShuntCompensatorLinearModelImpl already attached to " + this.shuntCompensator.getId());
        }
        this.shuntCompensator = Objects.requireNonNull(shuntCompensator);
        return this;
    }

    public double getBPerSection() {
        return this.bPerSection;
    }

    public ShuntCompensatorLinearModel setBPerSection(double bPerSection) {
        ValidationUtil.checkBPerSection((Validable)this.shuntCompensator, (double)bPerSection);
        double oldValue = this.bPerSection;
        this.bPerSection = bPerSection;
        this.shuntCompensator.notifyUpdate("bPerSection", (Object)oldValue, (Object)bPerSection);
        return this;
    }

    public double getGPerSection() {
        return this.gPerSection;
    }

    public ShuntCompensatorLinearModel setGPerSection(double gPerSection) {
        double oldValue = this.gPerSection;
        this.gPerSection = gPerSection;
        this.shuntCompensator.notifyUpdate("gPerSection", (Object)oldValue, (Object)gPerSection);
        return this;
    }

    @Override
    public int getMaximumSectionCount() {
        return this.maximumSectionCount;
    }

    @Override
    public double getB(int sectionCount) {
        if (sectionCount < 0 || sectionCount > this.maximumSectionCount) {
            throw new PowsyblException("the given count of sections in service (" + sectionCount + ") is invalid (negative or strictly greater than the maximum sections count");
        }
        return this.bPerSection * (double)sectionCount;
    }

    @Override
    public double getG(int sectionCount) {
        if (sectionCount < 0 || sectionCount > this.maximumSectionCount) {
            throw new PowsyblException("the given count of sections in service (" + sectionCount + ") is invalid (negative or strictly greater than the maximum sections count");
        }
        return Double.isNaN(this.gPerSection) ? 0.0 : this.gPerSection * (double)sectionCount;
    }

    public ShuntCompensatorLinearModel setMaximumSectionCount(int maximumSectionCount) {
        ValidationUtil.checkSections((Validable)this.shuntCompensator, (Integer)(this.shuntCompensator.findSectionCount().isPresent() ? Integer.valueOf(this.shuntCompensator.getSectionCount()) : null), (int)maximumSectionCount, (ValidationLevel)this.shuntCompensator.getNetwork().getMinValidationLevel(), (ReportNode)this.shuntCompensator.getNetwork().getReportNodeContext().getReportNode());
        int oldValue = this.maximumSectionCount;
        this.maximumSectionCount = maximumSectionCount;
        this.shuntCompensator.notifyUpdate("maximumSectionCount", (Object)oldValue, (Object)maximumSectionCount);
        return this;
    }

    @Override
    public ShuntCompensatorModelType getType() {
        return ShuntCompensatorModelType.LINEAR;
    }
}

