/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.StaticVarCompensatorAdder;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractInjectionAdder;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.StaticVarCompensatorImpl;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.VoltageLevelExt;
import java.util.Objects;

class StaticVarCompensatorAdderImpl
extends AbstractInjectionAdder<StaticVarCompensatorAdderImpl>
implements StaticVarCompensatorAdder {
    private double bMin = Double.NaN;
    private double bMax = Double.NaN;
    private double voltageSetpoint = Double.NaN;
    private double reactivePowerSetpoint = Double.NaN;
    private StaticVarCompensator.RegulationMode regulationMode;
    private TerminalExt regulatingTerminal;
    private Boolean regulating;

    StaticVarCompensatorAdderImpl(VoltageLevelExt vl) {
        this.voltageLevel = Objects.requireNonNull(vl);
    }

    @Override
    protected String getTypeDescription() {
        return "Static var compensator";
    }

    public StaticVarCompensatorAdderImpl setBmin(double bMin) {
        this.bMin = bMin;
        return this;
    }

    public StaticVarCompensatorAdderImpl setBmax(double bMax) {
        this.bMax = bMax;
        return this;
    }

    public StaticVarCompensatorAdderImpl setVoltageSetpoint(double voltageSetpoint) {
        this.voltageSetpoint = voltageSetpoint;
        return this;
    }

    public StaticVarCompensatorAdderImpl setReactivePowerSetpoint(double reactivePowerSetpoint) {
        this.reactivePowerSetpoint = reactivePowerSetpoint;
        return this;
    }

    public StaticVarCompensatorAdderImpl setRegulationMode(StaticVarCompensator.RegulationMode regulationMode) {
        this.regulationMode = regulationMode;
        return this;
    }

    public StaticVarCompensatorAdderImpl setRegulatingTerminal(Terminal regulatingTerminal) {
        this.regulatingTerminal = (TerminalExt)regulatingTerminal;
        return this;
    }

    public StaticVarCompensatorAdderImpl setRegulating(boolean regulating) {
        this.regulating = regulating;
        return this;
    }

    public StaticVarCompensatorImpl add() {
        NetworkImpl network = this.getNetwork();
        String id = this.checkAndGetUniqueId();
        String name = this.getName();
        if (network.getMinValidationLevel() == ValidationLevel.EQUIPMENT && this.regulating == null) {
            this.regulating = false;
        }
        if (this.regulationMode == null) {
            this.regulationMode = StaticVarCompensator.RegulationMode.VOLTAGE;
        }
        TerminalExt terminal = this.checkAndGetTerminal();
        ValidationUtil.checkBmin((Validable)this, (double)this.bMin);
        ValidationUtil.checkBmax((Validable)this, (double)this.bMax);
        ValidationUtil.checkRegulatingTerminal((Validable)this, (Terminal)this.regulatingTerminal, (Network)network);
        network.setValidationLevelIfGreaterThan(ValidationUtil.checkSvcRegulator((Validable)this, (Boolean)this.regulating, (double)this.voltageSetpoint, (double)this.reactivePowerSetpoint, (StaticVarCompensator.RegulationMode)this.regulationMode, (ValidationLevel)network.getMinValidationLevel(), (ReportNode)network.getReportNodeContext().getReportNode()));
        StaticVarCompensatorImpl svc = new StaticVarCompensatorImpl(id, name, this.isFictitious(), this.bMin, this.bMax, this.voltageSetpoint, this.reactivePowerSetpoint, this.regulationMode, this.regulating, this.regulatingTerminal, this.getNetworkRef());
        svc.addTerminal(terminal);
        this.voltageLevel.getTopologyModel().attach(terminal, false);
        network.getIndex().checkAndAdd(svc);
        network.getListeners().notifyCreation(svc);
        return svc;
    }
}

