/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Component;
import com.powsybl.iidm.network.DcBus;
import com.powsybl.iidm.network.Network;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class Subcomponent
implements Component {
    private final Component parent;
    private final Network subnetwork;

    Subcomponent(Component parent, Network subnetwork) {
        this.parent = parent;
        this.subnetwork = subnetwork;
    }

    public int getNum() {
        return this.parent.getNum();
    }

    public int getSize() {
        return this.parent.getSize();
    }

    public Iterable<Bus> getBuses() {
        return this.getBusStream().collect(Collectors.toSet());
    }

    public Stream<Bus> getBusStream() {
        return this.parent.getBusStream().filter(b -> b.getParentNetwork() == this.subnetwork);
    }

    public Iterable<DcBus> getDcBuses() {
        return this.getDcBusStream().collect(Collectors.toSet());
    }

    public Stream<DcBus> getDcBusStream() {
        return this.parent.getDcBusStream().filter(b -> b.getParentNetwork() == this.subnetwork);
    }
}

