/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.ref.Ref;
import com.powsybl.iidm.network.TerminalNumber;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.impl.BusTerminal;
import com.powsybl.iidm.network.impl.NodeTerminal;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.VariantManagerHolder;
import java.util.Objects;

class TerminalBuilder {
    private final Ref<? extends VariantManagerHolder> network;
    private final Validable validable;
    private final ThreeSides side;
    private final TerminalNumber terminalNumber;
    private Integer node;
    private String bus;
    private String connectableBus;

    TerminalBuilder(Ref<? extends VariantManagerHolder> network, Validable validable, ThreeSides side, TerminalNumber terminalNumber) {
        this.network = Objects.requireNonNull(network);
        this.validable = Objects.requireNonNull(validable);
        this.side = side;
        this.terminalNumber = terminalNumber;
    }

    TerminalBuilder setBus(String bus) {
        this.bus = bus;
        return this;
    }

    TerminalBuilder setConnectableBus(String connectableBus) {
        this.connectableBus = connectableBus;
        return this;
    }

    TerminalBuilder setNode(Integer node) {
        this.node = node;
        return this;
    }

    TerminalExt build() {
        String connectionBus = this.getConnectionBus();
        if (this.node != null && connectionBus != null) {
            throw new ValidationException(this.validable, "connection node and connection bus are exclusives");
        }
        if (this.node == null) {
            if (connectionBus == null) {
                throw new ValidationException(this.validable, "connectable bus is not set");
            }
            return new BusTerminal(this.network, this.side, this.terminalNumber, connectionBus, this.bus != null);
        }
        return new NodeTerminal(this.network, this.side, this.terminalNumber, this.node);
    }

    private String getConnectionBus() {
        if (this.bus != null) {
            if (this.connectableBus != null && !this.bus.equals(this.connectableBus)) {
                throw new ValidationException(this.validable, "connection bus is different to connectable bus");
            }
            return this.bus;
        }
        return this.connectableBus;
    }
}

