/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.DefaultMessageHeader;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.ThreeWindingsTransformerAdder;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractIdentifiableAdder;
import com.powsybl.iidm.network.impl.BusExt;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.SubstationImpl;
import com.powsybl.iidm.network.impl.TerminalBuilder;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.ThreeWindingsTransformerImpl;
import com.powsybl.iidm.network.impl.VoltageLevelExt;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ThreeWindingsTransformerAdderImpl
extends AbstractIdentifiableAdder<ThreeWindingsTransformerAdderImpl>
implements ThreeWindingsTransformerAdder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreeWindingsTransformerAdderImpl.class);
    private final SubstationImpl substation;
    private LegAdderImpl legAdder1;
    private LegAdderImpl legAdder2;
    private LegAdderImpl legAdder3;
    private double ratedU0 = Double.NaN;

    ThreeWindingsTransformerAdderImpl(SubstationImpl substation) {
        this.substation = substation;
    }

    @Override
    protected NetworkImpl getNetwork() {
        return this.substation.getNetwork();
    }

    @Override
    protected String getTypeDescription() {
        return "3 windings transformer";
    }

    public ThreeWindingsTransformerAdder.LegAdder newLeg1() {
        return new LegAdderImpl(ThreeSides.ONE);
    }

    public ThreeWindingsTransformerAdder.LegAdder newLeg2() {
        return new LegAdderImpl(ThreeSides.TWO);
    }

    public ThreeWindingsTransformerAdder.LegAdder newLeg3() {
        return new LegAdderImpl(ThreeSides.THREE);
    }

    public ThreeWindingsTransformerAdder setRatedU0(double ratedU0) {
        this.ratedU0 = ratedU0;
        return this;
    }

    public ThreeWindingsTransformerImpl add() {
        String id = this.checkAndGetUniqueId();
        if (this.legAdder1 == null) {
            throw new ValidationException((Validable)this, "Leg1 is not set");
        }
        this.legAdder1.checkConnectableBus();
        VoltageLevelExt voltageLevel1 = this.legAdder1.checkAndGetVoltageLevel();
        TerminalExt terminal1 = this.legAdder1.checkAndGetTerminal();
        ThreeWindingsTransformerImpl.LegImpl leg1 = new ThreeWindingsTransformerImpl.LegImpl(this.legAdder1.r, this.legAdder1.x, this.legAdder1.g, this.legAdder1.b, this.legAdder1.ratedU, this.legAdder1.ratedS, this.legAdder1.side);
        if (this.legAdder2 == null) {
            throw new ValidationException((Validable)this, "Leg2 is not set");
        }
        this.legAdder2.checkConnectableBus();
        VoltageLevelExt voltageLevel2 = this.legAdder2.checkAndGetVoltageLevel();
        TerminalExt terminal2 = this.legAdder2.checkAndGetTerminal();
        ThreeWindingsTransformerImpl.LegImpl leg2 = new ThreeWindingsTransformerImpl.LegImpl(this.legAdder2.r, this.legAdder2.x, this.legAdder2.g, this.legAdder2.b, this.legAdder2.ratedU, this.legAdder2.ratedS, this.legAdder2.side);
        if (this.legAdder3 == null) {
            throw new ValidationException((Validable)this, "Leg3 is not set");
        }
        this.legAdder3.checkConnectableBus();
        VoltageLevelExt voltageLevel3 = this.legAdder3.checkAndGetVoltageLevel();
        TerminalExt terminal3 = this.legAdder3.checkAndGetTerminal();
        ThreeWindingsTransformerImpl.LegImpl leg3 = new ThreeWindingsTransformerImpl.LegImpl(this.legAdder3.r, this.legAdder3.x, this.legAdder3.g, this.legAdder3.b, this.legAdder3.ratedU, this.legAdder3.ratedS, this.legAdder3.side);
        if (voltageLevel1.getSubstation().map(s -> s != this.substation).orElse(true).booleanValue() || voltageLevel2.getSubstation().map(s -> s != this.substation).orElse(true).booleanValue() || voltageLevel3.getSubstation().map(s -> s != this.substation).orElse(true).booleanValue()) {
            throw new ValidationException((Validable)this, "the 3 windings of the transformer shall belong to the substation '" + this.substation.getId() + "' ('" + voltageLevel1.getSubstation().map(Identifiable::getId).orElse("null") + "', '" + voltageLevel2.getSubstation().map(Identifiable::getId).orElse("null") + "', '" + voltageLevel3.getSubstation().map(Identifiable::getId).orElse("null") + "')");
        }
        if (Double.isNaN(this.ratedU0)) {
            this.ratedU0 = leg1.getRatedU();
            LOGGER.info("RatedU0 is not set. Fixed to leg1 ratedU: {}", (Object)leg1.getRatedU());
        }
        ThreeWindingsTransformerImpl transformer = new ThreeWindingsTransformerImpl(this.substation.getNetworkRef(), id, this.getName(), this.isFictitious(), leg1, leg2, leg3, this.ratedU0);
        transformer.addTerminal(terminal1);
        transformer.addTerminal(terminal2);
        transformer.addTerminal(terminal3);
        leg1.setTransformer(transformer);
        leg2.setTransformer(transformer);
        leg3.setTransformer(transformer);
        voltageLevel1.getTopologyModel().attach(terminal1, true);
        voltageLevel2.getTopologyModel().attach(terminal2, true);
        voltageLevel3.getTopologyModel().attach(terminal3, true);
        voltageLevel1.getTopologyModel().attach(terminal1, false);
        voltageLevel2.getTopologyModel().attach(terminal2, false);
        voltageLevel3.getTopologyModel().attach(terminal3, false);
        this.getNetwork().getIndex().checkAndAdd(transformer);
        this.getNetwork().getListeners().notifyCreation(transformer);
        return transformer;
    }

    class LegAdderImpl
    implements Validable,
    ThreeWindingsTransformerAdder.LegAdder {
        protected String voltageLevelId;
        protected Integer node;
        protected String bus;
        protected String connectableBus;
        protected double r = Double.NaN;
        protected double x = Double.NaN;
        protected double g = 0.0;
        protected double b = 0.0;
        protected double ratedU = Double.NaN;
        protected double ratedS = Double.NaN;
        private final ThreeSides side;

        LegAdderImpl(ThreeSides side) {
            this.side = Objects.requireNonNull(side);
        }

        public ThreeWindingsTransformerAdder.LegAdder setVoltageLevel(String voltageLevelId) {
            this.voltageLevelId = voltageLevelId;
            return this;
        }

        public ThreeWindingsTransformerAdder.LegAdder setNode(int node) {
            this.node = node;
            return this;
        }

        public ThreeWindingsTransformerAdder.LegAdder setBus(String bus) {
            this.bus = bus;
            return this;
        }

        public ThreeWindingsTransformerAdder.LegAdder setConnectableBus(String connectableBus) {
            this.connectableBus = connectableBus;
            return this;
        }

        public ThreeWindingsTransformerAdder.LegAdder setR(double r) {
            this.r = r;
            return this;
        }

        public ThreeWindingsTransformerAdder.LegAdder setX(double x) {
            this.x = x;
            return this;
        }

        public ThreeWindingsTransformerAdder.LegAdder setG(double g) {
            this.g = g;
            return this;
        }

        public ThreeWindingsTransformerAdder.LegAdder setB(double b) {
            this.b = b;
            return this;
        }

        public ThreeWindingsTransformerAdder.LegAdder setRatedU(double ratedU) {
            this.ratedU = ratedU;
            return this;
        }

        public ThreeWindingsTransformerAdder.LegAdder setRatedS(double ratedS) {
            this.ratedS = ratedS;
            return this;
        }

        protected void checkParams() {
            if (Double.isNaN(this.r)) {
                throw new ValidationException((Validable)this, "r is not set");
            }
            if (Double.isNaN(this.x)) {
                throw new ValidationException((Validable)this, "x is not set");
            }
            if (Double.isNaN(this.g)) {
                throw new ValidationException((Validable)this, "g is not set");
            }
            if (Double.isNaN(this.b)) {
                throw new ValidationException((Validable)this, "b is not set");
            }
            ValidationUtil.checkRatedU((Validable)this, (double)this.ratedU, (String)"");
            ValidationUtil.checkRatedS((Validable)this, (double)this.ratedS);
        }

        protected TerminalExt checkAndGetTerminal() {
            VoltageLevelExt voltageLevel = this.checkAndGetVoltageLevel();
            return new TerminalBuilder(voltageLevel.getNetworkRef(), this, this.side, null).setNode(this.node).setBus(this.bus).setConnectableBus(this.connectableBus).build();
        }

        protected VoltageLevelExt checkAndGetVoltageLevel() {
            VoltageLevelExt voltageLevel;
            if (this.voltageLevelId == null) {
                String defaultVoltageLevelId = this.checkAndGetDefaultVoltageLevelId();
                if (defaultVoltageLevelId == null) {
                    throw new ValidationException((Validable)this, "voltage level is not set and has no default value");
                }
                this.voltageLevelId = defaultVoltageLevelId;
            }
            if ((voltageLevel = ThreeWindingsTransformerAdderImpl.this.getNetwork().getVoltageLevel(this.voltageLevelId)) == null) {
                throw new ValidationException((Validable)this, "voltage level '" + this.voltageLevelId + "' not found");
            }
            return voltageLevel;
        }

        private String checkAndGetDefaultVoltageLevelId() {
            if (this.connectableBus == null) {
                return null;
            }
            BusExt busExt = (BusExt)ThreeWindingsTransformerAdderImpl.this.getNetwork().getBusBreakerView().getBus(this.connectableBus);
            if (busExt == null) {
                throw new ValidationException((Validable)this, "bus ID '" + this.connectableBus + "' not found");
            }
            return busExt.getVoltageLevel().getId();
        }

        protected void checkConnectableBus() {
            if (this.connectableBus == null && this.bus != null) {
                this.connectableBus = this.bus;
            }
        }

        public ThreeWindingsTransformerAdderImpl add() {
            this.checkParams();
            switch (this.side) {
                case ONE: {
                    ThreeWindingsTransformerAdderImpl.this.legAdder1 = this;
                    break;
                }
                case TWO: {
                    ThreeWindingsTransformerAdderImpl.this.legAdder2 = this;
                    break;
                }
                case THREE: {
                    ThreeWindingsTransformerAdderImpl.this.legAdder3 = this;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected side: " + String.valueOf(this.side));
                }
            }
            return ThreeWindingsTransformerAdderImpl.this;
        }

        public Validable.MessageHeader getMessageHeader() {
            return new DefaultMessageHeader("3 windings transformer leg" + this.side.getNum(), ThreeWindingsTransformerAdderImpl.this.substation.getId(), "substation");
        }
    }
}

