/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.ref.Ref;
import com.powsybl.iidm.network.ActivePowerLimits;
import com.powsybl.iidm.network.ActivePowerLimitsAdder;
import com.powsybl.iidm.network.ApparentPowerLimits;
import com.powsybl.iidm.network.ApparentPowerLimitsAdder;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.CurrentLimits;
import com.powsybl.iidm.network.CurrentLimitsAdder;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.LimitType;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.OperationalLimitsGroup;
import com.powsybl.iidm.network.Overload;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TieLine;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.impl.AbstractIdentifiable;
import com.powsybl.iidm.network.impl.BranchUtil;
import com.powsybl.iidm.network.impl.ConnectDisconnectUtil;
import com.powsybl.iidm.network.impl.DanglingLineImpl;
import com.powsybl.iidm.network.impl.NetworkExt;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.util.LimitViolationUtils;
import com.powsybl.iidm.network.util.SwitchPredicates;
import com.powsybl.iidm.network.util.TieLineUtil;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

class TieLineImpl
extends AbstractIdentifiable<TieLine>
implements TieLine {
    private DanglingLineImpl danglingLine1;
    private DanglingLineImpl danglingLine2;
    private final Ref<NetworkImpl> networkRef;
    private boolean removed = false;

    @Override
    public NetworkImpl getNetwork() {
        if (this.removed) {
            throw new PowsyblException("Cannot access network of removed tie line " + this.id);
        }
        return (NetworkImpl)this.networkRef.get();
    }

    public Network getParentNetwork() {
        NetworkExt subnetwork2;
        NetworkExt subnetwork1 = this.danglingLine1.getParentNetwork();
        if (subnetwork1 == (subnetwork2 = this.danglingLine2.getParentNetwork())) {
            return subnetwork1;
        }
        return (Network)this.networkRef.get();
    }

    @Override
    protected String getTypeDescription() {
        return "Tie Line";
    }

    TieLineImpl(Ref<NetworkImpl> network, String id, String name, boolean fictitious) {
        super(id, name, fictitious);
        this.networkRef = network;
    }

    void attachDanglingLines(DanglingLineImpl dl1, DanglingLineImpl dl2) {
        this.danglingLine1 = this.attach(dl1);
        this.danglingLine2 = this.attach(dl2);
    }

    private DanglingLineImpl attach(DanglingLineImpl danglingLine) {
        danglingLine.setTieLine(this);
        return danglingLine;
    }

    public String getPairingKey() {
        return Optional.ofNullable(this.danglingLine1.getPairingKey()).orElseGet(() -> this.danglingLine2.getPairingKey());
    }

    public DanglingLineImpl getDanglingLine1() {
        return this.danglingLine1;
    }

    public DanglingLineImpl getDanglingLine2() {
        return this.danglingLine2;
    }

    public DanglingLineImpl getDanglingLine(TwoSides side) {
        return BranchUtil.getFromSide(side, this::getDanglingLine1, this::getDanglingLine2);
    }

    public DanglingLine getDanglingLine(String voltageLevelId) {
        if (this.danglingLine1.getTerminal().getVoltageLevel().getId().equals(voltageLevelId)) {
            return this.danglingLine1;
        }
        if (this.danglingLine2.getTerminal().getVoltageLevel().getId().equals(voltageLevelId)) {
            return this.danglingLine2;
        }
        return null;
    }

    public double getR() {
        return TieLineUtil.getR((DanglingLine)this.danglingLine1, (DanglingLine)this.danglingLine2);
    }

    public double getX() {
        return TieLineUtil.getX((DanglingLine)this.danglingLine1, (DanglingLine)this.danglingLine2);
    }

    public double getG1() {
        return TieLineUtil.getG1((DanglingLine)this.danglingLine1, (DanglingLine)this.danglingLine2);
    }

    public double getB1() {
        return TieLineUtil.getB1((DanglingLine)this.danglingLine1, (DanglingLine)this.danglingLine2);
    }

    public double getG2() {
        return TieLineUtil.getG2((DanglingLine)this.danglingLine1, (DanglingLine)this.danglingLine2);
    }

    public double getB2() {
        return TieLineUtil.getB2((DanglingLine)this.danglingLine1, (DanglingLine)this.danglingLine2);
    }

    public void remove() {
        this.remove(false);
    }

    public void remove(boolean updateDanglingLines) {
        NetworkImpl network = this.getNetwork();
        network.getListeners().notifyBeforeRemoval(this);
        if (updateDanglingLines) {
            TieLineImpl.updateDanglingLine(this.danglingLine1);
            TieLineImpl.updateDanglingLine(this.danglingLine2);
        }
        this.danglingLine1.removeTieLine();
        this.danglingLine2.removeTieLine();
        network.getConnectedComponentsManager().invalidate();
        network.getSynchronousComponentsManager().invalidate();
        network.getIndex().remove(this);
        network.getListeners().notifyAfterRemoval(this.id);
        this.removed = true;
    }

    public boolean connectDanglingLines() {
        return this.connectDanglingLines(SwitchPredicates.IS_NONFICTIONAL_BREAKER, null);
    }

    public boolean connectDanglingLines(Predicate<Switch> isTypeSwitchToOperate) {
        return this.connectDanglingLines(isTypeSwitchToOperate, null);
    }

    public boolean connectDanglingLines(Predicate<Switch> isTypeSwitchToOperate, TwoSides side) {
        return ConnectDisconnectUtil.connectAllTerminals(this, this.getTerminalsOfDanglingLines(side), isTypeSwitchToOperate, this.getNetwork().getReportNodeContext().getReportNode());
    }

    public boolean disconnectDanglingLines() {
        return this.disconnectDanglingLines(SwitchPredicates.IS_CLOSED_BREAKER, null);
    }

    public boolean disconnectDanglingLines(Predicate<Switch> isSwitchOpenable) {
        return this.disconnectDanglingLines(isSwitchOpenable, null);
    }

    public boolean disconnectDanglingLines(Predicate<Switch> isSwitchOpenable, TwoSides side) {
        return ConnectDisconnectUtil.disconnectAllTerminals(this, this.getTerminalsOfDanglingLines(side), isSwitchOpenable, this.getNetwork().getReportNodeContext().getReportNode());
    }

    private List<Terminal> getTerminalsOfDanglingLines(TwoSides side) {
        List<Terminal> list;
        if (side == null) {
            list = List.of(this.getTerminal1(), this.getTerminal2());
        } else {
            switch (side) {
                default: {
                    throw new MatchException(null, null);
                }
                case ONE: {
                    list = List.of(this.getTerminal1());
                    break;
                }
                case TWO: {
                    list = List.of(this.getTerminal2());
                }
            }
        }
        return list;
    }

    public TerminalExt getTerminal1() {
        return this.danglingLine1.getTerminal();
    }

    public TerminalExt getTerminal2() {
        return this.danglingLine2.getTerminal();
    }

    public Terminal getTerminal(TwoSides side) {
        return BranchUtil.getFromSide(side, this::getTerminal1, this::getTerminal2);
    }

    public Terminal getTerminal(String voltageLevelId) {
        return BranchUtil.getTerminal(voltageLevelId, this.getTerminal1(), this.getTerminal2());
    }

    public TwoSides getSide(Terminal terminal) {
        return BranchUtil.getSide(terminal, this.getTerminal1(), this.getTerminal2());
    }

    public Optional<String> getSelectedOperationalLimitsGroupId1() {
        return this.danglingLine1.getSelectedOperationalLimitsGroupId();
    }

    public Collection<OperationalLimitsGroup> getOperationalLimitsGroups1() {
        return this.danglingLine1.getOperationalLimitsGroups();
    }

    public Optional<OperationalLimitsGroup> getOperationalLimitsGroup1(String id) {
        return this.danglingLine1.getOperationalLimitsGroup(id);
    }

    public Optional<OperationalLimitsGroup> getSelectedOperationalLimitsGroup1() {
        return this.danglingLine1.getSelectedOperationalLimitsGroup();
    }

    public OperationalLimitsGroup newOperationalLimitsGroup1(String id) {
        return this.danglingLine1.newOperationalLimitsGroup(id);
    }

    public void setSelectedOperationalLimitsGroup1(String id) {
        this.danglingLine1.setSelectedOperationalLimitsGroup(id);
    }

    public void removeOperationalLimitsGroup1(String id) {
        this.danglingLine1.removeOperationalLimitsGroup(id);
    }

    public void cancelSelectedOperationalLimitsGroup1() {
        this.danglingLine1.cancelSelectedOperationalLimitsGroup();
    }

    public OperationalLimitsGroup getOrCreateSelectedOperationalLimitsGroup1() {
        return this.danglingLine1.getOrCreateSelectedOperationalLimitsGroup();
    }

    public OperationalLimitsGroup getOrCreateSelectedOperationalLimitsGroup2() {
        return this.danglingLine2.getOrCreateSelectedOperationalLimitsGroup();
    }

    @Deprecated(since="6.8.0")
    public CurrentLimitsAdder newCurrentLimits1() {
        return this.danglingLine1.getOrCreateSelectedOperationalLimitsGroup().newCurrentLimits();
    }

    @Deprecated(since="6.8.0")
    public ActivePowerLimitsAdder newActivePowerLimits1() {
        return this.danglingLine1.getOrCreateSelectedOperationalLimitsGroup().newActivePowerLimits();
    }

    @Deprecated(since="6.8.0")
    public ApparentPowerLimitsAdder newApparentPowerLimits1() {
        return this.danglingLine1.getOrCreateSelectedOperationalLimitsGroup().newApparentPowerLimits();
    }

    public Collection<OperationalLimitsGroup> getOperationalLimitsGroups2() {
        return this.danglingLine2.getOperationalLimitsGroups();
    }

    public Optional<String> getSelectedOperationalLimitsGroupId2() {
        return this.danglingLine2.getSelectedOperationalLimitsGroupId();
    }

    public Optional<OperationalLimitsGroup> getOperationalLimitsGroup2(String id) {
        return this.danglingLine2.getOperationalLimitsGroup(id);
    }

    public Optional<OperationalLimitsGroup> getSelectedOperationalLimitsGroup2() {
        return this.danglingLine2.getSelectedOperationalLimitsGroup();
    }

    public OperationalLimitsGroup newOperationalLimitsGroup2(String id) {
        return this.danglingLine2.newOperationalLimitsGroup(id);
    }

    public void setSelectedOperationalLimitsGroup2(String id) {
        this.danglingLine2.setSelectedOperationalLimitsGroup(id);
    }

    public void removeOperationalLimitsGroup2(String id) {
        this.danglingLine2.removeOperationalLimitsGroup(id);
    }

    public void cancelSelectedOperationalLimitsGroup2() {
        this.danglingLine2.cancelSelectedOperationalLimitsGroup();
    }

    @Deprecated(since="6.8.0")
    public CurrentLimitsAdder newCurrentLimits2() {
        return this.danglingLine2.getOrCreateSelectedOperationalLimitsGroup().newCurrentLimits();
    }

    @Deprecated(since="6.8.0")
    public ActivePowerLimitsAdder newActivePowerLimits2() {
        return this.danglingLine2.getOrCreateSelectedOperationalLimitsGroup().newActivePowerLimits();
    }

    @Deprecated(since="6.8.0")
    public ApparentPowerLimitsAdder newApparentPowerLimits2() {
        return this.danglingLine2.getOrCreateSelectedOperationalLimitsGroup().newApparentPowerLimits();
    }

    public Optional<CurrentLimits> getCurrentLimits(TwoSides side) {
        return BranchUtil.getFromSide(side, () -> ((TieLineImpl)this).getCurrentLimits1(), () -> ((TieLineImpl)this).getCurrentLimits2());
    }

    public Optional<ActivePowerLimits> getActivePowerLimits(TwoSides side) {
        return BranchUtil.getFromSide(side, () -> ((TieLineImpl)this).getActivePowerLimits1(), () -> ((TieLineImpl)this).getActivePowerLimits2());
    }

    public Optional<ApparentPowerLimits> getApparentPowerLimits(TwoSides side) {
        return BranchUtil.getFromSide(side, () -> ((TieLineImpl)this).getApparentPowerLimits1(), () -> ((TieLineImpl)this).getApparentPowerLimits2());
    }

    public boolean isOverloaded() {
        return this.isOverloaded(1.0);
    }

    public boolean isOverloaded(double limitReductionValue) {
        return this.checkPermanentLimit1(limitReductionValue, LimitType.CURRENT) || this.checkPermanentLimit2(limitReductionValue, LimitType.CURRENT);
    }

    public int getOverloadDuration() {
        return BranchUtil.getOverloadDuration(this.checkTemporaryLimits1(LimitType.CURRENT), this.checkTemporaryLimits2(LimitType.CURRENT));
    }

    public boolean checkPermanentLimit(TwoSides side, double limitReductionValue, LimitType type) {
        return BranchUtil.getFromSide(side, () -> this.checkPermanentLimit1(limitReductionValue, type), () -> this.checkPermanentLimit2(limitReductionValue, type));
    }

    public boolean checkPermanentLimit(TwoSides side, LimitType type) {
        return this.checkPermanentLimit(side, 1.0, type);
    }

    public boolean checkPermanentLimit1(double limitReductionValue, LimitType type) {
        return LimitViolationUtils.checkPermanentLimit((Branch)this, (TwoSides)TwoSides.ONE, (double)limitReductionValue, (double)this.getValueForLimit(this.getTerminal1(), type), (LimitType)type);
    }

    public boolean checkPermanentLimit1(LimitType type) {
        return this.checkPermanentLimit1(1.0, type);
    }

    public boolean checkPermanentLimit2(double limitReductionValue, LimitType type) {
        return LimitViolationUtils.checkPermanentLimit((Branch)this, (TwoSides)TwoSides.TWO, (double)limitReductionValue, (double)this.getValueForLimit(this.getTerminal2(), type), (LimitType)type);
    }

    public boolean checkPermanentLimit2(LimitType type) {
        return this.checkPermanentLimit2(1.0, type);
    }

    public Overload checkTemporaryLimits(TwoSides side, double limitReductionValue, LimitType type) {
        return BranchUtil.getFromSide(side, () -> this.checkTemporaryLimits1(limitReductionValue, type), () -> this.checkTemporaryLimits2(limitReductionValue, type));
    }

    public Overload checkTemporaryLimits(TwoSides side, LimitType type) {
        return this.checkTemporaryLimits(side, 1.0, type);
    }

    public Overload checkTemporaryLimits1(double limitReductionValue, LimitType type) {
        return LimitViolationUtils.checkTemporaryLimits((Branch)this, (TwoSides)TwoSides.ONE, (double)limitReductionValue, (double)this.getValueForLimit(this.getTerminal1(), type), (LimitType)type);
    }

    public Overload checkTemporaryLimits1(LimitType type) {
        return this.checkTemporaryLimits1(1.0, type);
    }

    public Overload checkTemporaryLimits2(double limitReductionValue, LimitType type) {
        return LimitViolationUtils.checkTemporaryLimits((Branch)this, (TwoSides)TwoSides.TWO, (double)limitReductionValue, (double)this.getValueForLimit(this.getTerminal2(), type), (LimitType)type);
    }

    public Overload checkTemporaryLimits2(LimitType type) {
        return this.checkTemporaryLimits2(1.0, type);
    }

    public double getValueForLimit(Terminal t, LimitType type) {
        return BranchUtil.getValueForLimit(t, type);
    }

    private static void updateDanglingLine(DanglingLine danglingLine) {
        if (!Double.isNaN(danglingLine.getBoundary().getP())) {
            danglingLine.setP0(-danglingLine.getBoundary().getP());
            if (danglingLine.getGeneration() != null) {
                danglingLine.getGeneration().setTargetP(0.0);
            }
        }
        if (!Double.isNaN(danglingLine.getBoundary().getQ())) {
            danglingLine.setQ0(-danglingLine.getBoundary().getQ());
            if (danglingLine.getGeneration() != null) {
                danglingLine.getGeneration().setTargetQ(0.0).setVoltageRegulationOn(false).setTargetV(Double.NaN);
            }
        }
    }
}

