/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.ref.Ref;
import com.powsybl.iidm.network.Area;
import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.BatteryAdder;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.ContainerType;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DanglingLineAdder;
import com.powsybl.iidm.network.DanglingLineFilter;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.Ground;
import com.powsybl.iidm.network.GroundAdder;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.iidm.network.LccConverterStationAdder;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.LineCommutatedConverter;
import com.powsybl.iidm.network.LineCommutatedConverterAdder;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.LoadAdder;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.ShuntCompensatorAdder;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.TopologyVisitor;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageSourceConverter;
import com.powsybl.iidm.network.VoltageSourceConverterAdder;
import com.powsybl.iidm.network.VscConverterStation;
import com.powsybl.iidm.network.VscConverterStationAdder;
import com.powsybl.iidm.network.impl.AbstractBus;
import com.powsybl.iidm.network.impl.AbstractConnectable;
import com.powsybl.iidm.network.impl.AbstractIdentifiable;
import com.powsybl.iidm.network.impl.AbstractTopologyModel;
import com.powsybl.iidm.network.impl.BatteryAdderImpl;
import com.powsybl.iidm.network.impl.BusBreakerTopologyModel;
import com.powsybl.iidm.network.impl.ConfiguredBusImpl;
import com.powsybl.iidm.network.impl.DanglingLineAdderImpl;
import com.powsybl.iidm.network.impl.GeneratorAdderImpl;
import com.powsybl.iidm.network.impl.GroundAdderImpl;
import com.powsybl.iidm.network.impl.LccConverterStationAdderImpl;
import com.powsybl.iidm.network.impl.LineCommutatedConverterAdderImpl;
import com.powsybl.iidm.network.impl.LoadAdderImpl;
import com.powsybl.iidm.network.impl.NetworkExt;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.NodeBreakerTopologyModel;
import com.powsybl.iidm.network.impl.ShuntCompensatorAdderImpl;
import com.powsybl.iidm.network.impl.StaticVarCompensatorAdderImpl;
import com.powsybl.iidm.network.impl.SubnetworkImpl;
import com.powsybl.iidm.network.impl.SubstationImpl;
import com.powsybl.iidm.network.impl.SwitchImpl;
import com.powsybl.iidm.network.impl.TerminalBuilder;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.VoltageLevelExt;
import com.powsybl.iidm.network.impl.VoltageLevels;
import com.powsybl.iidm.network.impl.VoltageSourceConverterAdderImpl;
import com.powsybl.iidm.network.impl.VscConverterStationAdderImpl;
import com.powsybl.iidm.network.util.ShortIdDictionary;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class VoltageLevelImpl
extends AbstractIdentifiable<VoltageLevel>
implements VoltageLevelExt {
    private final Ref<NetworkImpl> networkRef;
    private final Ref<SubnetworkImpl> subnetworkRef;
    private final SubstationImpl substation;
    private double nominalV;
    private double lowVoltageLimit;
    private double highVoltageLimit;
    private AbstractTopologyModel topologyModel;
    private final Set<Area> areas = new LinkedHashSet<Area>();
    private boolean removed = false;

    VoltageLevelImpl(String id, String name, boolean fictitious, SubstationImpl substation, Ref<NetworkImpl> networkRef, Ref<SubnetworkImpl> subnetworkRef, double nominalV, double lowVoltageLimit, double highVoltageLimit, TopologyKind topologyKind) {
        super(id, name, fictitious);
        this.substation = substation;
        this.networkRef = networkRef;
        this.subnetworkRef = subnetworkRef;
        this.nominalV = nominalV;
        this.lowVoltageLimit = lowVoltageLimit;
        this.highVoltageLimit = highVoltageLimit;
        this.topologyModel = switch (Objects.requireNonNull(topologyKind)) {
            default -> throw new MatchException(null, null);
            case TopologyKind.NODE_BREAKER -> new NodeBreakerTopologyModel(this);
            case TopologyKind.BUS_BREAKER -> new BusBreakerTopologyModel(this);
        };
    }

    @Override
    public AbstractTopologyModel getTopologyModel() {
        return this.topologyModel;
    }

    @Override
    public String getSubnetworkId() {
        return Optional.ofNullable((SubnetworkImpl)this.subnetworkRef.get()).map(Identifiable::getId).orElse(null);
    }

    @Override
    public Ref<NetworkImpl> getNetworkRef() {
        return this.networkRef;
    }

    public ContainerType getContainerType() {
        return ContainerType.VOLTAGE_LEVEL;
    }

    public Optional<Substation> getSubstation() {
        if (this.removed) {
            throw new PowsyblException("Cannot access substation of removed voltage level " + this.id);
        }
        return Optional.ofNullable(this.substation);
    }

    public Iterable<Area> getAreas() {
        if (this.removed) {
            this.throwAreasRemovedVoltageLevel();
        }
        return this.areas;
    }

    public Stream<Area> getAreasStream() {
        if (this.removed) {
            this.throwAreasRemovedVoltageLevel();
        }
        return this.areas.stream();
    }

    public Optional<Area> getArea(String areaType) {
        Objects.requireNonNull(areaType);
        if (this.removed) {
            this.throwAreasRemovedVoltageLevel();
        }
        return this.areas.stream().filter(area -> Objects.equals(area.getAreaType(), areaType)).findFirst();
    }

    private void throwAreasRemovedVoltageLevel() {
        throw new PowsyblException("Cannot access areas of removed voltage level " + this.id);
    }

    public void addArea(Area area) {
        Objects.requireNonNull(area);
        if (this.removed) {
            throw new PowsyblException("Cannot add areas to removed voltage level " + this.id);
        }
        if (this.areas.contains(area)) {
            return;
        }
        if (area.getParentNetwork() != this.getParentNetwork()) {
            throw new PowsyblException("VoltageLevel " + this.getId() + " cannot be added to Area " + area.getId() + ". It does not belong to the same network or subnetwork.");
        }
        Optional<Area> previousArea = this.getArea(area.getAreaType());
        if (previousArea.isPresent() && previousArea.get() != area) {
            throw new PowsyblException("VoltageLevel " + this.getId() + " is already in Area of the same type=" + previousArea.get().getAreaType() + " with id=" + previousArea.get().getId());
        }
        this.areas.add(area);
        area.addVoltageLevel((VoltageLevel)this);
    }

    public void removeArea(Area area) {
        Objects.requireNonNull(area);
        if (this.removed) {
            throw new PowsyblException("Cannot remove areas from removed voltage level " + this.id);
        }
        this.areas.remove(area);
        area.removeVoltageLevel((VoltageLevel)this);
    }

    public Substation getNullableSubstation() {
        return this.substation;
    }

    @Override
    public VoltageLevelExt.NodeBreakerViewExt getNodeBreakerView() {
        return this.topologyModel.getNodeBreakerView();
    }

    @Override
    public VoltageLevelExt.BusBreakerViewExt getBusBreakerView() {
        return this.topologyModel.getBusBreakerView();
    }

    @Override
    public VoltageLevelExt.BusViewExt getBusView() {
        return this.topologyModel.getBusView();
    }

    @Override
    public NetworkImpl getNetwork() {
        if (this.removed) {
            throw new PowsyblException("Cannot access network of removed voltage level " + this.id);
        }
        return Optional.ofNullable(this.networkRef).map(Ref::get).orElseGet(() -> Optional.ofNullable(this.substation).map(SubstationImpl::getNetwork).orElseThrow(() -> new PowsyblException(String.format("Voltage level %s has no container", this.id))));
    }

    @Override
    public NetworkExt getParentNetwork() {
        SubnetworkImpl subnetwork = (SubnetworkImpl)this.subnetworkRef.get();
        return subnetwork != null ? subnetwork : this.getNetwork();
    }

    private void notifyUpdate(String attribute, Object oldValue, Object newValue) {
        this.getNetwork().getListeners().notifyUpdate(this, attribute, oldValue, newValue);
    }

    public double getNominalV() {
        return this.nominalV;
    }

    public VoltageLevelExt setNominalV(double nominalV) {
        ValidationUtil.checkNominalV((Validable)this, (double)nominalV);
        double oldValue = this.nominalV;
        this.nominalV = nominalV;
        this.notifyUpdate("nominalV", oldValue, nominalV);
        return this;
    }

    public double getLowVoltageLimit() {
        return this.lowVoltageLimit;
    }

    public VoltageLevel setLowVoltageLimit(double lowVoltageLimit) {
        ValidationUtil.checkVoltageLimits((Validable)this, (double)lowVoltageLimit, (double)this.highVoltageLimit);
        double oldValue = this.lowVoltageLimit;
        this.lowVoltageLimit = lowVoltageLimit;
        this.notifyUpdate("lowVoltageLimit", oldValue, lowVoltageLimit);
        return this;
    }

    public double getHighVoltageLimit() {
        return this.highVoltageLimit;
    }

    public VoltageLevel setHighVoltageLimit(double highVoltageLimit) {
        ValidationUtil.checkVoltageLimits((Validable)this, (double)this.lowVoltageLimit, (double)highVoltageLimit);
        double oldValue = this.highVoltageLimit;
        this.highVoltageLimit = highVoltageLimit;
        this.notifyUpdate("highVoltageLimit", oldValue, highVoltageLimit);
        return this;
    }

    public <T extends Connectable> T getConnectable(String id, Class<T> aClass) {
        Connectable connectable = (Connectable)this.getNetwork().getIndex().get(id, aClass);
        if (connectable == null) {
            return null;
        }
        if (connectable instanceof Injection) {
            Injection injection = (Injection)connectable;
            return (T)(injection.getTerminal().getVoltageLevel() == this ? connectable : null);
        }
        if (connectable instanceof Branch) {
            Branch branch = (Branch)connectable;
            return (T)(branch.getTerminal1().getVoltageLevel() == this || branch.getTerminal2().getVoltageLevel() == this ? connectable : null);
        }
        if (connectable instanceof ThreeWindingsTransformer) {
            ThreeWindingsTransformer twt = (ThreeWindingsTransformer)connectable;
            return (T)(twt.getLeg1().getTerminal().getVoltageLevel() == this || twt.getLeg2().getTerminal().getVoltageLevel() == this || twt.getLeg3().getTerminal().getVoltageLevel() == this ? connectable : null);
        }
        throw new IllegalStateException();
    }

    public <T extends Connectable> Iterable<T> getConnectables(Class<T> clazz) {
        return this.topologyModel.getConnectables(clazz);
    }

    public <T extends Connectable> Stream<T> getConnectableStream(Class<T> clazz) {
        return this.topologyModel.getConnectableStream(clazz);
    }

    public <T extends Connectable> int getConnectableCount(Class<T> clazz) {
        return this.topologyModel.getConnectableCount(clazz);
    }

    public Iterable<Connectable> getConnectables() {
        return this.topologyModel.getConnectables();
    }

    public Stream<Connectable> getConnectableStream() {
        return this.topologyModel.getConnectableStream();
    }

    public int getConnectableCount() {
        return Ints.checkedCast((long)this.getConnectableStream().count());
    }

    public GeneratorAdder newGenerator() {
        return new GeneratorAdderImpl(this);
    }

    public Iterable<Generator> getGenerators() {
        return this.getConnectables(Generator.class);
    }

    public Stream<Generator> getGeneratorStream() {
        return this.getConnectableStream(Generator.class);
    }

    public int getGeneratorCount() {
        return this.getConnectableCount(Generator.class);
    }

    public BatteryAdder newBattery() {
        return new BatteryAdderImpl(this);
    }

    public Iterable<Battery> getBatteries() {
        return this.getConnectables(Battery.class);
    }

    public Stream<Battery> getBatteryStream() {
        return this.getConnectableStream(Battery.class);
    }

    public int getBatteryCount() {
        return this.getConnectableCount(Battery.class);
    }

    public LoadAdder newLoad() {
        return new LoadAdderImpl(this);
    }

    public Iterable<Load> getLoads() {
        return this.getConnectables(Load.class);
    }

    public Stream<Load> getLoadStream() {
        return this.getConnectableStream(Load.class);
    }

    public Iterable<Switch> getSwitches() {
        return this.topologyModel.getSwitches();
    }

    public int getSwitchCount() {
        return this.topologyModel.getSwitchCount();
    }

    public int getLoadCount() {
        return this.getConnectableCount(Load.class);
    }

    public ShuntCompensatorAdder newShuntCompensator() {
        return new ShuntCompensatorAdderImpl(this);
    }

    public int getShuntCompensatorCount() {
        return this.getConnectableCount(ShuntCompensator.class);
    }

    public Iterable<ShuntCompensator> getShuntCompensators() {
        return this.getConnectables(ShuntCompensator.class);
    }

    public Stream<ShuntCompensator> getShuntCompensatorStream() {
        return this.getConnectableStream(ShuntCompensator.class);
    }

    public DanglingLineAdder newDanglingLine() {
        return new DanglingLineAdderImpl(this);
    }

    public Iterable<DanglingLine> getDanglingLines(DanglingLineFilter danglingLineFilter) {
        return this.getDanglingLineStream(danglingLineFilter).collect(Collectors.toList());
    }

    public Stream<DanglingLine> getDanglingLineStream(DanglingLineFilter danglingLineFilter) {
        return this.getConnectableStream(DanglingLine.class).filter(danglingLineFilter.getPredicate());
    }

    public int getDanglingLineCount() {
        return this.getConnectableCount(DanglingLine.class);
    }

    public StaticVarCompensatorAdderImpl newStaticVarCompensator() {
        return new StaticVarCompensatorAdderImpl(this);
    }

    public Iterable<StaticVarCompensator> getStaticVarCompensators() {
        return this.getConnectables(StaticVarCompensator.class);
    }

    public Stream<StaticVarCompensator> getStaticVarCompensatorStream() {
        return this.getConnectableStream(StaticVarCompensator.class);
    }

    public int getStaticVarCompensatorCount() {
        return this.getConnectableCount(StaticVarCompensator.class);
    }

    public int getVscConverterStationCount() {
        return this.getConnectableCount(VscConverterStation.class);
    }

    public Iterable<VscConverterStation> getVscConverterStations() {
        return this.getConnectables(VscConverterStation.class);
    }

    public Stream<VscConverterStation> getVscConverterStationStream() {
        return this.getConnectableStream(VscConverterStation.class);
    }

    public VscConverterStationAdder newVscConverterStation() {
        return new VscConverterStationAdderImpl(this);
    }

    public int getLccConverterStationCount() {
        return this.getConnectableCount(LccConverterStation.class);
    }

    public Iterable<LccConverterStation> getLccConverterStations() {
        return this.getConnectables(LccConverterStation.class);
    }

    public Stream<LccConverterStation> getLccConverterStationStream() {
        return this.getConnectableStream(LccConverterStation.class);
    }

    public LccConverterStationAdder newLccConverterStation() {
        return new LccConverterStationAdderImpl(this);
    }

    public int getLineCount() {
        return this.getConnectableCount(Line.class);
    }

    public Iterable<Line> getLines() {
        return this.getConnectables(Line.class);
    }

    public Stream<Line> getLineStream() {
        return this.getConnectableStream(Line.class);
    }

    public int getTwoWindingsTransformerCount() {
        return this.getConnectableCount(TwoWindingsTransformer.class);
    }

    public Iterable<TwoWindingsTransformer> getTwoWindingsTransformers() {
        return this.getConnectables(TwoWindingsTransformer.class);
    }

    public Stream<TwoWindingsTransformer> getTwoWindingsTransformerStream() {
        return this.getConnectableStream(TwoWindingsTransformer.class);
    }

    public int getThreeWindingsTransformerCount() {
        return this.getConnectableCount(ThreeWindingsTransformer.class);
    }

    public Iterable<ThreeWindingsTransformer> getThreeWindingsTransformers() {
        return this.getConnectables(ThreeWindingsTransformer.class);
    }

    public Stream<ThreeWindingsTransformer> getThreeWindingsTransformerStream() {
        return this.getConnectableStream(ThreeWindingsTransformer.class);
    }

    public GroundAdder newGround() {
        return new GroundAdderImpl(this);
    }

    public Iterable<Ground> getGrounds() {
        return this.getConnectables(Ground.class);
    }

    public Stream<Ground> getGroundStream() {
        return this.getConnectableStream(Ground.class);
    }

    public int getGroundCount() {
        return this.getConnectableCount(Ground.class);
    }

    public LineCommutatedConverterAdder newLineCommutatedConverter() {
        return new LineCommutatedConverterAdderImpl(this);
    }

    public Iterable<LineCommutatedConverter> getLineCommutatedConverters() {
        return this.getConnectables(LineCommutatedConverter.class);
    }

    public Stream<LineCommutatedConverter> getLineCommutatedConverterStream() {
        return this.getConnectableStream(LineCommutatedConverter.class);
    }

    public int getLineCommutatedConverterCount() {
        return this.getConnectableCount(LineCommutatedConverter.class);
    }

    public VoltageSourceConverterAdder newVoltageSourceConverter() {
        return new VoltageSourceConverterAdderImpl(this);
    }

    public Iterable<VoltageSourceConverter> getVoltageSourceConverters() {
        return this.getConnectables(VoltageSourceConverter.class);
    }

    public Stream<VoltageSourceConverter> getVoltageSourceConverterStream() {
        return this.getConnectableStream(VoltageSourceConverter.class);
    }

    public int getVoltageSourceConverterCount() {
        return this.getConnectableCount(VoltageSourceConverter.class);
    }

    @Override
    protected String getTypeDescription() {
        return "Voltage level";
    }

    public void visitEquipments(TopologyVisitor visitor) {
        AbstractBus.visitEquipments(this.topologyModel.getTerminals(), visitor);
    }

    public TopologyKind getTopologyKind() {
        return this.topologyModel.getTopologyKind();
    }

    public void printTopology() {
        this.topologyModel.printTopology();
    }

    public void printTopology(PrintStream out, ShortIdDictionary dict) {
        this.topologyModel.printTopology(out, dict);
    }

    public void exportTopology(Path file) throws IOException {
        this.topologyModel.exportTopology(file);
    }

    public void exportTopology(Writer writer, Random random) {
        this.topologyModel.exportTopology(writer, random);
    }

    public void exportTopology(Writer writer) {
        this.topologyModel.exportTopology(writer);
    }

    public void remove() {
        VoltageLevels.checkRemovability(this);
        NetworkImpl network = this.getNetwork();
        network.getListeners().notifyBeforeRemoval(this);
        ArrayList connectables = Lists.newArrayList(this.getConnectables());
        for (Connectable connectable : connectables) {
            connectable.remove();
        }
        this.topologyModel.removeTopology();
        this.getAreas().forEach(area -> area.removeVoltageLevel((VoltageLevel)this));
        this.getSubstation().map(SubstationImpl.class::cast).ifPresent(s -> s.remove(this));
        network.getIndex().remove(this);
        network.getListeners().notifyAfterRemoval(this.id);
        this.removed = true;
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        super.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
        this.topologyModel.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
    }

    @Override
    public void reduceVariantArraySize(int number) {
        super.reduceVariantArraySize(number);
        this.topologyModel.reduceVariantArraySize(number);
    }

    @Override
    public void deleteVariantArrayElement(int index) {
        super.deleteVariantArrayElement(index);
        this.topologyModel.deleteVariantArrayElement(index);
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        super.allocateVariantArrayElement(indexes, sourceIndex);
        this.topologyModel.allocateVariantArrayElement(indexes, sourceIndex);
    }

    private void convertToBusBreakerModel() {
        BusBreakerTopologyModel newTopologyModel = new BusBreakerTopologyModel(this);
        for (BusbarSection bbs : this.topologyModel.getNodeBreakerView().getBusbarSections()) {
            bbs.remove();
        }
        for (Bus bus : this.topologyModel.getBusBreakerView().getBuses()) {
            ConfiguredBusImpl configuredBus = new ConfiguredBusImpl(bus.getId(), bus.getOptionalName().orElse(null), bus.isFictitious(), this);
            newTopologyModel.addBus(configuredBus);
        }
        for (Object sw : this.topologyModel.getBusBreakerView().getSwitchStream().toList()) {
            String busId1 = this.topologyModel.getBusBreakerView().getBus1(sw.getId()).getId();
            String busId2 = this.topologyModel.getBusBreakerView().getBus2(sw.getId()).getId();
            ((NodeBreakerTopologyModel)this.topologyModel).removeSwitchFromTopology(sw.getId(), false);
            newTopologyModel.addSwitchToTopology((SwitchImpl)sw, busId1, busId2);
        }
        record TopologyModelInfos(TerminalExt terminal, String connectableBusId, boolean connected) {
        }
        ArrayList<TopologyModelInfos> oldTopologyModelInfos = new ArrayList<TopologyModelInfos>();
        for (Terminal oldTerminal : this.topologyModel.getTerminals()) {
            Bus connectableBus = oldTerminal.getBusBreakerView().getConnectableBus();
            boolean connected = oldTerminal.isConnected();
            oldTopologyModelInfos.add(new TopologyModelInfos((TerminalExt)oldTerminal, connectableBus.getId(), connected));
        }
        for (TopologyModelInfos infos : oldTopologyModelInfos) {
            TerminalExt oldTerminalExt = infos.terminal();
            if (infos.connectableBusId() == null) {
                oldTerminalExt.getConnectable().remove();
                continue;
            }
            AbstractConnectable connectable = oldTerminalExt.getConnectable();
            TerminalExt newTerminalExt = new TerminalBuilder(this.networkRef, this, oldTerminalExt.getSide(), oldTerminalExt.getTerminalNumber()).setBus(infos.connected ? infos.connectableBusId() : null).setConnectableBus(infos.connectableBusId()).build();
            connectable.replaceTerminal(oldTerminalExt, newTopologyModel, newTerminalExt, false);
        }
        this.topologyModel.removeTopology();
        TopologyKind oldTopologyKind = this.topologyModel.getTopologyKind();
        this.topologyModel = newTopologyModel;
        this.notifyUpdate("topologyKind", oldTopologyKind, TopologyKind.BUS_BREAKER);
    }

    public void convertToTopology(TopologyKind newTopologyKind) {
        Objects.requireNonNull(newTopologyKind);
        if (newTopologyKind != this.topologyModel.getTopologyKind()) {
            if (newTopologyKind == TopologyKind.NODE_BREAKER) {
                throw new PowsyblException("Topology model conversion from bus/breaker to node/breaker not yet supported");
            }
            if (newTopologyKind == TopologyKind.BUS_BREAKER) {
                this.convertToBusBreakerModel();
            }
        }
    }
}

