/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.VoltageSourceConverter;
import com.powsybl.iidm.network.VoltageSourceConverterAdder;
import com.powsybl.iidm.network.impl.AbstractAcDcConverterAdder;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.VoltageLevelExt;
import com.powsybl.iidm.network.impl.VoltageSourceConverterImpl;

public class VoltageSourceConverterAdderImpl
extends AbstractAcDcConverterAdder<VoltageSourceConverterAdderImpl>
implements VoltageSourceConverterAdder {
    private Boolean voltageRegulatorOn;
    private double voltageSetpoint = Double.NaN;
    private double reactivePowerSetpoint = Double.NaN;

    VoltageSourceConverterAdderImpl(VoltageLevelExt voltageLevel) {
        super(voltageLevel);
    }

    @Override
    protected String getTypeDescription() {
        return "AC/DC Voltage Source Converter";
    }

    public VoltageSourceConverterAdder setVoltageRegulatorOn(boolean voltageRegulatorOn) {
        this.voltageRegulatorOn = voltageRegulatorOn;
        return this;
    }

    public VoltageSourceConverterAdder setVoltageSetpoint(double voltageSetpoint) {
        this.voltageSetpoint = voltageSetpoint;
        return this;
    }

    public VoltageSourceConverterAdder setReactivePowerSetpoint(double reactivePowerSetpoint) {
        this.reactivePowerSetpoint = reactivePowerSetpoint;
        return this;
    }

    public VoltageSourceConverter add() {
        String id = this.checkAndGetUniqueId();
        super.preCheck();
        NetworkImpl network = this.getNetwork();
        if (network.getMinValidationLevel() == ValidationLevel.EQUIPMENT && this.voltageRegulatorOn == null) {
            this.voltageRegulatorOn = false;
        }
        network.setValidationLevelIfGreaterThan(ValidationUtil.checkVoltageControl((Validable)this, (Boolean)this.voltageRegulatorOn, (double)this.voltageSetpoint, (double)this.reactivePowerSetpoint, (ValidationLevel)network.getMinValidationLevel(), (ReportNode)network.getReportNodeContext().getReportNode()));
        ValidationUtil.checkRegulatingTerminal((Validable)this, (Terminal)this.pccTerminal, (Network)network);
        VoltageSourceConverterImpl dcVsConverter = new VoltageSourceConverterImpl(this.voltageLevel.getNetworkRef(), id, this.getName(), this.isFictitious(), this.idleLoss, this.switchingLoss, this.resistiveLoss, this.pccTerminal, this.controlMode, this.targetP, this.targetVdc, this.voltageRegulatorOn, this.reactivePowerSetpoint, this.voltageSetpoint);
        super.checkAndAdd(dcVsConverter);
        return dcVsConverter;
    }

    @Override
    protected VoltageSourceConverterAdderImpl self() {
        return this;
    }
}

