/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.ref.Ref;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.AcDcConverter;
import com.powsybl.iidm.network.ReactiveLimits;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.VoltageSourceConverter;
import com.powsybl.iidm.network.impl.AbstractAcDcConverter;
import com.powsybl.iidm.network.impl.MinMaxReactiveLimitsAdderImpl;
import com.powsybl.iidm.network.impl.MinMaxReactiveLimitsImpl;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.ReactiveCapabilityCurveAdderImpl;
import com.powsybl.iidm.network.impl.ReactiveLimitsHolderImpl;
import com.powsybl.iidm.network.impl.ReactiveLimitsOwner;
import com.powsybl.iidm.network.impl.RegulatingPoint;
import com.powsybl.iidm.network.impl.TerminalExt;
import gnu.trove.list.array.TDoubleArrayList;

public class VoltageSourceConverterImpl
extends AbstractAcDcConverter<VoltageSourceConverter>
implements VoltageSourceConverter,
ReactiveLimitsOwner {
    public static final String VOLTAGE_REGULATOR_ON_ATTRIBUTE = "voltageRegulatorOn";
    public static final String VOLTAGE_SETPOINT_ATTRIBUTE = "voltageSetpoint";
    public static final String REACTIVE_POWER_SETPOINT_ATTRIBUTE = "reactivePowerSetpoint";
    private final ReactiveLimitsHolderImpl reactiveLimits;
    private final TDoubleArrayList reactivePowerSetpoint;
    private final TDoubleArrayList voltageSetpoint;
    private final RegulatingPoint regulatingPoint;

    VoltageSourceConverterImpl(Ref<NetworkImpl> ref, String id, String name, boolean fictitious, double idleLoss, double switchingLoss, double resistiveLoss, TerminalExt pccTerminal, AcDcConverter.ControlMode controlMode, double targetP, double targetVdc, boolean voltageRegulatorOn, double reactivePowerSetpoint, double voltageSetpoint) {
        super(ref, id, name, fictitious, idleLoss, switchingLoss, resistiveLoss, pccTerminal, controlMode, targetP, targetVdc);
        int variantArraySize = ((NetworkImpl)ref.get()).getVariantManager().getVariantArraySize();
        this.reactivePowerSetpoint = new TDoubleArrayList(variantArraySize);
        this.voltageSetpoint = new TDoubleArrayList(variantArraySize);
        this.reactivePowerSetpoint.fill(0, variantArraySize, reactivePowerSetpoint);
        this.voltageSetpoint.fill(0, variantArraySize, voltageSetpoint);
        this.reactiveLimits = new ReactiveLimitsHolderImpl(this, (ReactiveLimits)new MinMaxReactiveLimitsImpl(-1.7976931348623157E308, Double.MAX_VALUE));
        this.regulatingPoint = new RegulatingPoint(id, () -> null, variantArraySize, voltageRegulatorOn, true);
        this.regulatingPoint.setRegulatingTerminal(pccTerminal);
    }

    @Override
    protected String getTypeDescription() {
        return "AC/DC Voltage Source Converter";
    }

    @Override
    public VoltageSourceConverter setPccTerminal(Terminal pccTerminal) {
        super.setPccTerminal(pccTerminal);
        this.regulatingPoint.setRegulatingTerminal((TerminalExt)pccTerminal);
        return this;
    }

    public boolean isVoltageRegulatorOn() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)VOLTAGE_REGULATOR_ON_ATTRIBUTE);
        return this.regulatingPoint.isRegulating(this.getNetwork().getVariantIndex());
    }

    public VoltageSourceConverterImpl setVoltageRegulatorOn(boolean voltageRegulatorOn) {
        ValidationUtil.checkModifyOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)VOLTAGE_REGULATOR_ON_ATTRIBUTE);
        NetworkImpl n = this.getNetwork();
        int variantIndex = n.getVariantIndex();
        ValidationUtil.checkVoltageControl((Validable)this, (Boolean)voltageRegulatorOn, (double)this.voltageSetpoint.get(variantIndex), (double)this.reactivePowerSetpoint.get(variantIndex), (ValidationLevel)n.getMinValidationLevel(), (ReportNode)n.getReportNodeContext().getReportNode());
        boolean oldValue = this.regulatingPoint.isRegulating(variantIndex);
        this.regulatingPoint.setRegulating(variantIndex, voltageRegulatorOn);
        String variantId = n.getVariantManager().getVariantId(variantIndex);
        n.invalidateValidationLevel();
        this.notifyUpdate(VOLTAGE_REGULATOR_ON_ATTRIBUTE, variantId, (Object)oldValue, (Object)voltageRegulatorOn);
        return this;
    }

    public double getVoltageSetpoint() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)VOLTAGE_SETPOINT_ATTRIBUTE);
        return this.voltageSetpoint.get(this.getNetwork().getVariantIndex());
    }

    public VoltageSourceConverterImpl setVoltageSetpoint(double voltageSetpoint) {
        ValidationUtil.checkModifyOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)VOLTAGE_SETPOINT_ATTRIBUTE);
        NetworkImpl n = this.getNetwork();
        int variantIndex = n.getVariantIndex();
        ValidationUtil.checkVoltageControl((Validable)this, (Boolean)this.regulatingPoint.isRegulating(variantIndex), (double)voltageSetpoint, (double)this.reactivePowerSetpoint.get(variantIndex), (ValidationLevel)n.getMinValidationLevel(), (ReportNode)n.getReportNodeContext().getReportNode());
        double oldValue = this.voltageSetpoint.set(variantIndex, voltageSetpoint);
        String variantId = n.getVariantManager().getVariantId(variantIndex);
        n.invalidateValidationLevel();
        this.notifyUpdate(VOLTAGE_SETPOINT_ATTRIBUTE, variantId, (Object)oldValue, (Object)voltageSetpoint);
        return this;
    }

    public double getReactivePowerSetpoint() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)REACTIVE_POWER_SETPOINT_ATTRIBUTE);
        return this.reactivePowerSetpoint.get(this.getNetwork().getVariantIndex());
    }

    public VoltageSourceConverterImpl setReactivePowerSetpoint(double reactivePowerSetpoint) {
        ValidationUtil.checkModifyOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)REACTIVE_POWER_SETPOINT_ATTRIBUTE);
        NetworkImpl n = this.getNetwork();
        int variantIndex = n.getVariantIndex();
        ValidationUtil.checkVoltageControl((Validable)this, (Boolean)this.regulatingPoint.isRegulating(variantIndex), (double)this.voltageSetpoint.get(variantIndex), (double)reactivePowerSetpoint, (ValidationLevel)n.getMinValidationLevel(), (ReportNode)n.getReportNodeContext().getReportNode());
        double oldValue = this.reactivePowerSetpoint.set(variantIndex, reactivePowerSetpoint);
        String variantId = n.getVariantManager().getVariantId(variantIndex);
        n.invalidateValidationLevel();
        this.notifyUpdate(REACTIVE_POWER_SETPOINT_ATTRIBUTE, variantId, (Object)oldValue, (Object)reactivePowerSetpoint);
        return this;
    }

    public ReactiveCapabilityCurveAdderImpl newReactiveCapabilityCurve() {
        return new ReactiveCapabilityCurveAdderImpl<VoltageSourceConverterImpl>(this);
    }

    public MinMaxReactiveLimitsAdderImpl newMinMaxReactiveLimits() {
        return new MinMaxReactiveLimitsAdderImpl<VoltageSourceConverterImpl>(this);
    }

    @Override
    public void setReactiveLimits(ReactiveLimits reactiveLimits) {
        this.reactiveLimits.setReactiveLimits(reactiveLimits);
    }

    public ReactiveLimits getReactiveLimits() {
        return this.reactiveLimits.getReactiveLimits();
    }

    public <L extends ReactiveLimits> L getReactiveLimits(Class<L> type) {
        return this.reactiveLimits.getReactiveLimits(type);
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        super.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
        this.reactivePowerSetpoint.ensureCapacity(this.reactivePowerSetpoint.size() + number);
        this.reactivePowerSetpoint.fill(initVariantArraySize, initVariantArraySize + number, this.reactivePowerSetpoint.get(sourceIndex));
        this.voltageSetpoint.ensureCapacity(this.voltageSetpoint.size() + number);
        this.voltageSetpoint.fill(initVariantArraySize, initVariantArraySize + number, this.voltageSetpoint.get(sourceIndex));
        this.regulatingPoint.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
    }

    @Override
    public void reduceVariantArraySize(int number) {
        super.reduceVariantArraySize(number);
        this.reactivePowerSetpoint.remove(this.reactivePowerSetpoint.size() - number, number);
        this.voltageSetpoint.remove(this.voltageSetpoint.size() - number, number);
        this.regulatingPoint.reduceVariantArraySize(number);
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        super.allocateVariantArrayElement(indexes, sourceIndex);
        for (int index : indexes) {
            this.reactivePowerSetpoint.set(index, this.reactivePowerSetpoint.get(sourceIndex));
            this.voltageSetpoint.set(index, this.voltageSetpoint.get(sourceIndex));
        }
        this.regulatingPoint.allocateVariantArrayElement(indexes, sourceIndex);
    }

    @Override
    public void remove() {
        this.regulatingPoint.remove();
        super.remove();
    }

    @Override
    protected VoltageSourceConverter self() {
        return this;
    }
}

