/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.commons.extensions.Extension;
import com.powsybl.commons.util.trove.TBooleanArrayList;
import com.powsybl.iidm.network.extensions.ControlUnit;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.VariantManagerHolder;
import com.powsybl.iidm.network.impl.extensions.ControlZoneImpl;
import com.powsybl.iidm.network.impl.extensions.SecondaryVoltageControlImpl;
import java.util.Objects;

class ControlUnitImpl
implements ControlUnit {
    private final String id;
    private final TBooleanArrayList participate;
    private ControlZoneImpl controlZone;

    public ControlUnitImpl(String id, boolean participate, VariantManagerHolder variantManagerHolder) {
        this.id = Objects.requireNonNull(id);
        int variantArraySize = variantManagerHolder.getVariantManager().getVariantArraySize();
        this.participate = new TBooleanArrayList(variantArraySize);
        for (int i = 0; i < variantArraySize; ++i) {
            this.participate.add(participate);
        }
    }

    public void setControlZone(ControlZoneImpl controlZone) {
        this.controlZone = Objects.requireNonNull(controlZone);
    }

    protected int getVariantIndex() {
        return this.controlZone.getSecondaryVoltageControl().getVariantManagerHolder().getVariantIndex();
    }

    public String getId() {
        return this.id;
    }

    public boolean isParticipate() {
        return this.participate.get(this.getVariantIndex());
    }

    public void setParticipate(boolean participate) {
        int variantIndex = this.getVariantIndex();
        boolean oldParticipate = this.participate.get(variantIndex);
        if (participate != oldParticipate) {
            this.participate.set(variantIndex, participate);
            SecondaryVoltageControlImpl secondaryVoltageControl = this.controlZone.getSecondaryVoltageControl();
            NetworkImpl network = (NetworkImpl)secondaryVoltageControl.getExtendable();
            String variantId = network.getVariantManager().getVariantId(variantIndex);
            network.getListeners().notifyExtensionUpdate((Extension<?>)secondaryVoltageControl, "controlUnitParticipate", variantId, new ControlUnit.ParticipateEvent(this.controlZone.getName(), this.id, oldParticipate), new ControlUnit.ParticipateEvent(this.controlZone.getName(), this.id, participate));
        }
    }

    void extendVariantArraySize(int number, int sourceIndex) {
        this.participate.ensureCapacity(this.participate.size() + number);
        for (int i = 0; i < number; ++i) {
            this.participate.add(this.participate.get(sourceIndex));
        }
    }

    void reduceVariantArraySize(int number) {
        this.participate.remove(this.participate.size() - number, number);
    }

    void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        for (int index : indexes) {
            this.participate.set(index, this.participate.get(sourceIndex));
        }
    }
}

