/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.extensions.ControlUnit;
import com.powsybl.iidm.network.extensions.ControlZoneAdder;
import com.powsybl.iidm.network.impl.extensions.ControlUnitAdderImpl;
import com.powsybl.iidm.network.impl.extensions.ControlUnitImpl;
import com.powsybl.iidm.network.impl.extensions.ControlZoneImpl;
import com.powsybl.iidm.network.impl.extensions.PilotPointAdderImpl;
import com.powsybl.iidm.network.impl.extensions.PilotPointImpl;
import com.powsybl.iidm.network.impl.extensions.SecondaryVoltageControlAdderImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ControlZoneAdderImpl
implements ControlZoneAdder {
    private final SecondaryVoltageControlAdderImpl parent;
    private String name;
    private PilotPointImpl pilotPoint;
    private final List<ControlUnit> controlUnits = new ArrayList<ControlUnit>();

    ControlZoneAdderImpl(SecondaryVoltageControlAdderImpl parent) {
        this.parent = Objects.requireNonNull(parent);
    }

    public SecondaryVoltageControlAdderImpl getParent() {
        return this.parent;
    }

    public ControlZoneAdderImpl withName(String name) {
        this.name = Objects.requireNonNull(name);
        return this;
    }

    void setPilotPoint(PilotPointImpl pilotPoint) {
        this.pilotPoint = Objects.requireNonNull(pilotPoint);
    }

    public PilotPointAdderImpl newPilotPoint() {
        return new PilotPointAdderImpl(this);
    }

    void addControlUnit(ControlUnitImpl controlUnit) {
        this.controlUnits.add(Objects.requireNonNull(controlUnit));
    }

    public ControlUnitAdderImpl newControlUnit() {
        return new ControlUnitAdderImpl(this);
    }

    public SecondaryVoltageControlAdderImpl add() {
        if (this.name == null) {
            throw new PowsyblException("Zone name is not set");
        }
        if (this.pilotPoint == null) {
            throw new PowsyblException("Pilot point is not set for zone '" + this.name + "'");
        }
        if (this.controlUnits.isEmpty()) {
            throw new PowsyblException("Empty control unit list for zone '" + this.name + "'");
        }
        ControlZoneImpl controlZone = new ControlZoneImpl(this.name, this.pilotPoint, this.controlUnits);
        this.pilotPoint.setControlZone(controlZone);
        for (ControlUnit controlUnit : this.controlUnits) {
            ((ControlUnitImpl)controlUnit).setControlZone(controlZone);
        }
        this.parent.addControlZone(controlZone);
        return this.parent;
    }
}

