/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.extensions.DiscreteMeasurement;
import com.powsybl.iidm.network.extensions.util.DiscreteMeasurementValidationUtil;
import com.powsybl.iidm.network.impl.extensions.DiscreteMeasurementsImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

class DiscreteMeasurementImpl
implements DiscreteMeasurement {
    private final DiscreteMeasurementsImpl<? extends Identifiable<?>> discreteMeasurements;
    private final String id;
    private final DiscreteMeasurement.Type type;
    private final DiscreteMeasurement.TapChanger tapChanger;
    private final Map<String, String> properties = new HashMap<String, String>();
    private DiscreteMeasurement.ValueType valueType;
    private Object value;
    private boolean valid;

    DiscreteMeasurementImpl(DiscreteMeasurementsImpl<? extends Identifiable<?>> discreteMeasurements, String id, DiscreteMeasurement.Type type, DiscreteMeasurement.TapChanger tapChanger, Map<String, String> properties, DiscreteMeasurement.ValueType valueType, Object value, boolean valid) {
        this.discreteMeasurements = Objects.requireNonNull(discreteMeasurements);
        this.id = id;
        this.type = type;
        this.tapChanger = tapChanger;
        this.properties.putAll(properties);
        this.valueType = Objects.requireNonNull(valueType);
        this.value = value;
        this.valid = valid;
    }

    public String getId() {
        return this.id;
    }

    public DiscreteMeasurement.Type getType() {
        return this.type;
    }

    public DiscreteMeasurement.TapChanger getTapChanger() {
        return this.tapChanger;
    }

    public Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public DiscreteMeasurement putProperty(String name, String property) {
        this.properties.put(Objects.requireNonNull(name), property);
        return this;
    }

    public DiscreteMeasurement removeProperty(String name) {
        this.properties.remove(name);
        return this;
    }

    public DiscreteMeasurement.ValueType getValueType() {
        return this.valueType;
    }

    public String getValueAsString() {
        if (this.valueType == DiscreteMeasurement.ValueType.STRING) {
            return (String)this.value;
        }
        throw new PowsyblException("Value type is not STRING but is: " + this.valueType.name());
    }

    public int getValueAsInt() {
        if (this.valueType == DiscreteMeasurement.ValueType.INT) {
            return (Integer)this.value;
        }
        throw new PowsyblException("Value type is not INT but is: " + this.valueType.name());
    }

    public boolean getValueAsBoolean() {
        if (this.valueType == DiscreteMeasurement.ValueType.BOOLEAN) {
            return (Boolean)this.value;
        }
        throw new PowsyblException("Value type is not BOOLEAN but is: " + this.valueType.name());
    }

    public DiscreteMeasurement setValue(String value) {
        DiscreteMeasurementValidationUtil.checkValue((Object)value, (boolean)this.valid);
        this.valueType = DiscreteMeasurement.ValueType.STRING;
        this.value = value;
        return this;
    }

    public DiscreteMeasurement setValue(int value) {
        this.valueType = DiscreteMeasurement.ValueType.INT;
        this.value = value;
        return this;
    }

    public DiscreteMeasurement setValue(boolean value) {
        this.valueType = DiscreteMeasurement.ValueType.BOOLEAN;
        this.value = value;
        return this;
    }

    public boolean isValid() {
        return this.valid;
    }

    public DiscreteMeasurement setValid(boolean valid) {
        this.valid = valid;
        return this;
    }

    public void remove() {
        this.discreteMeasurements.remove(this);
    }
}

