/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.commons.extensions.Extension;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.extensions.DynamicModelInfo;
import com.powsybl.iidm.network.impl.AbstractMultiVariantIdentifiableExtension;
import com.powsybl.iidm.network.impl.NetworkImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;

public class DynamicModelInfoImpl<I extends Identifiable<I>>
extends AbstractMultiVariantIdentifiableExtension<I>
implements DynamicModelInfo<I> {
    private final ArrayList<String> modelNamePerVariant = new ArrayList<Object>(Collections.nCopies(this.getVariantManagerHolder().getVariantManager().getVariantArraySize(), null));

    public DynamicModelInfoImpl(I extendable, String modelName) {
        super(extendable);
        this.modelNamePerVariant.set(this.getVariantIndex(), modelName);
    }

    public String getModelName() {
        return this.modelNamePerVariant.get(this.getVariantIndex());
    }

    public void setModelName(String modelName) {
        int variantIndex = this.getVariantIndex();
        String oldModelName = this.modelNamePerVariant.get(variantIndex);
        if (!Objects.equals(oldModelName, modelName)) {
            this.modelNamePerVariant.set(variantIndex, modelName);
            NetworkImpl network = (NetworkImpl)((Identifiable)this.getExtendable()).getNetwork();
            String variantId = this.getVariantManagerHolder().getVariantManager().getWorkingVariantId();
            network.getListeners().notifyExtensionUpdate((Extension<?>)this, "modelName", variantId, oldModelName, modelName);
        }
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        this.modelNamePerVariant.ensureCapacity(this.modelNamePerVariant.size() + number);
        for (int i = 0; i < number; ++i) {
            this.modelNamePerVariant.add(this.modelNamePerVariant.get(sourceIndex));
        }
    }

    @Override
    public void reduceVariantArraySize(int number) {
        for (int i = 0; i < number; ++i) {
            this.modelNamePerVariant.remove(this.modelNamePerVariant.size() - 1);
        }
    }

    @Override
    public void deleteVariantArrayElement(int index) {
        this.modelNamePerVariant.set(index, null);
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        String sourceModelName = this.modelNamePerVariant.get(sourceIndex);
        for (int index : indexes) {
            this.modelNamePerVariant.set(index, sourceModelName);
        }
    }
}

