/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.commons.extensions.AbstractExtensionAdder;
import com.powsybl.commons.extensions.Extendable;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.extensions.LoadAsymmetrical;
import com.powsybl.iidm.network.extensions.LoadAsymmetricalAdder;
import com.powsybl.iidm.network.extensions.LoadConnectionType;
import com.powsybl.iidm.network.impl.extensions.LoadAsymmetricalImpl;
import java.util.Objects;

public class LoadAsymmetricalAdderImpl
extends AbstractExtensionAdder<Load, LoadAsymmetrical>
implements LoadAsymmetricalAdder {
    private LoadConnectionType connectionType = LoadConnectionType.Y;
    private double deltaPa = 0.0;
    private double deltaQa = 0.0;
    private double deltaPb = 0.0;
    private double deltaQb = 0.0;
    private double deltaPc = 0.0;
    private double deltaQc = 0.0;

    public LoadAsymmetricalAdderImpl(Load load) {
        super((Extendable)load);
    }

    public Class<? super LoadAsymmetrical> getExtensionClass() {
        return LoadAsymmetrical.class;
    }

    protected LoadAsymmetricalImpl createExtension(Load load) {
        return new LoadAsymmetricalImpl(this.connectionType, load, this.deltaPa, this.deltaQa, this.deltaPb, this.deltaQb, this.deltaPc, this.deltaQc);
    }

    public LoadAsymmetricalAdderImpl withConnectionType(LoadConnectionType connectionType) {
        this.connectionType = Objects.requireNonNull(connectionType);
        return this;
    }

    public LoadAsymmetricalAdderImpl withDeltaPa(double deltaPa) {
        this.deltaPa = deltaPa;
        return this;
    }

    public LoadAsymmetricalAdderImpl withDeltaQa(double deltaQa) {
        this.deltaQa = deltaQa;
        return this;
    }

    public LoadAsymmetricalAdderImpl withDeltaPb(double deltaPb) {
        this.deltaPb = deltaPb;
        return this;
    }

    public LoadAsymmetricalAdderImpl withDeltaQb(double deltaQb) {
        this.deltaQb = deltaQb;
        return this;
    }

    public LoadAsymmetricalAdderImpl withDeltaPc(double deltaPc) {
        this.deltaPc = deltaPc;
        return this;
    }

    public LoadAsymmetricalAdderImpl withDeltaQc(double deltaQc) {
        this.deltaQc = deltaQc;
        return this;
    }
}

