/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.extensions.Measurement;
import com.powsybl.iidm.network.extensions.util.MeasurementValidationUtil;
import com.powsybl.iidm.network.impl.extensions.MeasurementsImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

class MeasurementImpl
implements Measurement {
    private final MeasurementsImpl<? extends Connectable<?>> measurements;
    private final String id;
    private final Measurement.Type type;
    private final Map<String, String> properties = new HashMap<String, String>();
    private final ThreeSides side;
    private double value;
    private double standardDeviation;
    private boolean valid;

    MeasurementImpl(MeasurementsImpl<? extends Connectable<?>> measurements, String id, Measurement.Type type, Map<String, String> properties, double value, double standardDeviation, boolean valid, ThreeSides side) {
        this.measurements = Objects.requireNonNull(measurements);
        this.id = id;
        this.type = type;
        this.properties.putAll(properties);
        this.value = value;
        this.standardDeviation = standardDeviation;
        this.valid = valid;
        this.side = side;
    }

    public String getId() {
        return this.id;
    }

    public Measurement.Type getType() {
        return this.type;
    }

    public Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public Measurement putProperty(String name, String property) {
        this.properties.put(Objects.requireNonNull(name), property);
        return this;
    }

    public Measurement removeProperty(String name) {
        this.properties.remove(name);
        return this;
    }

    public Measurement setValue(double value) {
        MeasurementValidationUtil.checkValue((double)value, (boolean)this.valid);
        this.value = value;
        return this;
    }

    public double getValue() {
        return this.value;
    }

    public Measurement setStandardDeviation(double standardDeviation) {
        this.standardDeviation = standardDeviation;
        return this;
    }

    public double getStandardDeviation() {
        return this.standardDeviation;
    }

    public boolean isValid() {
        return this.valid;
    }

    public Measurement setValid(boolean valid) {
        MeasurementValidationUtil.checkValue((double)this.value, (boolean)valid);
        this.valid = valid;
        return this;
    }

    public Measurement setValueAndValidity(double value, boolean valid) {
        MeasurementValidationUtil.checkValue((double)value, (boolean)valid);
        this.valid = valid;
        this.value = value;
        return this;
    }

    public ThreeSides getSide() {
        return this.side;
    }

    public void remove() {
        this.measurements.remove(this);
    }
}

