/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.iidm.network.extensions.PilotPoint;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.VariantManagerHolder;
import com.powsybl.iidm.network.impl.extensions.ControlZoneImpl;
import com.powsybl.iidm.network.impl.extensions.SecondaryVoltageControlImpl;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

class PilotPointImpl
implements PilotPoint {
    private final List<String> busbarSectionsOrBusesIds;
    private final TDoubleArrayList targetV;
    private ControlZoneImpl controlZone;

    PilotPointImpl(List<String> busbarSectionsOrBusesIds, double targetV, VariantManagerHolder variantManagerHolder) {
        this.busbarSectionsOrBusesIds = Objects.requireNonNull(busbarSectionsOrBusesIds);
        int variantArraySize = variantManagerHolder.getVariantManager().getVariantArraySize();
        this.targetV = new TDoubleArrayList(variantArraySize);
        for (int i = 0; i < variantArraySize; ++i) {
            this.targetV.add(targetV);
        }
    }

    public void setControlZone(ControlZoneImpl controlZone) {
        this.controlZone = Objects.requireNonNull(controlZone);
    }

    protected int getVariantIndex() {
        return this.controlZone.getSecondaryVoltageControl().getVariantManagerHolder().getVariantIndex();
    }

    public List<String> getBusbarSectionsOrBusesIds() {
        return Collections.unmodifiableList(this.busbarSectionsOrBusesIds);
    }

    public double getTargetV() {
        return this.targetV.get(this.getVariantIndex());
    }

    public void setTargetV(double targetV) {
        if (Double.isNaN(targetV)) {
            throw new PowsyblException("Invalid pilot point target voltage for zone '" + this.controlZone.getName() + "'");
        }
        int variantIndex = this.getVariantIndex();
        double oldTargetV = this.targetV.get(variantIndex);
        if (targetV != oldTargetV) {
            this.targetV.set(variantIndex, targetV);
            SecondaryVoltageControlImpl secondaryVoltageControl = this.controlZone.getSecondaryVoltageControl();
            NetworkImpl network = (NetworkImpl)secondaryVoltageControl.getExtendable();
            String variantId = network.getVariantManager().getVariantId(variantIndex);
            network.getListeners().notifyExtensionUpdate((Extension<?>)secondaryVoltageControl, "pilotPointTargetV", variantId, new PilotPoint.TargetVoltageEvent(this.controlZone.getName(), oldTargetV), new PilotPoint.TargetVoltageEvent(this.controlZone.getName(), targetV));
        }
    }

    void extendVariantArraySize(int number, int sourceIndex) {
        this.targetV.ensureCapacity(this.targetV.size() + number);
        for (int i = 0; i < number; ++i) {
            this.targetV.add(this.targetV.get(sourceIndex));
        }
    }

    void reduceVariantArraySize(int number) {
        this.targetV.remove(this.targetV.size() - number, number);
    }

    void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        for (int index : indexes) {
            this.targetV.set(index, this.targetV.get(sourceIndex));
        }
    }
}

