/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.AbstractExtensionAdder;
import com.powsybl.commons.extensions.Extendable;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.extensions.RemoteReactivePowerControl;
import com.powsybl.iidm.network.extensions.RemoteReactivePowerControlAdder;
import com.powsybl.iidm.network.impl.extensions.RemoteReactivePowerControlImpl;

public class RemoteReactivePowerControlAdderImpl
extends AbstractExtensionAdder<Generator, RemoteReactivePowerControl>
implements RemoteReactivePowerControlAdder {
    private double targetQ = Double.NaN;
    private Terminal regulatingTerminal;
    private boolean enabled = true;

    protected RemoteReactivePowerControlAdderImpl(Generator extendable) {
        super((Extendable)extendable);
    }

    protected RemoteReactivePowerControl createExtension(Generator extendable) {
        if (Double.isNaN(this.targetQ) && this.enabled) {
            throw new PowsyblException("Reactive power target must be set");
        }
        if (this.regulatingTerminal == null) {
            throw new PowsyblException("Regulating terminal must be set");
        }
        return new RemoteReactivePowerControlImpl(extendable, this.targetQ, this.regulatingTerminal, this.enabled);
    }

    public RemoteReactivePowerControlAdder withTargetQ(double targetQ) {
        this.targetQ = targetQ;
        return this;
    }

    public RemoteReactivePowerControlAdder withRegulatingTerminal(Terminal regulatingTerminal) {
        this.regulatingTerminal = regulatingTerminal;
        return this;
    }

    public RemoteReactivePowerControlAdder withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }
}

