/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.util.trove.TBooleanArrayList;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.extensions.RemoteReactivePowerControl;
import com.powsybl.iidm.network.impl.AbstractMultiVariantIdentifiableExtension;
import com.powsybl.iidm.network.impl.TerminalExt;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteReactivePowerControlImpl
extends AbstractMultiVariantIdentifiableExtension<Generator>
implements RemoteReactivePowerControl {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteReactivePowerControlImpl.class);
    private final TDoubleArrayList targetQ;
    private Terminal regulatingTerminal;
    private final TBooleanArrayList enabled;

    public RemoteReactivePowerControlImpl(Generator generator, double targetQ, Terminal regulatingTerminal, boolean enabled) {
        super(generator);
        int variantArraySize = this.getVariantManagerHolder().getVariantManager().getVariantArraySize();
        this.targetQ = new TDoubleArrayList();
        this.regulatingTerminal = Objects.requireNonNull(regulatingTerminal);
        this.enabled = new TBooleanArrayList(variantArraySize);
        for (int i = 0; i < variantArraySize; ++i) {
            this.targetQ.add(targetQ);
            this.enabled.add(enabled);
        }
        if (regulatingTerminal.getVoltageLevel().getParentNetwork() != ((Generator)this.getExtendable()).getParentNetwork()) {
            throw new PowsyblException("Regulating terminal is not in the right Network (" + regulatingTerminal.getVoltageLevel().getParentNetwork().getId() + " instead of " + ((Generator)this.getExtendable()).getParentNetwork().getId() + ")");
        }
        ((TerminalExt)regulatingTerminal).getReferrerManager().register(this);
    }

    public double getTargetQ() {
        return this.targetQ.get(this.getVariantIndex());
    }

    public RemoteReactivePowerControl setTargetQ(double targetQ) {
        this.targetQ.set(this.getVariantIndex(), targetQ);
        return this;
    }

    public RemoteReactivePowerControl setEnabled(boolean enabled) {
        this.enabled.set(this.getVariantIndex(), enabled);
        return this;
    }

    public Terminal getRegulatingTerminal() {
        return this.regulatingTerminal;
    }

    public RemoteReactivePowerControl setRegulatingTerminal(Terminal regulatingTerminal) {
        Objects.requireNonNull(regulatingTerminal);
        if (this.regulatingTerminal != regulatingTerminal) {
            ((TerminalExt)this.regulatingTerminal).getReferrerManager().unregister(this);
            RemoteReactivePowerControlImpl.checkRegulatingTerminal(regulatingTerminal, ((Generator)this.getExtendable()).getTerminal().getVoltageLevel().getNetwork());
            this.regulatingTerminal = regulatingTerminal;
            ((TerminalExt)regulatingTerminal).getReferrerManager().register(this);
        }
        return this;
    }

    private static void checkRegulatingTerminal(Terminal regulatingTerminal, Network network) {
        if (regulatingTerminal != null && regulatingTerminal.getVoltageLevel().getNetwork() != network) {
            throw new PowsyblException("regulating terminal is not part of the same network");
        }
    }

    public boolean isEnabled() {
        return this.enabled.get(this.getVariantIndex());
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        this.enabled.ensureCapacity(this.enabled.size() + number);
        this.targetQ.ensureCapacity(this.targetQ.size() + number);
        for (int i = 0; i < number; ++i) {
            this.enabled.add(this.enabled.get(sourceIndex));
            this.targetQ.add(this.targetQ.get(sourceIndex));
        }
    }

    @Override
    public void reduceVariantArraySize(int number) {
        this.enabled.remove(this.enabled.size() - number, number);
        this.targetQ.remove(this.targetQ.size() - number, number);
    }

    @Override
    public void deleteVariantArrayElement(int index) {
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        for (int index : indexes) {
            this.targetQ.set(index, this.targetQ.get(sourceIndex));
            this.enabled.set(index, this.enabled.get(sourceIndex));
        }
    }

    @Override
    public void onReferencedRemoval(Terminal removedTerminal) {
        LOGGER.warn("Remove 'RemoteReactivePowerControl' extension of generator '{}', because its regulating terminal has been removed", (Object)((Generator)this.getExtendable()).getId());
        ((Generator)this.getExtendable()).removeExtension(RemoteReactivePowerControl.class);
    }

    @Override
    public void onReferencedReplacement(Terminal oldReferenced, Terminal newReferenced) {
        if (this.regulatingTerminal == oldReferenced) {
            this.setRegulatingTerminal(newReferenced);
        }
    }

    public void cleanup() {
        if (this.regulatingTerminal != null) {
            ((TerminalExt)this.regulatingTerminal).getReferrerManager().unregister(this);
        }
    }
}

