/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.extensions.ControlZone;
import com.powsybl.iidm.network.extensions.SecondaryVoltageControl;
import com.powsybl.iidm.network.impl.AbstractMultiVariantIdentifiableExtension;
import com.powsybl.iidm.network.impl.extensions.ControlZoneImpl;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SecondaryVoltageControlImpl
extends AbstractMultiVariantIdentifiableExtension<Network>
implements SecondaryVoltageControl {
    private final List<ControlZone> controlZones;

    SecondaryVoltageControlImpl(Network network, List<ControlZone> controlZones) {
        super(network);
        this.controlZones = Objects.requireNonNull(controlZones);
    }

    public List<ControlZone> getControlZones() {
        return Collections.unmodifiableList(this.controlZones);
    }

    public Optional<ControlZone> getControlZone(String name) {
        Objects.requireNonNull(name);
        return this.controlZones.stream().filter(z -> z.getName().equals(name)).findFirst();
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        for (ControlZone controlZone : this.controlZones) {
            ((ControlZoneImpl)controlZone).extendVariantArraySize(number, sourceIndex);
        }
    }

    @Override
    public void reduceVariantArraySize(int number) {
        for (ControlZone controlZone : this.controlZones) {
            ((ControlZoneImpl)controlZone).reduceVariantArraySize(number);
        }
    }

    @Override
    public void deleteVariantArrayElement(int index) {
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        for (ControlZone controlZone : this.controlZones) {
            ((ControlZoneImpl)controlZone).allocateVariantArrayElement(indexes, sourceIndex);
        }
    }
}

