/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.AbstractExtensionAdder;
import com.powsybl.commons.extensions.Extendable;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.extensions.SlackTerminal;
import com.powsybl.iidm.network.extensions.SlackTerminalAdder;
import com.powsybl.iidm.network.impl.extensions.SlackTerminalImpl;

public class SlackTerminalAdderImpl
extends AbstractExtensionAdder<VoltageLevel, SlackTerminal>
implements SlackTerminalAdder {
    private Terminal terminal;

    public SlackTerminalAdderImpl(VoltageLevel voltageLevel) {
        super((Extendable)voltageLevel);
    }

    public SlackTerminalAdder withTerminal(Terminal terminal) {
        this.terminal = terminal;
        return this;
    }

    public SlackTerminal createExtension(VoltageLevel voltageLevel) {
        if (this.terminal == null) {
            throw new PowsyblException("Terminal needs to be set to create a SlackTerminal extension");
        }
        if (!this.terminal.getVoltageLevel().equals((Object)voltageLevel)) {
            throw new PowsyblException("Terminal given is not in the right VoltageLevel (" + this.terminal.getVoltageLevel().getId() + " instead of " + voltageLevel.getId() + ")");
        }
        return new SlackTerminalImpl(voltageLevel, this.terminal);
    }
}

