/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.extensions.SlackTerminal;
import com.powsybl.iidm.network.impl.AbstractMultiVariantIdentifiableExtension;
import com.powsybl.iidm.network.impl.TerminalExt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;

public class SlackTerminalImpl
extends AbstractMultiVariantIdentifiableExtension<VoltageLevel>
implements SlackTerminal {
    private final ArrayList<Terminal> terminals = new ArrayList<Object>(Collections.nCopies(this.getVariantManagerHolder().getVariantManager().getVariantArraySize(), null));

    SlackTerminalImpl(VoltageLevel voltageLevel, Terminal terminal) {
        super(voltageLevel);
        this.setTerminal(terminal);
    }

    private void unregisterReferencedTerminalIfNeeded(int variantIndex) {
        Terminal oldTerminal = this.terminals.get(variantIndex);
        if (oldTerminal != null && Collections.frequency(this.terminals, oldTerminal) == 1) {
            ((TerminalExt)oldTerminal).getReferrerManager().unregister(this);
        }
    }

    private void registerReferencedTerminalIfNeeded(Terminal terminal) {
        if (terminal != null && !this.terminals.contains(terminal)) {
            ((TerminalExt)terminal).getReferrerManager().register(this);
        }
    }

    private void setTerminalAndUpdateReferences(int variantIndex, Terminal terminal) {
        this.unregisterReferencedTerminalIfNeeded(variantIndex);
        this.registerReferencedTerminalIfNeeded(terminal);
        this.terminals.set(variantIndex, terminal);
    }

    private void addTerminalAndUpdateReferences(Terminal terminal) {
        this.registerReferencedTerminalIfNeeded(terminal);
        this.terminals.add(terminal);
    }

    private void removeTerminalAndUpdateReferences(int variantIndex) {
        this.unregisterReferencedTerminalIfNeeded(variantIndex);
        this.terminals.remove(variantIndex);
    }

    public Terminal getTerminal() {
        return this.terminals.get(this.getVariantIndex());
    }

    public SlackTerminal setTerminal(Terminal terminal) {
        if (terminal != null && !terminal.getVoltageLevel().equals(this.getExtendable())) {
            throw new PowsyblException("Terminal given is not in the right VoltageLevel (" + terminal.getVoltageLevel().getId() + " instead of " + ((VoltageLevel)this.getExtendable()).getId() + ")");
        }
        this.setTerminalAndUpdateReferences(this.getVariantIndex(), terminal);
        return this;
    }

    public boolean isEmpty() {
        return this.terminals.stream().noneMatch(Objects::nonNull);
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        this.terminals.ensureCapacity(this.terminals.size() + number);
        Terminal sourceTerminal = this.terminals.get(sourceIndex);
        for (int i = 0; i < number; ++i) {
            this.addTerminalAndUpdateReferences(sourceTerminal);
        }
    }

    @Override
    public void reduceVariantArraySize(int number) {
        for (int i = 0; i < number; ++i) {
            this.removeTerminalAndUpdateReferences(this.terminals.size() - 1);
        }
    }

    @Override
    public void deleteVariantArrayElement(int index) {
        this.setTerminalAndUpdateReferences(index, null);
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        Terminal terminalSource = this.terminals.get(sourceIndex);
        for (int index : indexes) {
            this.setTerminalAndUpdateReferences(index, terminalSource);
        }
    }

    @Override
    public void onReferencedRemoval(Terminal removedTerminal) {
        int variantIndex = this.terminals.indexOf(removedTerminal);
        if (variantIndex != -1) {
            this.terminals.set(variantIndex, null);
        }
    }

    @Override
    public void onReferencedReplacement(Terminal oldReferenced, Terminal newReferenced) {
        this.terminals.replaceAll(t -> t == oldReferenced ? newReferenced : t);
    }

    public void cleanup() {
        for (int i = 0; i < this.terminals.size(); ++i) {
            Terminal terminal = this.terminals.get(i);
            if (terminal == null) continue;
            ((TerminalExt)terminal).getReferrerManager().unregister(this);
            this.terminals.set(i, null);
        }
    }
}

