/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.commons.extensions.AbstractExtension;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.extensions.ThreeWindingsTransformerToBeEstimated;

class ThreeWindingsTransformerToBeEstimatedImpl
extends AbstractExtension<ThreeWindingsTransformer>
implements ThreeWindingsTransformerToBeEstimated {
    private static final String UNEXPECTED_SIDE = "Unexpected side: ";
    private boolean rtc1Status;
    private boolean rtc2Status;
    private boolean rtc3Status;
    private boolean ptc1Status;
    private boolean ptc2Status;
    private boolean ptc3Status;

    ThreeWindingsTransformerToBeEstimatedImpl(boolean rtc1Status, boolean rtc2Status, boolean rtc3Status, boolean ptc1Status, boolean ptc2Status, boolean ptc3Status) {
        this.rtc1Status = rtc1Status;
        this.rtc2Status = rtc2Status;
        this.rtc3Status = rtc3Status;
        this.ptc1Status = ptc1Status;
        this.ptc2Status = ptc2Status;
        this.ptc3Status = ptc3Status;
    }

    public boolean shouldEstimateRatioTapChanger1() {
        return this.rtc1Status;
    }

    public boolean shouldEstimateRatioTapChanger2() {
        return this.rtc2Status;
    }

    public boolean shouldEstimateRatioTapChanger3() {
        return this.rtc3Status;
    }

    public boolean shouldEstimateRatioTapChanger(ThreeSides side) {
        switch (side) {
            case ONE: {
                return this.rtc1Status;
            }
            case TWO: {
                return this.rtc2Status;
            }
            case THREE: {
                return this.rtc3Status;
            }
        }
        throw new IllegalStateException(UNEXPECTED_SIDE + String.valueOf(side));
    }

    public boolean shouldEstimatePhaseTapChanger1() {
        return this.ptc1Status;
    }

    public boolean shouldEstimatePhaseTapChanger2() {
        return this.ptc2Status;
    }

    public boolean shouldEstimatePhaseTapChanger3() {
        return this.ptc3Status;
    }

    public boolean shouldEstimatePhaseTapChanger(ThreeSides side) {
        switch (side) {
            case ONE: {
                return this.ptc1Status;
            }
            case TWO: {
                return this.ptc2Status;
            }
            case THREE: {
                return this.ptc3Status;
            }
        }
        throw new IllegalStateException(UNEXPECTED_SIDE + String.valueOf(side));
    }

    public ThreeWindingsTransformerToBeEstimated shouldEstimateRatioTapChanger1(boolean toBeEstimated) {
        this.rtc1Status = toBeEstimated;
        return this;
    }

    public ThreeWindingsTransformerToBeEstimated shouldEstimateRatioTapChanger2(boolean toBeEstimated) {
        this.rtc2Status = toBeEstimated;
        return this;
    }

    public ThreeWindingsTransformerToBeEstimated shouldEstimateRatioTapChanger3(boolean toBeEstimated) {
        this.rtc3Status = toBeEstimated;
        return this;
    }

    public ThreeWindingsTransformerToBeEstimated shouldEstimateRatioTapChanger(boolean toBeEstimated, ThreeSides side) {
        switch (side) {
            case ONE: {
                this.rtc1Status = toBeEstimated;
                break;
            }
            case TWO: {
                this.rtc2Status = toBeEstimated;
                break;
            }
            case THREE: {
                this.rtc3Status = toBeEstimated;
                break;
            }
            default: {
                throw new IllegalStateException(UNEXPECTED_SIDE + String.valueOf(side));
            }
        }
        return this;
    }

    public ThreeWindingsTransformerToBeEstimated shouldEstimatePhaseTapChanger1(boolean toBeEstimated) {
        this.ptc1Status = toBeEstimated;
        return this;
    }

    public ThreeWindingsTransformerToBeEstimated shouldEstimatePhaseTapChanger2(boolean toBeEstimated) {
        this.ptc2Status = toBeEstimated;
        return this;
    }

    public ThreeWindingsTransformerToBeEstimated shouldEstimatePhaseTapChanger3(boolean toBeEstimated) {
        this.ptc3Status = toBeEstimated;
        return this;
    }

    public ThreeWindingsTransformerToBeEstimated shouldEstimatePhaseTapChanger(boolean toBeEstimated, ThreeSides side) {
        switch (side) {
            case ONE: {
                this.ptc1Status = toBeEstimated;
                break;
            }
            case TWO: {
                this.ptc2Status = toBeEstimated;
                break;
            }
            case THREE: {
                this.ptc3Status = toBeEstimated;
                break;
            }
            default: {
                throw new IllegalStateException(UNEXPECTED_SIDE + String.valueOf(side));
            }
        }
        return this;
    }
}

