/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification;

import com.powsybl.commons.reporter.Reporter;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.Network;
import java.util.Objects;

public class BatteryModification
extends AbstractNetworkModification {
    private final String batteryId;
    private final Double targetQ;
    private final Double targetP;

    public BatteryModification(String batteryId, Double targetP, Double targetQ) {
        this.batteryId = Objects.requireNonNull(batteryId);
        this.targetP = targetP;
        this.targetQ = targetQ;
    }

    @Override
    public void apply(Network network, boolean throwException, ComputationManager computationManager, Reporter reporter) {
        Battery battery = network.getBattery(this.batteryId);
        if (battery == null) {
            this.logOrThrow(throwException, "Battery '" + this.batteryId + "' not found");
            return;
        }
        if (this.targetP != null) {
            battery.setTargetP(this.targetP.doubleValue());
        }
        if (this.targetQ != null) {
            battery.setTargetQ(this.targetQ.doubleValue());
        }
    }

    public String getBatteryId() {
        return this.batteryId;
    }

    public Double getTargetP() {
        return this.targetP;
    }

    public Double getTargetQ() {
        return this.targetQ;
    }
}

