/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification;

import com.powsybl.commons.extensions.Extension;
import com.powsybl.commons.reporter.Reporter;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.topology.TopologyModificationUtils;
import com.powsybl.iidm.modification.util.ModificationReports;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.LineAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.TieLine;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.util.TieLineUtil;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceTieLinesByLines
extends AbstractNetworkModification {
    private static final Logger LOG = LoggerFactory.getLogger(ReplaceTieLinesByLines.class);

    @Override
    public void apply(Network network, boolean throwException, ComputationManager computationManager, Reporter reporter) {
        for (TieLine tl : network.getTieLineStream().toList()) {
            DanglingLine dl1 = tl.getDanglingLine1();
            DanglingLine dl2 = tl.getDanglingLine2();
            String dl1Id = dl1.getId();
            String dl2Id = dl2.getId();
            LineAdder adder = (LineAdder)((LineAdder)((LineAdder)((LineAdder)network.newLine().setId(tl.getId())).setName((String)tl.getOptionalName().orElse(null))).setR(tl.getR()).setX(tl.getX()).setB1(tl.getB1()).setB2(tl.getB2()).setG1(tl.getG1()).setG2(tl.getG2()).setVoltageLevel1(dl1.getTerminal().getVoltageLevel().getId())).setVoltageLevel2(dl2.getTerminal().getVoltageLevel().getId());
            if (dl1.getTerminal().getVoltageLevel().getTopologyKind() == TopologyKind.NODE_BREAKER) {
                adder.setNode1(dl1.getTerminal().getNodeBreakerView().getNode());
            } else {
                ((LineAdder)adder.setConnectableBus1(dl1.getTerminal().getBusBreakerView().getConnectableBus().getId())).setBus1((String)Optional.ofNullable(dl1.getTerminal().getBusBreakerView().getBus()).map(Identifiable::getId).orElse(null));
            }
            if (dl2.getTerminal().getVoltageLevel().getTopologyKind() == TopologyKind.NODE_BREAKER) {
                adder.setNode2(dl2.getTerminal().getNodeBreakerView().getNode());
            } else {
                ((LineAdder)adder.setConnectableBus2(dl2.getTerminal().getBusBreakerView().getConnectableBus().getId())).setBus2((String)Optional.ofNullable(dl2.getTerminal().getBusBreakerView().getBus()).map(Identifiable::getId).orElse(null));
            }
            ReplaceTieLinesByLines.warningAboutExtensions(dl1, dl2, tl, reporter);
            TopologyModificationUtils.LoadingLimitsBags limits1 = new TopologyModificationUtils.LoadingLimitsBags(() -> ((DanglingLine)dl1).getActivePowerLimits(), () -> ((DanglingLine)dl1).getApparentPowerLimits(), () -> ((DanglingLine)dl1).getCurrentLimits());
            TopologyModificationUtils.LoadingLimitsBags limits2 = new TopologyModificationUtils.LoadingLimitsBags(() -> ((DanglingLine)dl2).getActivePowerLimits(), () -> ((DanglingLine)dl2).getApparentPowerLimits(), () -> ((DanglingLine)dl2).getCurrentLimits());
            String pairingKey = tl.getPairingKey();
            double p1 = dl1.getTerminal().getP();
            double q1 = dl1.getTerminal().getQ();
            double p2 = dl2.getTerminal().getP();
            double q2 = dl2.getTerminal().getQ();
            Properties properties = new Properties();
            tl.getPropertyNames().forEach(pn -> properties.put(pn, tl.getProperty(pn)));
            TieLineUtil.mergeProperties((DanglingLine)dl1, (DanglingLine)dl2, (Properties)properties, (Reporter)reporter);
            HashMap<String, String> aliases = new HashMap<String, String>();
            tl.getAliases().forEach(alias -> aliases.put((String)alias, tl.getAliasType(alias).orElse("")));
            TieLineUtil.mergeDifferentAliases((DanglingLine)dl1, (DanglingLine)dl2, aliases, (Reporter)reporter);
            tl.remove();
            dl1.remove();
            dl2.remove();
            Line line = adder.add();
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(pn, pv) -> line.setProperty((String)pn, (String)pv)));
            aliases.forEach((alias, type) -> {
                if (type.isEmpty()) {
                    line.addAlias(alias);
                } else {
                    line.addAlias(alias, type);
                }
            });
            line.getTerminal1().setP(p1).setQ(q1);
            line.getTerminal2().setP(p2).setQ(q2);
            TopologyModificationUtils.addLoadingLimits(line, limits1, Branch.Side.ONE);
            TopologyModificationUtils.addLoadingLimits(line, limits2, Branch.Side.TWO);
            line.addAlias(dl1Id, "danglingLine1Id");
            line.addAlias(dl2Id, "danglingLine2Id");
            if (pairingKey != null) {
                line.addAlias(pairingKey, "pairingKey");
            }
            LOG.info("Removed tie line {} and associated dangling lines {} and {} with pairing key {}. Created line {}", new Object[]{line.getId(), dl1Id, dl2Id, pairingKey, line.getId()});
            ModificationReports.removedTieLineAndAssociatedDanglingLines(reporter, line.getId(), dl1Id, dl2Id, pairingKey);
            ModificationReports.createdLineReport(reporter, line.getId());
        }
    }

    private static void warningAboutExtensions(DanglingLine dl1, DanglingLine dl2, TieLine tl, Reporter reporter) {
        String extensions;
        String dl1Id = dl1.getId();
        String dl2Id = dl2.getId();
        if (!dl1.getExtensions().isEmpty()) {
            extensions = dl1.getExtensions().stream().map(Extension::getName).collect(Collectors.joining(","));
            LOG.warn("Extension [{}] of dangling line {} will be lost", (Object)extensions, (Object)dl1Id);
            ModificationReports.lostDanglingLineExtensions(reporter, extensions, dl1Id);
        }
        if (!dl2.getExtensions().isEmpty()) {
            extensions = dl2.getExtensions().stream().map(Extension::getName).collect(Collectors.joining(","));
            LOG.warn("Extension [{}] of dangling line {} will be lost", (Object)extensions, (Object)dl2Id);
            ModificationReports.lostDanglingLineExtensions(reporter, extensions, dl2Id);
        }
        if (!tl.getExtensions().isEmpty()) {
            extensions = tl.getExtensions().stream().map(Extension::getName).collect(Collectors.joining(","));
            LOG.warn("Extension [{}] of tie line {} will be lost", (Object)extensions, (Object)tl.getId());
            ModificationReports.lostTieLineExtensions(reporter, extensions, tl.getId());
        }
    }
}

