/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.scalable;

import com.powsybl.iidm.modification.scalable.AbstractScalable;
import com.powsybl.iidm.modification.scalable.Scalable;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Network;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

abstract class AbstractCompoundScalable
extends AbstractScalable {
    AbstractCompoundScalable() {
    }

    abstract Collection<Scalable> getScalables();

    @Override
    public double initialValue(Network n) {
        Objects.requireNonNull(n);
        double value = 0.0;
        for (Scalable scalable : this.getScalables()) {
            value += scalable.initialValue(n);
        }
        return value;
    }

    @Override
    public void reset(Network n) {
        Objects.requireNonNull(n);
        this.getScalables().forEach(scalable -> scalable.reset(n));
    }

    @Override
    public double maximumValue(Network n) {
        return this.maximumValue(n, Scalable.ScalingConvention.GENERATOR);
    }

    @Override
    public double maximumValue(Network n, Scalable.ScalingConvention powerConvention) {
        Objects.requireNonNull(n);
        Objects.requireNonNull(powerConvention);
        double value = 0.0;
        for (Scalable scalable : this.getScalables()) {
            value += scalable.maximumValue(n, powerConvention);
        }
        return value;
    }

    @Override
    public double minimumValue(Network n) {
        return this.minimumValue(n, Scalable.ScalingConvention.GENERATOR);
    }

    @Override
    public double minimumValue(Network n, Scalable.ScalingConvention powerConvention) {
        Objects.requireNonNull(n);
        double value = 0.0;
        for (Scalable scalable : this.getScalables()) {
            value += scalable.minimumValue(n, powerConvention);
        }
        return value;
    }

    @Override
    public void filterInjections(Network n, List<Injection> injections, List<String> notFoundInjections) {
        for (Scalable scalable : this.getScalables()) {
            scalable.filterInjections(n, injections, notFoundInjections);
        }
    }
}

