/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.scalable;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.modification.scalable.AbstractCompoundScalable;
import com.powsybl.iidm.modification.scalable.GeneratorScalable;
import com.powsybl.iidm.modification.scalable.Scalable;
import com.powsybl.iidm.modification.scalable.ScalableAdapter;
import com.powsybl.iidm.modification.scalable.ScalingParameters;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.Network;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class ProportionalScalable
extends AbstractCompoundScalable {
    private static final double EPSILON = 0.01;
    private static final String GENERIC_SCALABLE_CLASS_ERROR = "Unable to create a scalable from %s";
    private static final String GENERIC_INCONSISTENCY_ERROR = "Variable %s inconsistent with injection type %s";
    private final List<ScalablePercentage> scalablePercentageList;

    ProportionalScalable(List<Double> percentages, List<Scalable> scalables) {
        ProportionalScalable.checkPercentages(percentages, scalables);
        this.scalablePercentageList = new ArrayList<ScalablePercentage>();
        for (int i = 0; i < scalables.size(); ++i) {
            this.scalablePercentageList.add(new ScalablePercentage(scalables.get(i), percentages.get(i)));
        }
    }

    public ProportionalScalable(List<? extends Injection> injections, DistributionMode distributionMode) {
        double finalTotalDistribution;
        DistributionMode finalDistributionMode;
        List<Scalable> injectionScalables = injections.stream().map(ScalableAdapter::new).collect(Collectors.toList());
        double totalDistribution = this.computeTotalDistribution(injections, distributionMode);
        if (totalDistribution == 0.0 && (distributionMode == DistributionMode.PROPORTIONAL_TO_P0 || distributionMode == DistributionMode.PROPORTIONAL_TO_TARGETP || distributionMode == DistributionMode.PROPORTIONAL_TO_DIFF_PMAX_TARGETP || distributionMode == DistributionMode.PROPORTIONAL_TO_DIFF_TARGETP_PMIN)) {
            finalDistributionMode = DistributionMode.UNIFORM_DISTRIBUTION;
            finalTotalDistribution = this.computeTotalDistribution(injections, finalDistributionMode);
        } else {
            finalDistributionMode = distributionMode;
            finalTotalDistribution = totalDistribution;
        }
        List<Double> percentages = injections.stream().map(injection -> this.getIndividualDistribution((Injection<?>)injection, finalDistributionMode) * 100.0 / finalTotalDistribution).toList();
        ProportionalScalable.checkPercentages(percentages, injectionScalables);
        this.scalablePercentageList = new ArrayList<ScalablePercentage>();
        for (int i = 0; i < injectionScalables.size(); ++i) {
            this.scalablePercentageList.add(new ScalablePercentage(injectionScalables.get(i), percentages.get(i)));
        }
    }

    private double computeTotalDistribution(List<? extends Injection> injections, DistributionMode distributionMode) {
        return injections.stream().mapToDouble(injection -> this.getIndividualDistribution((Injection<?>)injection, distributionMode)).sum();
    }

    private double getIndividualDistribution(Injection<?> injection, DistributionMode distributionMode) {
        this.checkInjectionClass(injection);
        return switch (distributionMode) {
            default -> throw new IncompatibleClassChangeError();
            case DistributionMode.PROPORTIONAL_TO_TARGETP -> this.getTargetP(injection);
            case DistributionMode.PROPORTIONAL_TO_P0 -> this.getP0(injection);
            case DistributionMode.PROPORTIONAL_TO_PMAX -> this.getMaxP(injection);
            case DistributionMode.PROPORTIONAL_TO_DIFF_PMAX_TARGETP -> this.getMaxP(injection) - this.getTargetP(injection);
            case DistributionMode.PROPORTIONAL_TO_DIFF_TARGETP_PMIN -> this.getTargetP(injection) - this.getMinP(injection);
            case DistributionMode.UNIFORM_DISTRIBUTION -> 1.0;
        };
    }

    private void checkInjectionClass(Injection<?> injection) {
        if (!(injection instanceof Generator || injection instanceof Load || injection instanceof DanglingLine)) {
            throw new PowsyblException(String.format(GENERIC_SCALABLE_CLASS_ERROR, injection.getClass()));
        }
    }

    private double getTargetP(Injection<?> injection) {
        if (injection instanceof Generator) {
            Generator generator = (Generator)injection;
            return generator.getTargetP();
        }
        throw new PowsyblException(String.format(GENERIC_INCONSISTENCY_ERROR, "TargetP", injection.getClass()));
    }

    private double getP0(Injection<?> injection) {
        if (injection instanceof Load) {
            Load load = (Load)injection;
            return load.getP0();
        }
        if (injection instanceof DanglingLine) {
            DanglingLine danglingLine = (DanglingLine)injection;
            return danglingLine.getP0();
        }
        throw new PowsyblException(String.format(GENERIC_INCONSISTENCY_ERROR, "P0", injection.getClass()));
    }

    private double getMaxP(Injection<?> injection) {
        if (injection instanceof Generator) {
            Generator generator = (Generator)injection;
            return generator.getMaxP();
        }
        throw new PowsyblException(String.format(GENERIC_INCONSISTENCY_ERROR, "MaxP", injection.getClass()));
    }

    private double getMinP(Injection<?> injection) {
        if (injection instanceof Generator) {
            Generator generator = (Generator)injection;
            return generator.getMinP();
        }
        throw new PowsyblException(String.format(GENERIC_INCONSISTENCY_ERROR, "MinP", injection.getClass()));
    }

    @Override
    Collection<Scalable> getScalables() {
        return this.scalablePercentageList.stream().map(ScalablePercentage::getScalable).toList();
    }

    private static void checkPercentages(List<Double> percentages, List<Scalable> scalables) {
        Objects.requireNonNull(percentages);
        Objects.requireNonNull(scalables);
        if (scalables.size() != percentages.size()) {
            throw new IllegalArgumentException("percentage and scalable list must have the same size");
        }
        if (scalables.isEmpty()) {
            return;
        }
        if (percentages.stream().anyMatch(p -> Double.isNaN(p))) {
            throw new IllegalArgumentException("There is at least one undefined percentage");
        }
        double sum = percentages.stream().mapToDouble(Double::valueOf).sum();
        if (Math.abs(100.0 - sum) > 0.01) {
            throw new IllegalArgumentException(String.format("Sum of percentages must be equals to 100 (%.2f)", sum));
        }
    }

    private boolean notSaturated() {
        return this.scalablePercentageList.stream().anyMatch(ScalablePercentage::notSaturated);
    }

    private void checkIterationPercentages() {
        double iterationPercentagesSum = this.scalablePercentageList.stream().mapToDouble(ScalablePercentage::getIterationPercentage).sum();
        if (Math.abs(100.0 - iterationPercentagesSum) > 0.01) {
            throw new IllegalStateException(String.format("Error in proportional scalable ventilation. Sum of percentages must be equals to 100 (%.2f)", iterationPercentagesSum));
        }
    }

    private void updateIterationPercentages() {
        double unsaturatedPercentagesSum = this.scalablePercentageList.stream().filter(ScalablePercentage::notSaturated).mapToDouble(ScalablePercentage::getIterationPercentage).sum();
        this.scalablePercentageList.forEach(scalablePercentage -> {
            if (!scalablePercentage.isSaturated()) {
                scalablePercentage.setIterationPercentage(scalablePercentage.getIterationPercentage() / unsaturatedPercentagesSum * 100.0);
            }
        });
    }

    private double iterativeScale(Network n, double asked, ScalingParameters parameters) {
        double done = 0.0;
        while (Math.abs(asked - done) > 0.01 && this.notSaturated()) {
            this.checkIterationPercentages();
            done += this.scaleIteration(n, asked - done, parameters);
            this.updateIterationPercentages();
        }
        return done;
    }

    private double scaleIteration(Network n, double asked, ScalingParameters parameters) {
        double done = 0.0;
        for (ScalablePercentage scalablePercentage : this.scalablePercentageList) {
            double iterationPercentage;
            double askedOnScalable;
            Scalable s = scalablePercentage.getScalable();
            double doneOnScalable = s.scale(n, askedOnScalable = (iterationPercentage = scalablePercentage.getIterationPercentage()) / 100.0 * asked, parameters);
            if (Math.abs(doneOnScalable - askedOnScalable) > 0.01) {
                scalablePercentage.setIterationPercentage(0.0);
            }
            done += doneOnScalable;
        }
        return done;
    }

    @Override
    public double scale(Network n, double asked, ScalingParameters parameters) {
        Objects.requireNonNull(n);
        Objects.requireNonNull(parameters);
        double currentGlobalPower = this.getSteadyStatePower(n, asked, parameters.getScalingConvention());
        double variationAsked = Scalable.getVariationAsked(parameters, asked, currentGlobalPower);
        if (parameters.getPriority() == ScalingParameters.Priority.RESPECT_OF_DISTRIBUTION) {
            variationAsked = this.resizeAskedForFixedDistribution(n, variationAsked, parameters);
        }
        this.reinitIterationPercentage();
        if (parameters.getPriority() == ScalingParameters.Priority.RESPECT_OF_VOLUME_ASKED) {
            return this.iterativeScale(n, variationAsked, parameters);
        }
        return this.scaleIteration(n, variationAsked, parameters);
    }

    private void reinitIterationPercentage() {
        this.scalablePercentageList.forEach(scalablePercentage -> scalablePercentage.setIterationPercentage(scalablePercentage.getPercentage()));
    }

    double resizeAskedForFixedDistribution(Network network, double asked, ScalingParameters scalingParameters) {
        AtomicReference<Double> resizingPercentage = new AtomicReference<Double>(1.0);
        this.scalablePercentageList.forEach(scalablePercentage -> {
            Scalable patt12937$temp = scalablePercentage.getScalable();
            if (patt12937$temp instanceof GeneratorScalable) {
                GeneratorScalable generatorScalable = (GeneratorScalable)patt12937$temp;
                resizingPercentage.set(Math.min(generatorScalable.availablePowerInPercentageOfAsked(network, asked, scalablePercentage.getPercentage(), scalingParameters.getScalingConvention()), (Double)resizingPercentage.get()));
            } else {
                Scalable patt13307$temp = scalablePercentage.getScalable();
                if (patt13307$temp instanceof ScalableAdapter) {
                    ScalableAdapter scalableAdapter = (ScalableAdapter)patt13307$temp;
                    resizingPercentage.set(Math.min(scalableAdapter.availablePowerInPercentageOfAsked(network, asked, scalablePercentage.getPercentage(), scalingParameters.getScalingConvention()), (Double)resizingPercentage.get()));
                } else {
                    throw new PowsyblException(String.format("RESPECT_OF_DISTRIBUTION mode can only be used with ScalableAdapter or GeneratorScalable, not %s", scalablePercentage.getScalable().getClass()));
                }
            }
        });
        return asked * resizingPercentage.get();
    }

    @Override
    public double getSteadyStatePower(Network network, double asked, Scalable.ScalingConvention scalingConvention) {
        return this.scalablePercentageList.stream().mapToDouble(scalablePercentage -> scalablePercentage.getScalable().getSteadyStatePower(network, asked, scalingConvention)).sum();
    }

    static final class ScalablePercentage {
        private final Scalable scalable;
        private final double percentage;
        private double iterationPercentage;

        ScalablePercentage(Scalable scalable, double percentage) {
            this.scalable = scalable;
            this.percentage = percentage;
            this.iterationPercentage = percentage;
        }

        Scalable getScalable() {
            return this.scalable;
        }

        double getPercentage() {
            return this.percentage;
        }

        boolean isSaturated() {
            return this.iterationPercentage == 0.0;
        }

        boolean notSaturated() {
            return this.iterationPercentage != 0.0;
        }

        double getIterationPercentage() {
            return this.iterationPercentage;
        }

        void setIterationPercentage(double iterationPercentage) {
            this.iterationPercentage = iterationPercentage;
        }
    }

    public static enum DistributionMode {
        PROPORTIONAL_TO_TARGETP,
        PROPORTIONAL_TO_PMAX,
        PROPORTIONAL_TO_DIFF_PMAX_TARGETP,
        PROPORTIONAL_TO_DIFF_TARGETP_PMIN,
        PROPORTIONAL_TO_P0,
        UNIFORM_DISTRIBUTION;

    }
}

