/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.scalable;

import com.powsybl.iidm.modification.scalable.DanglingLineScalable;
import com.powsybl.iidm.modification.scalable.GeneratorScalable;
import com.powsybl.iidm.modification.scalable.LoadScalable;
import com.powsybl.iidm.modification.scalable.ProportionalScalable;
import com.powsybl.iidm.modification.scalable.ScalableAdapter;
import com.powsybl.iidm.modification.scalable.ScalingParameters;
import com.powsybl.iidm.modification.scalable.StackScalable;
import com.powsybl.iidm.modification.scalable.UpDownScalable;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Network;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public interface Scalable {
    public double initialValue(Network var1);

    public void reset(Network var1);

    public double maximumValue(Network var1);

    public double minimumValue(Network var1);

    public double maximumValue(Network var1, ScalingConvention var2);

    public double minimumValue(Network var1, ScalingConvention var2);

    public void filterInjections(Network var1, List<Injection> var2, List<String> var3);

    public List<Injection> filterInjections(Network var1, List<String> var2);

    public List<Injection> filterInjections(Network var1);

    public double scale(Network var1, double var2, ScalingParameters var4);

    default public double scale(Network n, double asked) {
        return this.scale(n, asked, new ScalingParameters());
    }

    public static GeneratorScalable onGenerator(String id) {
        return new GeneratorScalable(id);
    }

    public static GeneratorScalable onGenerator(String id, double minValue, double maxValue) {
        return new GeneratorScalable(id, minValue, maxValue);
    }

    public static LoadScalable onLoad(String id) {
        return new LoadScalable(id);
    }

    public static LoadScalable onLoad(String id, double minValue, double maxValue) {
        return new LoadScalable(id, minValue, maxValue);
    }

    public static DanglingLineScalable onDanglingLine(String id) {
        return new DanglingLineScalable(id);
    }

    public static DanglingLineScalable onDanglingLine(String id, ScalingConvention scalingConvention) {
        return new DanglingLineScalable(id, scalingConvention);
    }

    public static DanglingLineScalable onDanglingLine(String id, double minValue, double maxValue) {
        return new DanglingLineScalable(id, minValue, maxValue);
    }

    public static DanglingLineScalable onDanglingLine(String id, double minValue, double maxValue, ScalingConvention scalingConvention) {
        return new DanglingLineScalable(id, minValue, maxValue, scalingConvention);
    }

    public static Scalable scalable(String id) {
        return new ScalableAdapter(id);
    }

    public static List<Scalable> scalables(String ... ids) {
        return Arrays.stream(ids).map(ScalableAdapter::new).collect(Collectors.toList());
    }

    public static ProportionalScalable proportional(List<? extends Injection> injections, ProportionalScalable.DistributionMode distributionMode) {
        return new ProportionalScalable(injections, distributionMode);
    }

    public static ProportionalScalable proportional(List<Double> percentages, List<Scalable> scalables) {
        return new ProportionalScalable(percentages, scalables);
    }

    public static ProportionalScalable proportional(double percentage, Scalable scalable) {
        return new ProportionalScalable(Collections.singletonList(percentage), Collections.singletonList(scalable));
    }

    public static ProportionalScalable proportional(double percentage1, Scalable scalable1, double percentage2, Scalable scalable2) {
        return new ProportionalScalable(Arrays.asList(percentage1, percentage2), Arrays.asList(scalable1, scalable2));
    }

    public static ProportionalScalable proportional(double percentage1, Scalable scalable1, double percentage2, Scalable scalable2, double percentage3, Scalable scalable3) {
        return new ProportionalScalable(Arrays.asList(percentage1, percentage2, percentage3), Arrays.asList(scalable1, scalable2, scalable3));
    }

    public static ProportionalScalable proportional(double percentage1, Scalable scalable1, double percentage2, Scalable scalable2, double percentage3, Scalable scalable3, double percentage4, Scalable scalable4) {
        return new ProportionalScalable(Arrays.asList(percentage1, percentage2, percentage3, percentage4), Arrays.asList(scalable1, scalable2, scalable3, scalable4));
    }

    public static ProportionalScalable proportional(double percentage1, Scalable scalable1, double percentage2, Scalable scalable2, double percentage3, Scalable scalable3, double percentage4, Scalable scalable4, double percentage5, Scalable scalable5) {
        return new ProportionalScalable(Arrays.asList(percentage1, percentage2, percentage3, percentage4, percentage5), Arrays.asList(scalable1, scalable2, scalable3, scalable4, scalable5));
    }

    public static StackScalable stack(Injection<?> ... injections) {
        List<Scalable> injectionScalables = Arrays.stream(injections).map(ScalableAdapter::new).collect(Collectors.toList());
        return new StackScalable(injectionScalables);
    }

    public static StackScalable stack(List<? extends Injection<?>> injections) {
        List<Scalable> injectionScalables = injections.stream().map(ScalableAdapter::new).collect(Collectors.toList());
        return new StackScalable(injectionScalables);
    }

    public static StackScalable stack(Scalable ... scalables) {
        return new StackScalable(scalables);
    }

    public static StackScalable stack(String ... ids) {
        List<Scalable> identifierScalables = Arrays.stream(ids).map(ScalableAdapter::new).collect(Collectors.toList());
        return new StackScalable(identifierScalables);
    }

    public static UpDownScalable upDown(Scalable upScalable, Scalable downScalable) {
        return new UpDownScalable(upScalable, downScalable);
    }

    public static double getVariationAsked(ScalingParameters scalingParameters, double askedValue, double currentGlobalPower) {
        return scalingParameters.getScalingType() == ScalingParameters.ScalingType.DELTA_P ? askedValue : askedValue - currentGlobalPower;
    }

    public double getSteadyStatePower(Network var1, double var2, ScalingConvention var4);

    public static enum ScalingConvention {
        GENERATOR,
        LOAD;

    }
}

