/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.scalable;

import com.powsybl.iidm.modification.scalable.AbstractCompoundScalable;
import com.powsybl.iidm.modification.scalable.Scalable;
import com.powsybl.iidm.modification.scalable.ScalingParameters;
import com.powsybl.iidm.network.Network;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

class StackScalable
extends AbstractCompoundScalable {
    private static final double EPSILON = 1.0E-5;
    private final List<Scalable> scalables;

    StackScalable(Scalable ... scalables) {
        this(Arrays.asList(scalables));
    }

    StackScalable(List<Scalable> scalables) {
        this.scalables = Objects.requireNonNull(scalables);
    }

    @Override
    Collection<Scalable> getScalables() {
        return this.scalables;
    }

    @Override
    public double scale(Network n, double asked, ScalingParameters parameters) {
        Objects.requireNonNull(n);
        double currentGlobalPower = this.getSteadyStatePower(n, asked, parameters.getScalingConvention());
        double variationAsked = Scalable.getVariationAsked(parameters, asked, currentGlobalPower);
        double done = 0.0;
        double remaining = variationAsked;
        for (Scalable scalable : this.scalables) {
            if (!(Math.abs(remaining) > 1.0E-5)) continue;
            double v = scalable.scale(n, remaining, parameters);
            done += v;
            remaining -= v;
        }
        return done;
    }

    @Override
    public double getSteadyStatePower(Network network, double asked, Scalable.ScalingConvention scalingConvention) {
        return this.scalables.stream().mapToDouble(scalable -> scalable.getSteadyStatePower(network, asked, scalingConvention)).sum();
    }
}

