/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.scalable;

import com.powsybl.iidm.modification.scalable.AbstractScalable;
import com.powsybl.iidm.modification.scalable.Scalable;
import com.powsybl.iidm.modification.scalable.ScalingParameters;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Network;
import java.util.List;
import java.util.Objects;

class UpDownScalable
extends AbstractScalable {
    private final Scalable upScalable;
    private final Scalable downScalable;

    public UpDownScalable(Scalable upScalable, Scalable downScalable) {
        this.upScalable = Objects.requireNonNull(upScalable);
        this.downScalable = Objects.requireNonNull(downScalable);
    }

    @Override
    public double initialValue(Network n) {
        return this.upScalable.initialValue(n) + this.downScalable.initialValue(n);
    }

    @Override
    public void reset(Network n) {
        this.upScalable.reset(n);
        this.downScalable.reset(n);
    }

    @Override
    public double maximumValue(Network n, Scalable.ScalingConvention scalingConvention) {
        if (scalingConvention == Scalable.ScalingConvention.LOAD) {
            return this.downScalable.maximumValue(n, scalingConvention) - this.upScalable.initialValue(n);
        }
        return this.upScalable.maximumValue(n, scalingConvention) + this.downScalable.initialValue(n);
    }

    @Override
    public double minimumValue(Network n, Scalable.ScalingConvention scalingConvention) {
        if (scalingConvention == Scalable.ScalingConvention.LOAD) {
            return this.upScalable.minimumValue(n, scalingConvention) - this.downScalable.initialValue(n);
        }
        return this.downScalable.minimumValue(n, scalingConvention) + this.upScalable.initialValue(n);
    }

    @Override
    public void filterInjections(Network network, List<Injection> injections, List<String> notFound) {
        this.upScalable.filterInjections(network, injections, notFound);
        this.downScalable.filterInjections(network, injections, notFound);
    }

    @Override
    public double scale(Network n, double asked, ScalingParameters parameters) {
        return asked > 0.0 ? this.upScalable.scale(n, asked, parameters) : this.downScalable.scale(n, asked, parameters);
    }

    @Override
    public double getSteadyStatePower(Network network, double asked, Scalable.ScalingConvention scalingConvention) {
        return asked > 0.0 ? this.upScalable.getSteadyStatePower(network, asked, scalingConvention) : this.downScalable.getSteadyStatePower(network, asked, scalingConvention);
    }
}

