/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.tapchanger;

import com.powsybl.commons.reporter.Reporter;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractTapPositionModification
extends AbstractNetworkModification {
    public static final String TRANSFORMER_STR = "Transformer '";
    private final String transformerId;
    private final int tapPosition;
    private final ThreeWindingsTransformer.Side legSide;

    protected AbstractTapPositionModification(String transformerId, int tapPosition, ThreeWindingsTransformer.Side legSide) {
        this.transformerId = Objects.requireNonNull(transformerId);
        this.tapPosition = tapPosition;
        this.legSide = legSide;
    }

    abstract void applyTwoWindingsTransformer(Network var1, TwoWindingsTransformer var2, boolean var3);

    abstract void applyThreeWindingsTransformer(Network var1, ThreeWindingsTransformer var2, boolean var3);

    @Override
    public void apply(Network network, boolean throwException, ComputationManager computationManager, Reporter reporter) {
        TwoWindingsTransformer twoWindingsTransformer = network.getTwoWindingsTransformer(this.getTransformerId());
        ThreeWindingsTransformer threeWindingsTransformer = network.getThreeWindingsTransformer(this.getTransformerId());
        if (threeWindingsTransformer != null) {
            this.applyThreeWindingsTransformer(network, threeWindingsTransformer, throwException);
        } else if (twoWindingsTransformer != null) {
            this.applyTwoWindingsTransformer(network, twoWindingsTransformer, throwException);
        } else {
            this.logOrThrow(throwException, "No matching transformer found with ID:" + this.getTransformerId());
        }
    }

    protected ThreeWindingsTransformer.Leg getLeg(ThreeWindingsTransformer threeWindingsTransformer, Predicate<ThreeWindingsTransformer.Leg> isTapHolder, boolean throwException) {
        if (threeWindingsTransformer == null) {
            return null;
        }
        if (this.legSide != null) {
            return threeWindingsTransformer.getLeg(this.legSide);
        }
        Set validLegs = threeWindingsTransformer.getLegStream().filter(isTapHolder).collect(Collectors.toSet());
        if (validLegs.size() > 1) {
            this.logOrThrow(throwException, "Multiple valid legs found.");
            return null;
        }
        if (validLegs.isEmpty()) {
            this.logOrThrow(throwException, "No valid legs found.");
            return null;
        }
        return (ThreeWindingsTransformer.Leg)validLegs.iterator().next();
    }

    public String getTransformerId() {
        return this.transformerId;
    }

    public int getTapPosition() {
        return this.tapPosition;
    }

    public Optional<ThreeWindingsTransformer.Side> getOptionalLeg() {
        return Optional.ofNullable(this.legSide);
    }

    public ThreeWindingsTransformer.Side getLegSide() {
        return this.legSide;
    }
}

