/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.topology;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.reporter.Reporter;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.topology.RemoveFeederBay;
import com.powsybl.iidm.modification.topology.TopologyModificationUtils;
import com.powsybl.iidm.modification.util.ModificationReports;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.LineAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.VoltageLevel;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceTeePointByVoltageLevelOnLine
extends AbstractNetworkModification {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplaceTeePointByVoltageLevelOnLine.class);
    private final String teePointLine1Id;
    private final String teePointLine2Id;
    private final String teePointLineToRemoveId;
    private final String bbsOrBusId;
    private final String newLine1Id;
    private final String newLine1Name;
    private final String newLine2Id;
    private final String newLine2Name;
    private static final String LINE_NOT_FOUND_REPORT_MESSAGE = "Line %s is not found";
    private static final String LINE_NOT_FOUND_LOG_MESSAGE = "Line {} is not found";
    private static final String LINE_REMOVED_LOG_MESSAGE = "Line {} removed";

    ReplaceTeePointByVoltageLevelOnLine(String teePointLine1Id, String teePointLine2Id, String teePointLineToRemoveId, String bbsOrBusId, String newLine1Id, String newLine1Name, String newLine2Id, String newLine2Name) {
        this.teePointLine1Id = Objects.requireNonNull(teePointLine1Id);
        this.teePointLine2Id = Objects.requireNonNull(teePointLine2Id);
        this.teePointLineToRemoveId = Objects.requireNonNull(teePointLineToRemoveId);
        this.bbsOrBusId = Objects.requireNonNull(bbsOrBusId);
        this.newLine1Id = Objects.requireNonNull(newLine1Id);
        this.newLine1Name = newLine1Name;
        this.newLine2Id = Objects.requireNonNull(newLine2Id);
        this.newLine2Name = newLine2Name;
    }

    public String getTeePointLine1Id() {
        return this.teePointLine1Id;
    }

    public String getTeePointLine2Id() {
        return this.teePointLine2Id;
    }

    public String getTeePointLineToRemoveId() {
        return this.teePointLineToRemoveId;
    }

    public String getBbsOrBusId() {
        return this.bbsOrBusId;
    }

    public String getNewLine1Id() {
        return this.newLine1Id;
    }

    public String getNewLine1Name() {
        return this.newLine1Name;
    }

    public String getNewLine2Id() {
        return this.newLine2Id;
    }

    public String getNewLine2Name() {
        return this.newLine2Name;
    }

    @Override
    public void apply(Network network, boolean throwException, ComputationManager computationManager, Reporter reporter) {
        Line tpLine1 = network.getLine(this.teePointLine1Id);
        if (tpLine1 == null) {
            ModificationReports.notFoundLineReport(reporter, this.teePointLine1Id);
            LOGGER.error(LINE_NOT_FOUND_LOG_MESSAGE, (Object)this.teePointLine1Id);
            if (throwException) {
                throw new PowsyblException(String.format(LINE_NOT_FOUND_REPORT_MESSAGE, this.teePointLine1Id));
            }
            return;
        }
        Line tpLine2 = network.getLine(this.teePointLine2Id);
        if (tpLine2 == null) {
            ModificationReports.notFoundLineReport(reporter, this.teePointLine2Id);
            LOGGER.error(LINE_NOT_FOUND_LOG_MESSAGE, (Object)this.teePointLine2Id);
            if (throwException) {
                throw new PowsyblException(String.format(LINE_NOT_FOUND_REPORT_MESSAGE, this.teePointLine2Id));
            }
            return;
        }
        Line tpLineToRemove = network.getLine(this.teePointLineToRemoveId);
        if (tpLineToRemove == null) {
            ModificationReports.notFoundLineReport(reporter, this.teePointLineToRemoveId);
            LOGGER.error(LINE_NOT_FOUND_LOG_MESSAGE, (Object)this.teePointLineToRemoveId);
            if (throwException) {
                throw new PowsyblException(String.format(LINE_NOT_FOUND_REPORT_MESSAGE, this.teePointLineToRemoveId));
            }
            return;
        }
        VoltageLevel teePoint = TopologyModificationUtils.findTeePoint(tpLine1, tpLine2, tpLineToRemove);
        if (teePoint == null) {
            ModificationReports.noTeePointAndOrTappedVoltageLevelReport(reporter, this.teePointLine1Id, this.teePointLine2Id, this.teePointLineToRemoveId);
            LOGGER.error("Unable to find the tee point and the tapped voltage level from lines {}, {} and {}", new Object[]{this.teePointLine1Id, this.teePointLine2Id, this.teePointLineToRemoveId});
            if (throwException) {
                throw new PowsyblException(String.format("Unable to find the tee point and the tapped voltage level from lines %s, %s and %s", this.teePointLine1Id, this.teePointLine2Id, this.teePointLineToRemoveId));
            }
            return;
        }
        VoltageLevel tappedVoltageLevel = tpLineToRemove.getTerminal1().getVoltageLevel() == teePoint ? tpLineToRemove.getTerminal2().getVoltageLevel() : tpLineToRemove.getTerminal1().getVoltageLevel();
        Branch.Side tpLine1OtherVlSide = tpLine1.getTerminal1().getVoltageLevel() == teePoint ? Branch.Side.TWO : Branch.Side.ONE;
        Branch.Side tpLine2OtherVlSide = tpLine2.getTerminal1().getVoltageLevel() == teePoint ? Branch.Side.TWO : Branch.Side.ONE;
        LineAdder newLine1Adder = TopologyModificationUtils.createLineAdder(this.newLine1Id, this.newLine1Name, tpLine1.getTerminal(tpLine1OtherVlSide).getVoltageLevel().getId(), tappedVoltageLevel.getId(), network, tpLine1, tpLineToRemove);
        LineAdder newLine2Adder = TopologyModificationUtils.createLineAdder(this.newLine2Id, this.newLine2Name, tappedVoltageLevel.getId(), tpLine2.getTerminal(tpLine2OtherVlSide).getVoltageLevel().getId(), network, tpLine2, tpLineToRemove);
        TopologyModificationUtils.attachLine(tpLine1.getTerminal(tpLine1OtherVlSide), newLine1Adder, (bus, adder) -> adder.setConnectableBus1(bus.getId()), (bus, adder) -> adder.setBus1(bus.getId()), (node, adder) -> adder.setNode1(node.intValue()));
        TopologyModificationUtils.attachLine(tpLine2.getTerminal(tpLine2OtherVlSide), newLine2Adder, (bus, adder) -> adder.setConnectableBus2(bus.getId()), (bus, adder) -> adder.setBus2(bus.getId()), (node, adder) -> adder.setNode2(node.intValue()));
        TopologyKind topologyKind = tappedVoltageLevel.getTopologyKind();
        if (topologyKind == TopologyKind.BUS_BREAKER) {
            Bus bus2 = tappedVoltageLevel.getBusBreakerView().getBus(this.bbsOrBusId);
            if (bus2 == null) {
                ModificationReports.notFoundBusInVoltageLevelReport(reporter, this.bbsOrBusId, tappedVoltageLevel.getId());
                LOGGER.error("Bus {} is not found in voltage level {}", (Object)this.bbsOrBusId, (Object)tappedVoltageLevel.getId());
                if (throwException) {
                    throw new PowsyblException(String.format("Bus %s is not found in voltage level %s", this.bbsOrBusId, tappedVoltageLevel.getId()));
                }
                return;
            }
            Bus bus1 = ((BusAdder)tappedVoltageLevel.getBusBreakerView().newBus().setId(this.newLine1Id + "_BUS_1")).add();
            Bus bus22 = ((BusAdder)tappedVoltageLevel.getBusBreakerView().newBus().setId(this.newLine2Id + "_BUS_2")).add();
            TopologyModificationUtils.createBusBreakerSwitches(bus1.getId(), bus2.getId(), bus22.getId(), this.bbsOrBusId, tappedVoltageLevel.getBusBreakerView());
            newLine1Adder.setBus2(bus1.getId());
            newLine1Adder.setConnectableBus2(bus1.getId());
            newLine2Adder.setBus1(bus22.getId());
            newLine2Adder.setConnectableBus1(bus22.getId());
        } else if (topologyKind == TopologyKind.NODE_BREAKER) {
            BusbarSection bbs = tappedVoltageLevel.getNodeBreakerView().getBusbarSection(this.bbsOrBusId);
            if (bbs == null) {
                ModificationReports.notFoundBusbarSectionInVoltageLevelReport(reporter, this.bbsOrBusId, tappedVoltageLevel.getId());
                LOGGER.error("Busbar section {} is not found in voltage level {}", (Object)this.bbsOrBusId, (Object)tappedVoltageLevel.getId());
                if (throwException) {
                    throw new PowsyblException(String.format("Busbar section %s is not found in voltage level %s", this.bbsOrBusId, tappedVoltageLevel.getId()));
                }
                return;
            }
            int bbsNode = bbs.getTerminal().getNodeBreakerView().getNode();
            int firstAvailableNode = tappedVoltageLevel.getNodeBreakerView().getMaximumNodeIndex() + 1;
            TopologyModificationUtils.createNodeBreakerSwitches(firstAvailableNode, firstAvailableNode + 1, bbsNode, "_1", this.newLine1Id, tappedVoltageLevel.getNodeBreakerView());
            TopologyModificationUtils.createNodeBreakerSwitches(firstAvailableNode + 3, firstAvailableNode + 2, bbsNode, "_2", this.newLine2Id, tappedVoltageLevel.getNodeBreakerView());
            newLine1Adder.setNode2(firstAvailableNode);
            newLine2Adder.setNode1(firstAvailableNode + 3);
        }
        Branch.Side tpLine1Limits1Side = tpLine1OtherVlSide;
        Branch.Side tpLine1Limits2Side = tpLine1OtherVlSide == Branch.Side.ONE ? Branch.Side.TWO : Branch.Side.ONE;
        TopologyModificationUtils.LoadingLimitsBags limits1TpLine1 = new TopologyModificationUtils.LoadingLimitsBags(() -> tpLine1.getActivePowerLimits(tpLine1Limits1Side), () -> tpLine1.getApparentPowerLimits(tpLine1Limits1Side), () -> tpLine1.getCurrentLimits(tpLine1Limits1Side));
        TopologyModificationUtils.LoadingLimitsBags limits2TpLine1 = new TopologyModificationUtils.LoadingLimitsBags(() -> tpLine1.getActivePowerLimits(tpLine1Limits2Side), () -> tpLine1.getApparentPowerLimits(tpLine1Limits2Side), () -> tpLine1.getCurrentLimits(tpLine1Limits2Side));
        Branch.Side tpLine2Limits1Side = tpLine2OtherVlSide == Branch.Side.ONE ? Branch.Side.TWO : Branch.Side.ONE;
        Branch.Side tpLine2Limits2Side = tpLine2OtherVlSide;
        TopologyModificationUtils.LoadingLimitsBags limits1TpLine2 = new TopologyModificationUtils.LoadingLimitsBags(() -> tpLine2.getActivePowerLimits(tpLine2Limits1Side), () -> tpLine2.getApparentPowerLimits(tpLine2Limits1Side), () -> tpLine2.getCurrentLimits(tpLine2Limits1Side));
        TopologyModificationUtils.LoadingLimitsBags limits2TpLine2 = new TopologyModificationUtils.LoadingLimitsBags(() -> tpLine2.getActivePowerLimits(tpLine2Limits2Side), () -> tpLine2.getApparentPowerLimits(tpLine2Limits2Side), () -> tpLine2.getCurrentLimits(tpLine2Limits2Side));
        tpLine1.remove();
        ModificationReports.removedLineReport(reporter, this.teePointLine1Id);
        LOGGER.info(LINE_REMOVED_LOG_MESSAGE, (Object)this.teePointLine1Id);
        tpLine2.remove();
        ModificationReports.removedLineReport(reporter, this.teePointLine2Id);
        LOGGER.info(LINE_REMOVED_LOG_MESSAGE, (Object)this.teePointLine2Id);
        new RemoveFeederBay(tpLineToRemove.getId()).apply(network, throwException, computationManager, reporter);
        ModificationReports.removedLineReport(reporter, this.teePointLineToRemoveId);
        LOGGER.info(LINE_REMOVED_LOG_MESSAGE, (Object)this.teePointLineToRemoveId);
        Line newLine1 = newLine1Adder.add();
        TopologyModificationUtils.addLoadingLimits(newLine1, limits1TpLine1, Branch.Side.ONE);
        TopologyModificationUtils.addLoadingLimits(newLine1, limits2TpLine1, Branch.Side.TWO);
        ModificationReports.createdLineReport(reporter, this.newLine1Id);
        LOGGER.info("Line {} created", (Object)this.newLine1Id);
        Line newLine2 = newLine2Adder.add();
        TopologyModificationUtils.addLoadingLimits(newLine2, limits1TpLine2, Branch.Side.ONE);
        TopologyModificationUtils.addLoadingLimits(newLine2, limits2TpLine2, Branch.Side.TWO);
        ModificationReports.createdLineReport(reporter, this.newLine2Id);
        LOGGER.info("Line {} created", (Object)this.newLine2Id);
        TopologyModificationUtils.removeVoltageLevelAndSubstation(teePoint, reporter);
    }
}

