/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.topology;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.reporter.Reporter;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.topology.TopologyModificationUtils;
import com.powsybl.iidm.modification.util.ModificationReports;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.LineAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.VoltageLevel;
import java.util.HashSet;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevertConnectVoltageLevelOnLine
extends AbstractNetworkModification {
    private static final Logger LOG = LoggerFactory.getLogger(RevertConnectVoltageLevelOnLine.class);
    private final String line1Id;
    private final String line2Id;
    private final String lineId;
    private final String lineName;

    RevertConnectVoltageLevelOnLine(String line1Id, String line2Id, String lineId, String lineName) {
        this.line1Id = Objects.requireNonNull(line1Id);
        this.line2Id = Objects.requireNonNull(line2Id);
        this.lineId = Objects.requireNonNull(lineId);
        this.lineName = lineName;
    }

    private static Line checkAndGetLine(Network network, String lineId, Reporter reporter, boolean throwException) {
        Line line = network.getLine(lineId);
        if (line == null) {
            ModificationReports.notFoundLineReport(reporter, lineId);
            LOG.error("Line {} is not found", (Object)lineId);
            if (throwException) {
                throw new PowsyblException(String.format("Line %s is not found", lineId));
            }
        }
        return line;
    }

    @Override
    public void apply(Network network, boolean throwException, ComputationManager computationManager, Reporter reporter) {
        Line line1 = RevertConnectVoltageLevelOnLine.checkAndGetLine(network, this.line1Id, reporter, throwException);
        Line line2 = RevertConnectVoltageLevelOnLine.checkAndGetLine(network, this.line2Id, reporter, throwException);
        if (line1 == null || line2 == null) {
            return;
        }
        HashSet<String> vlIds = new HashSet<String>();
        String line1VlId1 = line1.getTerminal1().getVoltageLevel().getId();
        String line1VlId2 = line1.getTerminal2().getVoltageLevel().getId();
        String line2VlId1 = line2.getTerminal1().getVoltageLevel().getId();
        String line2VlId2 = line2.getTerminal2().getVoltageLevel().getId();
        String commonVlId = "";
        vlIds.add(line1VlId1);
        if (!vlIds.add(line1VlId2)) {
            commonVlId = line1VlId2;
        }
        if (!vlIds.add(line2VlId1)) {
            commonVlId = line2VlId1;
        }
        if (!vlIds.add(line2VlId2)) {
            commonVlId = line2VlId2;
        }
        if (vlIds.size() != 3) {
            ModificationReports.noVoltageLevelInCommonReport(reporter, this.line1Id, this.line2Id);
            LOG.error("Lines {} and {} should have one and only one voltage level in common at their extremities", (Object)this.line1Id, (Object)this.line2Id);
            if (throwException) {
                throw new PowsyblException(String.format("Lines %s and %s should have one and only one voltage level in common at their extremities", this.line1Id, this.line2Id));
            }
            return;
        }
        VoltageLevel commonVl = network.getVoltageLevel(commonVlId);
        Branch.Side line1Side1 = line1VlId1.equals(commonVlId) ? Branch.Side.TWO : Branch.Side.ONE;
        Branch.Side line1Side2 = line1Side1 == Branch.Side.ONE ? Branch.Side.TWO : Branch.Side.ONE;
        Branch.Side line2Side2 = line2VlId1.equals(commonVlId) ? Branch.Side.TWO : Branch.Side.ONE;
        Branch.Side line2Side1 = line2Side2 == Branch.Side.ONE ? Branch.Side.TWO : Branch.Side.ONE;
        LineAdder lineAdder = TopologyModificationUtils.createLineAdder(this.lineId, this.lineName, line1Side1 == Branch.Side.TWO ? line1VlId2 : line1VlId1, line2Side2 == Branch.Side.TWO ? line2VlId2 : line2VlId1, network, line1, line2);
        TopologyModificationUtils.attachLine(line1.getTerminal(line1Side1), lineAdder, (bus, adder) -> adder.setConnectableBus1(bus.getId()), (bus, adder) -> adder.setBus1(bus.getId()), (node, adder) -> adder.setNode1(node.intValue()));
        TopologyModificationUtils.attachLine(line2.getTerminal(line2Side2), lineAdder, (bus, adder) -> adder.setConnectableBus2(bus.getId()), (bus, adder) -> adder.setBus2(bus.getId()), (node, adder) -> adder.setNode2(node.intValue()));
        TopologyModificationUtils.LoadingLimitsBags limitsLine1Side1 = new TopologyModificationUtils.LoadingLimitsBags(() -> line1.getActivePowerLimits(line1Side1), () -> line1.getApparentPowerLimits(line1Side1), () -> line1.getCurrentLimits(line1Side1));
        TopologyModificationUtils.LoadingLimitsBags limitsLine1Side2 = new TopologyModificationUtils.LoadingLimitsBags(() -> line1.getActivePowerLimits(line1Side2), () -> line1.getApparentPowerLimits(line1Side2), () -> line1.getCurrentLimits(line1Side2));
        TopologyModificationUtils.LoadingLimitsBags limitsLine2Side1 = new TopologyModificationUtils.LoadingLimitsBags(() -> line2.getActivePowerLimits(line2Side1), () -> line2.getApparentPowerLimits(line2Side1), () -> line2.getCurrentLimits(line2Side1));
        TopologyModificationUtils.LoadingLimitsBags limitsLine2Side2 = new TopologyModificationUtils.LoadingLimitsBags(() -> line2.getActivePowerLimits(line2Side2), () -> line2.getApparentPowerLimits(line2Side2), () -> line2.getCurrentLimits(line2Side2));
        line1.remove();
        ModificationReports.removedLineReport(reporter, this.line1Id);
        LOG.info("Line {} removed", (Object)this.line1Id);
        line2.remove();
        ModificationReports.removedLineReport(reporter, this.line2Id);
        LOG.info("Line {} removed", (Object)this.line2Id);
        Line line = lineAdder.add();
        TopologyModificationUtils.LoadingLimitsBags limitsSide1 = TopologyModificationUtils.mergeLimits(this.line1Id, limitsLine1Side1, limitsLine1Side2, reporter);
        TopologyModificationUtils.LoadingLimitsBags limitsSide2 = TopologyModificationUtils.mergeLimits(this.line2Id, limitsLine2Side2, limitsLine2Side1, reporter);
        TopologyModificationUtils.addLoadingLimits(line, limitsSide1, Branch.Side.ONE);
        TopologyModificationUtils.addLoadingLimits(line, limitsSide2, Branch.Side.TWO);
        ModificationReports.createdLineReport(reporter, this.lineId);
        LOG.info("New line {} created, replacing lines {} and {}", new Object[]{this.lineId, this.line1Id, this.line2Id});
        TopologyModificationUtils.removeVoltageLevelAndSubstation(commonVl, reporter);
    }

    public String getLine1Id() {
        return this.line1Id;
    }

    public String getLine2Id() {
        return this.line2Id;
    }

    public String getLineId() {
        return this.lineId;
    }

    public String getLineName() {
        return this.lineName;
    }
}

