/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.topology;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.reporter.Reporter;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.topology.TopologyModificationUtils;
import com.powsybl.iidm.modification.util.ModificationReports;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.LineAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.VoltageLevel;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevertCreateLineOnLine
extends AbstractNetworkModification {
    private static final Logger LOG = LoggerFactory.getLogger(RevertCreateLineOnLine.class);
    private String lineToBeMerged1Id;
    private String lineToBeMerged2Id;
    private String lineToBeDeletedId;
    private String mergedLineId;
    private String mergedLineName;
    private static final String LINE_NOT_FOUND_REPORT_MESSAGE = "Line %s is not found";
    private static final String LINE_REMOVED_MESSAGE = "Line {} removed";

    RevertCreateLineOnLine(String lineToBeMerged1Id, String lineToBeMerged2Id, String lineToBeDeletedId, String mergedLineId, String mergedLineName) {
        this.lineToBeMerged1Id = Objects.requireNonNull(lineToBeMerged1Id);
        this.lineToBeMerged2Id = Objects.requireNonNull(lineToBeMerged2Id);
        this.lineToBeDeletedId = Objects.requireNonNull(lineToBeDeletedId);
        this.mergedLineId = Objects.requireNonNull(mergedLineId);
        this.mergedLineName = mergedLineName;
    }

    public RevertCreateLineOnLine setLineToBeMerged1Id(String lineToBeMerged1Id) {
        this.lineToBeMerged1Id = Objects.requireNonNull(lineToBeMerged1Id);
        return this;
    }

    public RevertCreateLineOnLine setLineToBeMerged2Id(String lineToBeMerged2Id) {
        this.lineToBeMerged2Id = Objects.requireNonNull(lineToBeMerged2Id);
        return this;
    }

    public RevertCreateLineOnLine setLineToBeDeletedId(String lineToBeDeletedId) {
        this.lineToBeDeletedId = Objects.requireNonNull(lineToBeDeletedId);
        return this;
    }

    public RevertCreateLineOnLine setMergedLineId(String mergedLineId) {
        this.mergedLineId = Objects.requireNonNull(mergedLineId);
        return this;
    }

    public RevertCreateLineOnLine setMergedLineName(String mergedLineName) {
        this.mergedLineName = mergedLineName;
        return this;
    }

    private static Line checkAndGetLine(Network network, String lineId, Reporter reporter, boolean throwException) {
        Line line = network.getLine(lineId);
        if (line == null) {
            ModificationReports.notFoundLineReport(reporter, lineId);
            LOG.error("Line {} is not found", (Object)lineId);
            if (throwException) {
                throw new PowsyblException(String.format(LINE_NOT_FOUND_REPORT_MESSAGE, lineId));
            }
        }
        return line;
    }

    @Override
    public void apply(Network network, boolean throwException, ComputationManager computationManager, Reporter reporter) {
        Line lineToBeMerged1 = RevertCreateLineOnLine.checkAndGetLine(network, this.lineToBeMerged1Id, reporter, throwException);
        Line lineToBeMerged2 = RevertCreateLineOnLine.checkAndGetLine(network, this.lineToBeMerged2Id, reporter, throwException);
        Line lineToBeDeleted = RevertCreateLineOnLine.checkAndGetLine(network, this.lineToBeDeletedId, reporter, throwException);
        if (lineToBeMerged1 == null || lineToBeMerged2 == null || lineToBeDeleted == null) {
            return;
        }
        VoltageLevel teePoint = TopologyModificationUtils.findTeePoint(lineToBeMerged1, lineToBeMerged2, lineToBeDeleted);
        if (teePoint == null) {
            ModificationReports.noTeePointAndOrTappedVoltageLevelReport(reporter, this.lineToBeMerged1Id, this.lineToBeMerged2Id, this.lineToBeDeletedId);
            LOG.error("Unable to find the tee point and the tapped voltage level from lines {}, {} and {}", new Object[]{this.lineToBeMerged1Id, this.lineToBeMerged2Id, this.lineToBeDeletedId});
            if (throwException) {
                throw new PowsyblException(String.format("Unable to find the attachment point and the tapped voltage level from lines %s, %s and %s", this.lineToBeMerged1Id, this.lineToBeMerged2Id, this.lineToBeDeletedId));
            }
            return;
        }
        VoltageLevel tappedVoltageLevel = lineToBeDeleted.getTerminal1().getVoltageLevel() == teePoint ? lineToBeDeleted.getTerminal2().getVoltageLevel() : lineToBeDeleted.getTerminal1().getVoltageLevel();
        Branch.Side newLineSide1 = lineToBeMerged1.getTerminal1().getVoltageLevel() == teePoint ? Branch.Side.TWO : Branch.Side.ONE;
        Branch.Side newLineSide2 = lineToBeMerged2.getTerminal1().getVoltageLevel() == teePoint ? Branch.Side.TWO : Branch.Side.ONE;
        LineAdder lineAdder = TopologyModificationUtils.createLineAdder(this.mergedLineId, this.mergedLineName, lineToBeMerged1.getTerminal(newLineSide1).getVoltageLevel().getId(), lineToBeMerged2.getTerminal(newLineSide2).getVoltageLevel().getId(), network, lineToBeMerged1, lineToBeMerged2);
        TopologyModificationUtils.attachLine(lineToBeMerged1.getTerminal(newLineSide1), lineAdder, (bus, adder) -> adder.setConnectableBus1(bus.getId()), (bus, adder) -> adder.setBus1(bus.getId()), (node, adder) -> adder.setNode1(node.intValue()));
        TopologyModificationUtils.attachLine(lineToBeMerged2.getTerminal(newLineSide2), lineAdder, (bus, adder) -> adder.setConnectableBus2(bus.getId()), (bus, adder) -> adder.setBus2(bus.getId()), (node, adder) -> adder.setNode2(node.intValue()));
        Branch.Side lineToBeMerged1Side1 = newLineSide1;
        Branch.Side lineToBeMerged1Side2 = newLineSide1 == Branch.Side.ONE ? Branch.Side.TWO : Branch.Side.ONE;
        TopologyModificationUtils.LoadingLimitsBags limitsLineToBeMerged1Side1 = new TopologyModificationUtils.LoadingLimitsBags(() -> lineToBeMerged1.getActivePowerLimits(lineToBeMerged1Side1), () -> lineToBeMerged1.getApparentPowerLimits(lineToBeMerged1Side1), () -> lineToBeMerged1.getCurrentLimits(lineToBeMerged1Side1));
        TopologyModificationUtils.LoadingLimitsBags limitsLineToBeMerged1Side2 = new TopologyModificationUtils.LoadingLimitsBags(() -> lineToBeMerged1.getActivePowerLimits(lineToBeMerged1Side2), () -> lineToBeMerged1.getApparentPowerLimits(lineToBeMerged1Side2), () -> lineToBeMerged1.getCurrentLimits(lineToBeMerged1Side2));
        Branch.Side lineToBeMerged2Side2 = newLineSide2;
        Branch.Side lineToBeMerged2Side1 = newLineSide2 == Branch.Side.ONE ? Branch.Side.TWO : Branch.Side.ONE;
        TopologyModificationUtils.LoadingLimitsBags limitsLineToBeMerged2Side1 = new TopologyModificationUtils.LoadingLimitsBags(() -> lineToBeMerged2.getActivePowerLimits(lineToBeMerged2Side1), () -> lineToBeMerged2.getApparentPowerLimits(lineToBeMerged2Side1), () -> lineToBeMerged2.getCurrentLimits(lineToBeMerged2Side1));
        TopologyModificationUtils.LoadingLimitsBags limitsLineToBeMerged2Side2 = new TopologyModificationUtils.LoadingLimitsBags(() -> lineToBeMerged2.getActivePowerLimits(lineToBeMerged2Side2), () -> lineToBeMerged2.getApparentPowerLimits(lineToBeMerged2Side2), () -> lineToBeMerged2.getCurrentLimits(lineToBeMerged2Side2));
        lineToBeMerged1.remove();
        ModificationReports.removedLineReport(reporter, this.lineToBeMerged1Id);
        LOG.info(LINE_REMOVED_MESSAGE, (Object)this.lineToBeMerged1Id);
        lineToBeMerged2.remove();
        ModificationReports.removedLineReport(reporter, this.lineToBeMerged2Id);
        LOG.info(LINE_REMOVED_MESSAGE, (Object)this.lineToBeMerged2Id);
        lineToBeDeleted.remove();
        ModificationReports.removedLineReport(reporter, this.lineToBeDeletedId);
        LOG.info(LINE_REMOVED_MESSAGE, (Object)this.lineToBeDeletedId);
        Line line = lineAdder.add();
        TopologyModificationUtils.LoadingLimitsBags limitsSide1 = TopologyModificationUtils.mergeLimits(this.lineToBeMerged1Id, limitsLineToBeMerged1Side1, limitsLineToBeMerged1Side2, reporter);
        TopologyModificationUtils.LoadingLimitsBags limitsSide2 = TopologyModificationUtils.mergeLimits(this.lineToBeMerged2Id, limitsLineToBeMerged2Side2, limitsLineToBeMerged2Side1, reporter);
        TopologyModificationUtils.addLoadingLimits(line, limitsSide1, Branch.Side.ONE);
        TopologyModificationUtils.addLoadingLimits(line, limitsSide2, Branch.Side.TWO);
        ModificationReports.createdLineReport(reporter, this.mergedLineId);
        LOG.info("New line {} created, replacing lines {}, {} and {}", new Object[]{this.mergedLineId, this.lineToBeMerged1Id, this.lineToBeMerged2Id, this.lineToBeDeletedId});
        TopologyModificationUtils.removeVoltageLevelAndSubstation(teePoint, reporter);
        TopologyModificationUtils.removeVoltageLevelAndSubstation(tappedVoltageLevel, reporter);
    }

    public String getLineToBeMerged1Id() {
        return this.lineToBeMerged1Id;
    }

    public String getLineToBeMerged2Id() {
        return this.lineToBeMerged2Id;
    }

    public String getLineToBeDeletedId() {
        return this.lineToBeDeletedId;
    }

    public String getMergedLineId() {
        return this.mergedLineId;
    }

    public String getMergedLineName() {
        return this.mergedLineName;
    }
}

