/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.tripping;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.reporter.Reporter;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.tripping.Tripping;
import com.powsybl.iidm.modification.tripping.TrippingTopologyTraverser;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.Terminal;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractTripping
extends AbstractNetworkModification
implements Tripping {
    protected final String id;

    protected AbstractTripping(String id) {
        this.id = Objects.requireNonNull(id);
    }

    public String getId() {
        return this.id;
    }

    @Override
    public void apply(Network network, boolean throwException, ComputationManager computationManager, Reporter reporter) {
        HashSet<Switch> switchesToOpen = new HashSet<Switch>();
        HashSet<Terminal> terminalsToDisconnect = new HashSet<Terminal>();
        this.traverse(network, switchesToOpen, terminalsToDisconnect);
        switchesToOpen.forEach(s -> s.setOpen(true));
        terminalsToDisconnect.forEach(Terminal::disconnect);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void traverseDoubleSidedEquipment(String voltageLevelId, Terminal terminal1, Terminal terminal2, Set<Switch> switchesToOpen, Set<Terminal> terminalsToDisconnect, Set<Terminal> traversedTerminals, String equipmentType) {
        if (voltageLevelId != null) {
            if (voltageLevelId.equals(terminal1.getVoltageLevel().getId())) {
                TrippingTopologyTraverser.traverse(terminal1, switchesToOpen, terminalsToDisconnect, traversedTerminals);
                return;
            } else {
                if (!voltageLevelId.equals(terminal2.getVoltageLevel().getId())) throw new PowsyblException("VoltageLevel '" + voltageLevelId + "' not connected to " + equipmentType + " '" + this.id + "'");
                TrippingTopologyTraverser.traverse(terminal2, switchesToOpen, terminalsToDisconnect, traversedTerminals);
            }
            return;
        } else {
            TrippingTopologyTraverser.traverse(terminal1, switchesToOpen, terminalsToDisconnect, traversedTerminals);
            TrippingTopologyTraverser.traverse(terminal2, switchesToOpen, terminalsToDisconnect, traversedTerminals);
        }
    }
}

