/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification;

import com.powsybl.commons.reporter.Reporter;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.ConnectGenerator;
import com.powsybl.iidm.modification.topology.NamingStrategy;
import com.powsybl.iidm.modification.util.VoltageRegulationUtils;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Network;
import java.util.Objects;

public class GeneratorModification
extends AbstractNetworkModification {
    private final String generatorId;
    private final Modifs modifs;

    public GeneratorModification(String generatorId, Modifs modifs) {
        this.generatorId = Objects.requireNonNull(generatorId);
        this.modifs = modifs;
    }

    @Override
    public void apply(Network network, NamingStrategy namingStrategy, boolean throwException, ComputationManager computationManager, Reporter reporter) {
        Generator g = network.getGenerator(this.generatorId);
        if (g == null) {
            this.logOrThrow(throwException, "Generator '" + this.generatorId + "' not found");
            return;
        }
        if (this.modifs.getMinP() != null) {
            g.setMinP(this.modifs.getMinP().doubleValue());
        }
        if (this.modifs.getMaxP() != null) {
            g.setMaxP(this.modifs.getMaxP().doubleValue());
        }
        if (this.modifs.getTargetV() != null) {
            g.setTargetV(this.modifs.getTargetV().doubleValue());
        }
        if (this.modifs.getTargetQ() != null) {
            g.setTargetQ(this.modifs.getTargetQ().doubleValue());
        }
        boolean skipOtherConnectionChange = false;
        if (this.modifs.getConnected() != null) {
            this.changeConnectionState(g, this.modifs.getConnected());
            skipOtherConnectionChange = true;
        }
        if (this.modifs.getVoltageRegulatorOn() != null) {
            if (Double.isNaN(g.getTargetV()) && this.modifs.getVoltageRegulatorOn().booleanValue()) {
                double plausibleTargetV = VoltageRegulationUtils.getTargetVForRegulatingElement(g.getNetwork(), g.getRegulatingTerminal().getBusView().getBus(), g.getId(), IdentifiableType.GENERATOR).orElse(g.getRegulatingTerminal().getBusView().getBus().getV());
                g.setTargetV(plausibleTargetV);
            }
            g.setVoltageRegulatorOn(this.modifs.getVoltageRegulatorOn().booleanValue());
        }
        if (this.modifs.getTargetP() != null) {
            this.setTargetPWithinBoundaries(g, this.modifs.getTargetP(), skipOtherConnectionChange);
        } else if (this.modifs.getDeltaTargetP() != null) {
            this.setTargetPWithinBoundaries(g, g.getTargetP() + this.modifs.getDeltaTargetP(), skipOtherConnectionChange);
        }
    }

    private void changeConnectionState(Generator g, boolean connect) {
        if (connect) {
            if (!g.getTerminal().isConnected()) {
                ConnectGenerator.connect(g);
            }
        } else if (g.getTerminal().isConnected()) {
            g.getTerminal().disconnect();
        }
    }

    private void setTargetPWithinBoundaries(Generator g, double targetP, boolean skipConnect) {
        if (!skipConnect) {
            this.changeConnectionState(g, true);
        }
        g.setTargetP(Math.min(g.getMaxP(), Math.max(g.getMinP(), targetP)));
    }

    public Modifs getModifs() {
        return this.modifs;
    }

    public String getGeneratorId() {
        return this.generatorId;
    }

    public static class Modifs {
        private Double minP;
        private Double maxP;
        private Double targetP;
        private Double deltaTargetP;
        private Double targetV;
        private Double targetQ;
        private Boolean voltageRegulatorOn;
        private Boolean connected;

        public Double getMinP() {
            return this.minP;
        }

        public void setMinP(Double minP) {
            this.minP = minP;
        }

        public Double getMaxP() {
            return this.maxP;
        }

        public void setMaxP(Double maxP) {
            this.maxP = maxP;
        }

        public Double getTargetP() {
            return this.targetP;
        }

        public void setTargetP(Double targetP) {
            this.targetP = targetP;
        }

        public Double getDeltaTargetP() {
            return this.deltaTargetP;
        }

        public void setDeltaTargetP(Double deltaTargetP) {
            this.deltaTargetP = deltaTargetP;
        }

        public Double getTargetV() {
            return this.targetV;
        }

        public void setTargetV(Double targetV) {
            this.targetV = targetV;
        }

        public Double getTargetQ() {
            return this.targetQ;
        }

        public void setTargetQ(Double targetQ) {
            this.targetQ = targetQ;
        }

        public Boolean getVoltageRegulatorOn() {
            return this.voltageRegulatorOn;
        }

        public void setVoltageRegulatorOn(Boolean voltageRegulatorOn) {
            this.voltageRegulatorOn = voltageRegulatorOn;
        }

        public Boolean getConnected() {
            return this.connected;
        }

        public void setConnected(Boolean connected) {
            this.connected = connected;
        }
    }
}

