/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification;

import com.powsybl.commons.reporter.Reporter;
import com.powsybl.iidm.modification.AbstractNetworkModification;
import com.powsybl.iidm.modification.util.ModificationReports;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Switch;
import java.util.Objects;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDisconnection
extends AbstractNetworkModification {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDisconnection.class);
    final String connectableId;
    final Predicate<Switch> openableSwitches;

    AbstractDisconnection(String connectableId, Predicate<Switch> openableSwitches) {
        this.connectableId = Objects.requireNonNull(connectableId);
        this.openableSwitches = openableSwitches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyModification(Network network, boolean isPlanned, Reporter reporter) {
        boolean hasBeenDisconnected;
        network.getReporterContext().pushReporter(reporter);
        Connectable connectable = network.getConnectable(this.connectableId);
        try {
            hasBeenDisconnected = connectable.disconnect(this.openableSwitches);
        }
        finally {
            network.getReporterContext().popReporter();
        }
        if (hasBeenDisconnected) {
            LOG.info("Connectable {} has been disconnected ({} disconnection).", (Object)this.connectableId, (Object)(isPlanned ? "planned" : "unplanned"));
        } else {
            LOG.info("Connectable {} has NOT been disconnected ({} disconnection).", (Object)this.connectableId, (Object)(isPlanned ? "planned" : "unplanned"));
        }
        ModificationReports.connectableDisconnectionReport(reporter, connectable, hasBeenDisconnected, isPlanned);
    }
}

