/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.modification.scalable;

import com.powsybl.iidm.modification.scalable.AbstractInjectionScalable;
import com.powsybl.iidm.modification.scalable.Scalable;
import com.powsybl.iidm.modification.scalable.ScalingParameters;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DanglingLineScalable
extends AbstractInjectionScalable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DanglingLineScalable.class);
    private final Scalable.ScalingConvention scalingConvention;

    DanglingLineScalable(String id) {
        this(id, -1.7976931348623157E308, Double.MAX_VALUE);
    }

    DanglingLineScalable(String id, Scalable.ScalingConvention scalingConvention) {
        this(id, -1.7976931348623157E308, Double.MAX_VALUE, scalingConvention);
    }

    DanglingLineScalable(String id, double minValue, double maxValue) {
        this(id, minValue, maxValue, Scalable.ScalingConvention.GENERATOR);
    }

    DanglingLineScalable(String id, double minValue, double maxValue, Scalable.ScalingConvention scalingConvention) {
        super(id, minValue, maxValue);
        this.scalingConvention = Objects.requireNonNull(scalingConvention);
    }

    @Override
    public void reset(Network n) {
        Objects.requireNonNull(n);
        DanglingLine dl = n.getDanglingLine(this.id);
        if (dl != null) {
            dl.setP0(0.0);
        }
    }

    @Override
    public double maximumValue(Network n, Scalable.ScalingConvention scalingConvention) {
        Objects.requireNonNull(n);
        Objects.requireNonNull(scalingConvention);
        DanglingLine dl = n.getDanglingLine(this.id);
        if (dl != null) {
            return scalingConvention == Scalable.ScalingConvention.LOAD ? this.maxValue : -this.minValue;
        }
        return 0.0;
    }

    @Override
    public double minimumValue(Network n, Scalable.ScalingConvention scalingConvention) {
        Objects.requireNonNull(n);
        Objects.requireNonNull(scalingConvention);
        DanglingLine dl = n.getDanglingLine(this.id);
        if (dl != null) {
            return scalingConvention == Scalable.ScalingConvention.LOAD ? this.minValue : -this.maxValue;
        }
        return 0.0;
    }

    @Override
    public void filterInjections(Network n, List<Injection> injections, List<String> notFoundInjections) {
        Objects.requireNonNull(n);
        Objects.requireNonNull(injections);
        DanglingLine dl = n.getDanglingLine(this.id);
        if (dl != null) {
            injections.add((Injection)dl);
        } else if (notFoundInjections != null) {
            notFoundInjections.add(this.id);
        }
    }

    @Override
    public double scale(Network n, double asked, ScalingParameters parameters) {
        double oldP0;
        Objects.requireNonNull(n);
        Objects.requireNonNull(parameters);
        DanglingLine dl = n.getDanglingLine(this.id);
        double done = 0.0;
        if (dl == null) {
            LOGGER.warn("Dangling line {} not found", (Object)this.id);
            return done;
        }
        Terminal t = dl.getTerminal();
        if (!t.isConnected()) {
            if (parameters.isReconnect()) {
                t.connect();
                LOGGER.info("Connecting {}", (Object)dl.getId());
            } else {
                LOGGER.info("Dangling line {} is not connected, discarded from scaling", (Object)dl.getId());
                return 0.0;
            }
        }
        if ((oldP0 = dl.getP0()) < this.minValue || oldP0 > this.maxValue) {
            LOGGER.error("Error scaling DanglingLineScalable {}: Initial P is not in the range [Pmin, Pmax]", (Object)this.id);
            return 0.0;
        }
        double availableDown = oldP0 - this.minValue;
        double availableUp = this.maxValue - oldP0;
        if (parameters.getScalingConvention() == Scalable.ScalingConvention.LOAD) {
            done = asked > 0.0 ? Math.min(asked, availableUp) : -Math.min(-asked, availableDown);
            dl.setP0(oldP0 + done);
        } else {
            done = asked > 0.0 ? Math.min(asked, availableDown) : -Math.min(-asked, availableUp);
            dl.setP0(oldP0 - done);
        }
        LOGGER.info("Change active power setpoint of {} from {} to {} ", new Object[]{dl.getId(), oldP0, dl.getP0()});
        return done;
    }

    @Override
    public double maximumValue(Network n) {
        return this.maximumValue(n, this.scalingConvention);
    }

    @Override
    public double minimumValue(Network n) {
        return this.minimumValue(n, this.scalingConvention);
    }

    @Override
    public double getSteadyStatePower(Network network, double asked, Scalable.ScalingConvention scalingConvention) {
        DanglingLine line = network.getDanglingLine(this.id);
        if (line == null) {
            LOGGER.warn("DanglingLine {} not found", (Object)this.id);
            return 0.0;
        }
        return scalingConvention == Scalable.ScalingConvention.LOAD ? line.getP0() : -line.getP0();
    }
}

